/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.track.challenges.IAchievedListener;
import com.turborilla.msm.track.challenges.IChallenge;
import java.util.Iterator;

public class ChallengeMonitorComponent
extends AbstractComponent {
    private BikeGameObject bike;
    private GameState gameState;

    public ChallengeMonitorComponent(BikeGameObject bikeGameObject, GameState gameState) {
        super(ChallengeMonitorComponent.class.getName());
        this.bike = bikeGameObject;
        this.gameState = gameState;
    }

    public void startMonitoring() {
        if (this.gameState == null || this.gameState.getTrack() == null) {
            return;
        }
        this.gameState.getTrack().initChallenges(this.gameState, this.bike);
    }

    public void stopMonitoring() {
        if (this.gameState == null || this.gameState.getTrack() == null) {
            return;
        }
        Iterator<IChallenge> iterator = this.gameState.getTrack().getChallengeIterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            IChallenge iChallenge = iterator.next();
            iChallenge.done();
        }
    }

    public void setAchievedListener(IAchievedListener iAchievedListener) {
        if (this.gameState == null || this.gameState.getTrack() == null) {
            return;
        }
        Iterator<IChallenge> iterator = this.gameState.getTrack().getChallengeIterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            IChallenge iChallenge = iterator.next();
            iChallenge.clearListeners();
            iChallenge.addAchievedListener(iAchievedListener);
        }
    }

    protected void componentUpdate(float f) {
        if (this.gameState == null || this.gameState.getTrack() == null) {
            return;
        }
        this.gameState.getTrack().updateChallenges(f);
    }
}

