/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.physics.objects.BikeWheel;

public class BrakeComponent
extends AbstractComponent {
    private boolean isBraking = false;
    private float maxBrakeValue = 30.0f;
    private float brakeValue = 0.0f;
    private float brakeStrength = 10.5f;
    private float brakingAmount = 0.0f;
    private BikeWheel wheel;
    private ThrottleComponent throttleComponent;
    private float brakeAlways = 0.0f;
    private boolean wasBraking = false;

    public BrakeComponent(String string, BikeWheel bikeWheel) {
        super(string);
        this.wheel = bikeWheel;
        this.setPriority(110);
        this.throttleComponent = null;
    }

    public BrakeComponent(String string, BikeWheel bikeWheel, ThrottleComponent throttleComponent) {
        this(string, bikeWheel);
        this.throttleComponent = throttleComponent;
    }

    public void braking(float f) {
        if (this.isPaused()) {
            return;
        }
        if (f < 0.1f) {
            return;
        }
        this.isBraking = true;
        this.brakingAmount = f;
    }

    protected void handleMessages(float f) {
    }

    protected void componentUpdate(float f) {
        if (this.isBraking && (this.throttleComponent == null || !this.throttleComponent.isThrottling()) || this.brakeAlways > Float.MIN_VALUE) {
            this.wasBraking = true;
            this.brakeValue += this.brakeStrength + this.brakeAlways;
            if (this.brakeValue > this.maxBrakeValue) {
                this.brakeValue = this.maxBrakeValue;
            }
            double d = this.brakeValue;
            this.wheel.setBrakeAmount(d);
            this.isBraking = false;
        } else if (this.wasBraking) {
            this.wheel.setBrakeAmount(0.0);
            this.wasBraking = false;
            this.brakeValue = 0.0f;
        }
    }

    public float getBrakeStrength() {
        return this.brakeStrength;
    }

    public void setBrakeStrength(float f) {
        this.brakeStrength = f;
    }

    public BikeWheel getWheel() {
        return this.wheel;
    }

    public void setWheel(BikeWheel bikeWheel) {
        this.wheel = bikeWheel;
    }

    public float getMaxBrakeValue() {
        return this.maxBrakeValue;
    }

    public void setMaxBrakeValue(float f) {
        this.maxBrakeValue = f;
    }

    public boolean isBraking() {
        return this.isBraking || this.wasBraking;
    }

    public float getBrakeAlways() {
        return this.brakeAlways;
    }

    public void setBrakeAlways(float f) {
        this.brakeAlways = f;
    }
}

