/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.physics.objects.Bike;

public class BoostComponent
extends SpecialAbilityComponent {
    private boolean boosting = false;
    protected boolean boostAll = false;
    protected float amountLeft;
    protected float initialAmount;
    private float strength;
    private float boostMagnitude = 0.0f;
    private boolean initialExplosion = true;
    protected Bike bike;
    private float explosionFactor = 20.0f;

    public BoostComponent(String string, float f, float f2, Bike bike) {
        super(string);
        this.amountLeft = this.initialAmount = f;
        this.strength = f2;
        this.bike = bike;
        this.setPriority(100);
    }

    protected void handleMessages(float f) {
    }

    public void triggerSpecialAbility() {
        this.boostAll();
        if (this.boostAll) {
            this.playSfx();
        }
        if (this.getTriggerListener() != null) {
            this.getTriggerListener().triggered(this);
        }
    }

    public void reset() {
        this.amountLeft = this.initialAmount;
        this.boosting = false;
        this.boostAll = false;
        this.boostStopped();
    }

    protected void componentUpdate(float f) {
        this.boostMagnitude = 0.0f;
        if (this.amountLeft <= 0.0f && (this.boosting || this.boostAll)) {
            this.boosting = false;
            this.boostAll = false;
            this.boostStopped();
        }
        if (this.boosting || this.boostAll) {
            this.amountLeft -= f;
            this.boostMagnitude = this.strength;
            this.boosting = false;
            if (this.initialExplosion && this.amountLeft > this.initialAmount * 0.98f) {
                this.boostMagnitude *= this.explosionFactor;
            }
        }
        this.setMagnitude(this.boostMagnitude);
    }

    protected void setMagnitude(float f) {
        this.bike.setBoostMagnitude(this.boostMagnitude);
    }

    public void boost() {
        if (this.isPaused() || this.amountLeft <= 0.0f || !this.isEnabled()) {
            return;
        }
        this.boosting = true;
    }

    public void boostAll() {
        if (this.isPaused() || this.amountLeft <= 0.0f || !this.isEnabled()) {
            return;
        }
        this.boostAll = true;
    }

    public void boostAll(float f) {
        if (this.isPaused() || !this.isEnabled()) {
            return;
        }
        this.amountLeft = f;
        this.boostAll = true;
    }

    public void addBoost(float f) {
        if (this.amountLeft < 0.0f) {
            this.amountLeft = 0.0f;
        }
        this.amountLeft += f;
    }

    public float getAmountLeft() {
        return this.amountLeft;
    }

    public void setAmountLeft(float f) {
        this.amountLeft = f;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float f) {
        this.strength = f;
    }

    protected void boostStopped() {
    }

    public boolean isInitialExplosion() {
        return this.initialExplosion;
    }

    public void setInitialExplosion(boolean bl) {
        this.initialExplosion = bl;
    }

    public void setInitialExplosion(boolean bl, float f) {
        this.initialExplosion = bl;
        this.explosionFactor = f;
    }
}

