/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.ConstraintDetectWrongBend;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.sound.CompositeSFX;
import java.util.ArrayList;

public class BoneBreakSoundComponent
extends AbstractComponent {
    private CompositeSFX sfx;
    private Bike bike;
    private ArrayList<ConstraintDetectWrongBend> triggers;
    private double threshold;
    private float leastTimeSinceCrash;

    public BoneBreakSoundComponent(String string, CompositeSFX compositeSFX, Bike bike, double d, float f) {
        super(string);
        this.sfx = compositeSFX;
        this.bike = bike;
        this.triggers = new ArrayList();
        this.threshold = d;
        this.leastTimeSinceCrash = f;
    }

    public void addTrigger(ConstraintDetectWrongBend constraintDetectWrongBend) {
        this.triggers.add(constraintDetectWrongBend);
    }

    public void clearTriggers() {
        this.triggers.clear();
    }

    protected void componentUpdate(float f) {
        if (this.bike.isCrashing() && !this.sfx.isPlaying() && this.bike.getRiderBeenCrashingForTime() > this.leastTimeSinceCrash) {
            for (int i = 0; i < this.triggers.size(); ++i) {
                ConstraintDetectWrongBend constraintDetectWrongBend = this.triggers.get(i);
                if (!(constraintDetectWrongBend.getViolationAmount() > this.threshold)) continue;
                this.sfx.play();
                constraintDetectWrongBend.setActive(false);
            }
        }
    }
}

