/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm;

import com.acarter.scenemonitor.SceneMonitor;
import com.jme.input.InputHandler;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.system.GameSettings;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jmex.game.state.GameStateManager;
import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.game.ExceptionHandler;
import com.turborilla.game.TurboJMEGame;
import com.turborilla.msm.ChangeDisplayModeEventListener;
import com.turborilla.msm.DisplayExceptionHandler;
import com.turborilla.msm.input.BreakPointAction;
import com.turborilla.msm.input.MenuAction;
import com.turborilla.msm.input.ReloadResourcesAction;
import com.turborilla.msm.loaders.CompositeSFXLoader;
import com.turborilla.msm.loaders.DivisionDescriptorLoader;
import com.turborilla.msm.loaders.FontLoader;
import com.turborilla.msm.loaders.ImageLoader;
import com.turborilla.msm.loaders.MaterialLoader;
import com.turborilla.msm.loaders.MusicLoader;
import com.turborilla.msm.loaders.ParallaxLoader;
import com.turborilla.msm.loaders.PropertiesLoader;
import com.turborilla.msm.loaders.ReplayAILoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.loaders.SFXLoader;
import com.turborilla.msm.loaders.SkinLoader;
import com.turborilla.msm.loaders.TextureLoader;
import com.turborilla.msm.loaders.Track1DLoader;
import com.turborilla.msm.loaders.TrackLoader;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.profile.ProgressData;
import com.turborilla.msm.statemachine.AbstractState;
import com.turborilla.msm.statemachine.ChooseTrack;
import com.turborilla.msm.statemachine.Countdown;
import com.turborilla.msm.statemachine.CreditsState;
import com.turborilla.msm.statemachine.Editor;
import com.turborilla.msm.statemachine.FadingTransitionGameState;
import com.turborilla.msm.statemachine.Finish;
import com.turborilla.msm.statemachine.GameOverState;
import com.turborilla.msm.statemachine.IngameMenu;
import com.turborilla.msm.statemachine.ManageReplay;
import com.turborilla.msm.statemachine.Menu;
import com.turborilla.msm.statemachine.QuitUpsell;
import com.turborilla.msm.statemachine.Race;
import com.turborilla.msm.statemachine.ReplayCountdown;
import com.turborilla.msm.statemachine.ReplayRace;
import com.turborilla.msm.statemachine.Results;
import com.turborilla.msm.statemachine.TimeAttackCountdown;
import com.turborilla.msm.statemachine.TimeAttackFinish;
import com.turborilla.msm.statemachine.TimeAttackMenu;
import com.turborilla.msm.statemachine.TimeAttackRace;
import com.turborilla.msm.statemachine.TimeAttackResults;
import com.turborilla.msm.statemachine.Upsell1;
import com.turborilla.msm.statemachine.ViewProfileStats;
import com.turborilla.msm.states.CreditsGameState;
import com.turborilla.msm.states.GameOverGameState;
import com.turborilla.msm.states.GlobalGameState;
import com.turborilla.msm.states.QuitEventListener;
import com.turborilla.msm.states.StartupGameState;
import com.turborilla.msm.states.StateEventListener;
import com.turborilla.msm.states.editor.EditorState;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.game.MusicPlayer;
import com.turborilla.msm.states.menus.BaseMenuState;
import com.turborilla.msm.states.menus.MenuState;
import com.turborilla.msm.states.menus.special.BetweenRacesGUIState;
import com.turborilla.msm.utils.SystemFolderGetter;
import com.turborilla.preferences.PreferencesGameSettingsWithDefaults;
import com.turborilla.statemachine.StateMachine;
import com.turborilla.utils.folders.SystemFolder;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import paulscode.sound.SoundSystemConfig;

public class Game {
    private static final Version version = Version.Demo;
    private static final String referrer = "padfile";
    private static final int DEFAULT_WINDOWED_WIDTH = 800;
    private static final int DEFAULT_WINDOWED_HEIGHT = 600;
    private static String gameName;
    private static PreferencesGameSettingsWithDefaults settings;
    private static TurboJMEGame game;
    private static boolean doFastStart;
    private static boolean doSceneMonitor;
    private static boolean doResetProfile;
    private static boolean doClearSettings;
    private static boolean simulationModeAvailable;
    private static int testVersion;
    private static int[] availableDemoVariants;
    private static final boolean doDemoSplitTest = true;
    private static final String winPurchaseURL = "";
    private static final String macPurchaseURL = "";
    private static final String linPurchaseURL = "";
    private static final String unknownPurchaseURL = "";
    private static final boolean showTurborillaLinks = true;
    private static final boolean showBuyButtons = true;
    private static final boolean enableSendReport = true;
    static int demoVariant;
    private static Calendar bestBefore;
    static Thread mainThread;

    public static void main(String[] stringArray) {
        int n;
        boolean bl;
        Object object;
        Game.redirectOutErr();
        gameName = "Mad Skills Motocross";
        String string = "www.madskillsmotocross.com";
        String string2 = "madskillsmotocross_database/msm_error_report.php";
        if (version == Version.ExternalTest) {
            bestBefore.set(2009, 9, 15);
            object = Calendar.getInstance();
            if (bestBefore.before(object)) {
                throw new RuntimeException("This version of Mad Skills Motocross is deprecated");
            }
        }
        if (bl = ((String)(object = System.getProperty("os.name").toLowerCase())).startsWith("mac os x")) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "MSM" + (version == Version.Demo ? " Demo" : ""));
        }
        if (version != Version.InternalTest) {
            ProgressData.cheatAllUnlocked = false;
        }
        SystemFolder.setFolderFactory(new SystemFolderGetter(gameName));
        SystemFolder.setCreateFolders(true);
        Game.initLogging();
        Game.unzipLauncher();
        Logger.getLogger(Game.class.getCanonicalName()).info(System.getProperties().toString());
        if (referrer == null || referrer.length() <= 0) {
            Logger.getLogger(Game.class.getCanonicalName()).info("Distributor: Turborilla");
        } else {
            Logger.getLogger(Game.class.getCanonicalName()).info("Distributor: padfile");
        }
        TextureManager.COMPRESS_BY_DEFAULT = false;
        Logger.getLogger(Game.class.getCanonicalName()).info("Starting game \"" + gameName + "\" Version: \"" + version.name() + "\"");
        settings = new PreferencesGameSettingsWithDefaults(Preferences.userRoot().node(gameName), "settings", "default.txt", "override.txt");
        mainThread = Thread.currentThread();
        if ((version == Version.ExternalTest || version == Version.InternalTest) && (n = settings.getInt("testVersion", 0)) < testVersion) {
            doClearSettings = true;
            doResetProfile = true;
        }
        if (doClearSettings) {
            try {
                settings.clear();
                settings = new PreferencesGameSettingsWithDefaults(Preferences.userRoot().node(gameName), "settings", "default.txt", "override.txt");
                if (version == Version.ExternalTest || version == Version.InternalTest) {
                    settings.setInt("testVersion", testVersion);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        settings.set("version", version.name());
        settings.set("showTurborillaLinks", Boolean.toString(true));
        settings.set("showBuyButtons", Boolean.toString(true));
        if (settings.get("timeOfFirstRun", null) == null) {
            settings.set("timeOfFirstRun", Game.getCurrentTimeString());
        }
        if ("null".equals(settings.get("demoVariant", "null"))) {
            n = (int)(Math.random() * (double)availableDemoVariants.length);
            settings.set("demoVariant", "" + availableDemoVariants[n]);
        }
        demoVariant = Integer.parseInt(settings.get("demoVariant", "0"));
        if (referrer != null && referrer.length() > 0 && "null".equals(settings.get("referrer", "null"))) {
            settings.set("referrer", referrer);
        }
        Game.saveBuildNumberToSettings();
        Logger.getLogger(Game.class.getCanonicalName()).info("Settings: \n" + settings.toString());
        if (settings.getBoolean("ChangingDisplayMode", false)) {
            Logger.getLogger(Game.class.getCanonicalName()).info("Game crashed when trying to set " + (settings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + settings.getWidth() + "x" + settings.getHeight() + "x" + settings.getDepth() + " @" + settings.getFrequency() + "Hz");
            settings.setInt("GameWidth", settings.getInt("SafeGameWidth", 800));
            settings.setInt("GameHeight", settings.getInt("SafeGameHeight", 600));
            settings.setInt("GameDepth", settings.getInt("SafeGameDepth", 32));
            settings.setInt("GameFrequency", settings.getInt("SafeGameFrequency", 60));
            settings.setBoolean("GameFullscreen", settings.getBoolean("SafeGameFullscreen", false));
            settings.setInt("GameDepthBits", settings.getInt("SafeGameDepthBits", 8));
            Logger.getLogger(Game.class.getCanonicalName()).info("Trying latest known safe display mode " + (settings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + settings.getWidth() + "x" + settings.getHeight() + "x" + settings.getDepth() + " @" + settings.getFrequency() + "Hz");
            settings.setBoolean("ChangingDisplayMode", false);
        } else {
            Game.setDefaultDisplayAsDesktop(settings);
            Logger.getLogger(Game.class.getCanonicalName()).info("Creating " + (settings.isFullscreen() ? "fullscreen" : "windowed") + " display: " + settings.getWidth() + "x" + settings.getHeight() + "x" + settings.getDepth() + " @" + settings.getFrequency() + "Hz");
        }
        if (stringArray.length > 0 && stringArray[0].toLowerCase().equals("javasound")) {
            settings.set("useOpenAL", "false");
            settings.set("noSound", "false");
        } else if (stringArray.length > 0 && stringArray[0].toLowerCase().equals("nosound")) {
            settings.set("useOpenAL", "false");
            settings.set("noSound", "true");
        } else {
            settings.set("useOpenAL", "true");
            settings.set("noSound", "false");
        }
        settings.setFramerate(60);
        settings.set("simulationModeAvailable", Boolean.toString(simulationModeAvailable));
        ResourceManager.setSettings(settings);
        ResourceManager resourceManager = ResourceManager.getInstance();
        resourceManager.setReloadEnabled(true);
        Game.initLoaders(resourceManager, settings);
        JoystickInput.setProvider("LWJGL");
        StartupGameState startupGameState = new StartupGameState("startupState", "Starting...", "italic_small_black");
        game = new TurboJMEGame(gameName, TurboJMEGame.GameType.GRAPHICAL, settings, null, startupGameState, string, string2);
        game.setUncaughtExceptionHandler(new DisplayExceptionHandler(game, string, string2, settings));
        game.start();
        CompositeSFXLoader compositeSFXLoader = new CompositeSFXLoader(game.getSoundSystem());
        compositeSFXLoader.addPath("sounds/sfx");
        resourceManager.registerLoader(compositeSFXLoader);
        SFXLoader sFXLoader = new SFXLoader(game.getSoundSystem());
        sFXLoader.addPath("sounds/data");
        sFXLoader.addPath("sounds/sfx");
        resourceManager.registerLoader(sFXLoader);
        GameStateManager.getInstance().attachChild(startupGameState);
        startupGameState.setActive(true);
        game.setDisplayStatistics(true);
        game.setUncaughtExceptionHandler(new ExceptionHandler(game, game.getGameName(), string, string2, settings));
        GameTaskQueueManager.getManager().update(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MouseInput.get().setCursorVisible(true);
                return null;
            }
        });
        GameStateManager gameStateManager = GameStateManager.getInstance();
        EventManager eventManager = new EventManager(Game.class.getClassLoader().getResource("events/GlobalEvents.xml"));
        if (version == Version.InternalTest) {
            // empty if block
        }
        try {
            AbstractState abstractState;
            InputHandler inputHandler = new InputHandler();
            if (doResetProfile) {
                Profile.getCurrentProfile(settings).reset();
            }
            MusicPlayer musicPlayer = null;
            if (!doFastStart) {
                musicPlayer = Game.initMusicPlayer(game, eventManager);
            }
            if (startupGameState != null) {
                startupGameState.setText("Generating awesome music...");
            }
            GameState gameState = null;
            if (!doFastStart) {
                gameState = Game.initGameState(game, eventManager);
            }
            if (startupGameState != null) {
                startupGameState.setText("Initiating flabbergasting features...");
            }
            ResourceManager.setEventManager(eventManager);
            BaseMenuState baseMenuState = null;
            if (!doFastStart) {
                baseMenuState = Game.initMenuState(game, eventManager, inputHandler, gameState);
            }
            if (startupGameState != null) {
                startupGameState.setText("Charging the turbo...");
            }
            BetweenRacesGUIState betweenRacesGUIState = Game.initBetweenRacesGUIState(game, eventManager, inputHandler, gameState);
            if (startupGameState != null) {
                startupGameState.setText("Histomogrifying images...");
            }
            EditorState editorState = null;
            if (!doFastStart) {
                editorState = Game.initEditorState(game, gameState, eventManager);
            }
            if (startupGameState != null) {
                startupGameState.setText("Tip: Press F11 any time to take a screenshot");
            }
            FadingTransitionGameState fadingTransitionGameState = new FadingTransitionGameState(inputHandler);
            CreditsGameState creditsGameState = new CreditsGameState("CreditsGameState", eventManager, settings);
            GameOverGameState gameOverGameState = new GameOverGameState("GameOverGameState", eventManager, settings);
            if (musicPlayer != null) {
                gameStateManager.attachChild(musicPlayer);
            }
            if (gameState != null) {
                gameStateManager.attachChild(gameState);
            }
            if (baseMenuState != null) {
                gameStateManager.attachChild(baseMenuState);
            }
            if (betweenRacesGUIState != null) {
                gameStateManager.attachChild(betweenRacesGUIState);
            }
            if (editorState != null) {
                gameStateManager.attachChild(editorState);
            }
            if (creditsGameState != null) {
                gameStateManager.attachChild(creditsGameState);
            }
            if (gameOverGameState != null) {
                gameStateManager.attachChild(gameOverGameState);
            }
            if (fadingTransitionGameState != null) {
                gameStateManager.attachChild(fadingTransitionGameState);
            }
            gameStateManager.deactivateAllChildren();
            if (startupGameState != null) {
                gameStateManager.activateChildNamed(startupGameState.getName());
            }
            if (musicPlayer != null) {
                gameStateManager.activateChildNamed(musicPlayer.getName());
            }
            GlobalGameState globalGameState = Game.initGlobalGameState(gameStateManager, eventManager, gameState, settings);
            Game.initDisplayModeListener(game, eventManager, globalGameState);
            Game.initStateEventListener(game, eventManager);
            Menu menu = new Menu(gameState, settings);
            IngameMenu ingameMenu = new IngameMenu(gameState);
            CreditsState creditsState = new CreditsState();
            Countdown countdown = new Countdown(gameState, settings, betweenRacesGUIState);
            Race race = new Race(gameState);
            Finish finish = new Finish(gameState);
            Results results = new Results(gameState, betweenRacesGUIState);
            ChooseTrack chooseTrack = new ChooseTrack(gameState, betweenRacesGUIState, settings);
            Editor editor = new Editor(editorState);
            ManageReplay manageReplay = new ManageReplay(gameState, betweenRacesGUIState);
            ReplayCountdown replayCountdown = new ReplayCountdown(gameState, settings, betweenRacesGUIState);
            ReplayRace replayRace = new ReplayRace(gameState);
            TimeAttackMenu timeAttackMenu = new TimeAttackMenu(gameState);
            TimeAttackCountdown timeAttackCountdown = new TimeAttackCountdown(gameState, settings, betweenRacesGUIState);
            TimeAttackRace timeAttackRace = new TimeAttackRace(gameState);
            TimeAttackFinish timeAttackFinish = new TimeAttackFinish(gameState);
            TimeAttackResults timeAttackResults = new TimeAttackResults(gameState, betweenRacesGUIState);
            ViewProfileStats viewProfileStats = new ViewProfileStats();
            QuitUpsell quitUpsell = null;
            if ("Demo".equals(settings.get("version", "Demo"))) {
                int n2 = Integer.parseInt(settings.get("demoVariant", "0"));
                if (n2 == 0 || n2 == 1) {
                    abstractState = new Upsell1(gameState);
                    quitUpsell = new QuitUpsell(gameState);
                } else {
                    abstractState = new Upsell1(gameState);
                    quitUpsell = new QuitUpsell(gameState);
                }
            } else {
                abstractState = new GameOverState();
            }
            StateMachine stateMachine = new StateMachine("StateMachine", eventManager, menu, settings, fadingTransitionGameState);
            stateMachine.add(menu);
            stateMachine.add(creditsState);
            stateMachine.add(abstractState);
            stateMachine.add(countdown);
            stateMachine.add(race);
            stateMachine.add(finish);
            stateMachine.add(results);
            stateMachine.add(chooseTrack);
            stateMachine.add(editor);
            stateMachine.add(ingameMenu);
            stateMachine.add(manageReplay);
            stateMachine.add(replayCountdown);
            stateMachine.add(replayRace);
            stateMachine.add(timeAttackMenu);
            stateMachine.add(timeAttackCountdown);
            stateMachine.add(timeAttackRace);
            stateMachine.add(timeAttackFinish);
            stateMachine.add(timeAttackResults);
            stateMachine.add(viewProfileStats);
            if (quitUpsell != null) {
                stateMachine.add(quitUpsell);
            }
            globalGameState.addUpdatable(stateMachine);
            globalGameState.setStateMachine(stateMachine);
            if (doSceneMonitor) {
                final GameState gameState2 = gameState;
                final BaseMenuState baseMenuState2 = baseMenuState;
                final EditorState editorState2 = editorState;
                final BetweenRacesGUIState betweenRacesGUIState2 = betweenRacesGUIState;
                final FadingTransitionGameState fadingTransitionGameState2 = fadingTransitionGameState;
                final GlobalGameState globalGameState2 = globalGameState;
                GameTaskQueueManager.getManager().update(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (gameState2 != null) {
                            SceneMonitor.getMonitor().registerNode(gameState2.getRootNode(), "GameState root node");
                        }
                        if (gameState2 != null) {
                            SceneMonitor.getMonitor().registerNode(gameState2.getHudNode(), "GameState hud node");
                        }
                        if (baseMenuState2 != null) {
                            SceneMonitor.getMonitor().registerNode(baseMenuState2.getRootNode(), "MenuState root node");
                        }
                        if (editorState2 != null) {
                            SceneMonitor.getMonitor().registerNode(editorState2.getRootNode(), "EditorState root node");
                        }
                        if (betweenRacesGUIState2 != null) {
                            SceneMonitor.getMonitor().registerNode(betweenRacesGUIState2.getRootNode(), "BetweenRacesGuiState root node");
                        }
                        if (fadingTransitionGameState2 != null) {
                            SceneMonitor.getMonitor().registerNode(fadingTransitionGameState2.getRootNode(), "LoadingGameState root node");
                        }
                        globalGameState2.setDoSceneMonitor(doSceneMonitor);
                        return null;
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(game, gameName, string, string2, settings);
            exceptionHandler.uncaughtException(Thread.currentThread(), runtimeException);
        }
        if (!doFastStart) {
            eventManager.fireEvent(new Event("ActivateState", new String[][]{{"stateName"}, {"Game"}}));
        }
    }

    private static String getCurrentTimeString() {
        String string;
        String string2;
        String string3;
        Calendar calendar = Calendar.getInstance();
        String string4 = "" + calendar.get(1);
        String string5 = "" + calendar.get(2);
        if (string5.length() < 2) {
            string5 = "0" + string5;
        }
        if ((string3 = "" + calendar.get(5)).length() < 2) {
            string3 = "0" + string3;
        }
        if ((string2 = "" + calendar.get(11)).length() < 2) {
            string2 = "0" + string2;
        }
        if ((string = "" + calendar.get(12)).length() < 2) {
            string = "0" + string;
        }
        return string4 + "-" + string5 + "-" + string3 + " " + string2 + ":" + string;
    }

    private static void redirectOutErr() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + System.getProperty("file.separator");
        }
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string + "msm_outerr.txt")));
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void unzipLauncher() {
        Serializable serializable;
        try {
            serializable = new File(System.getProperty("user.dir"));
            File file = new File((File)serializable, "unpack_msm.jar");
            if (file.exists()) {
                Game.unzip((File)serializable, "unpack_msm.jar", ((File)serializable).getParentFile());
                file.delete();
            }
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(Game.class.getCanonicalName()).severe("Could not unzip \"unpack_msm.jar\" due to " + runtimeException);
            throw runtimeException;
        }
        serializable = Game.class.getClassLoader().getResource("build.txt");
        if (serializable != null) {
            Properties properties = new Properties();
            try {
                properties.load(((URL)serializable).openStream());
                Logger.getLogger(Game.class.getCanonicalName()).info("Build number: " + properties.getProperty("build.number", "N/A"));
            }
            catch (IOException iOException) {
                Logger.getLogger(Game.class.getCanonicalName()).severe("Could not find build number due to " + iOException);
            }
        }
    }

    private static void saveBuildNumberToSettings() {
        URL uRL = Game.class.getClassLoader().getResource("build.txt");
        if (uRL != null) {
            Properties properties = new Properties();
            try {
                properties.load(uRL.openStream());
                settings.set("buildNumber", properties.getProperty("build.number", "0"));
            }
            catch (IOException iOException) {
                Logger.getLogger(Game.class.getCanonicalName()).severe("Could not find build number due to " + iOException);
            }
        }
    }

    private static EditorState initEditorState(TurboJMEGame turboJMEGame, GameState gameState, EventManager eventManager) {
        EditorState editorState = new EditorState(gameState, turboJMEGame.getSettings(), null);
        editorState.setGlobalEventManager(eventManager);
        eventManager.registerListener("DisplayModeChanged", editorState);
        eventManager.registerListener("DisplayChangeReverted", editorState);
        eventManager.registerListener("DisplayChangeFailed", editorState);
        eventManager.registerListener("PassedFinishline", editorState);
        return editorState;
    }

    private static GameState initGameState(TurboJMEGame turboJMEGame, EventManager eventManager) {
        GameState gameState = new GameState(turboJMEGame.getSettings(), turboJMEGame.getFrameRateManager(), ResourceManager.findUrl("events/GameStateEvents.xml"), turboJMEGame.getSoundSystem());
        gameState.setGlobalEventManager(eventManager);
        return gameState;
    }

    private static MusicPlayer initMusicPlayer(TurboJMEGame turboJMEGame, EventManager eventManager) {
        MusicPlayer musicPlayer = new MusicPlayer(eventManager, turboJMEGame.getSettings(), turboJMEGame.getSoundSystem());
        return musicPlayer;
    }

    public static void initLoaders(ResourceManager resourceManager, GameSettings gameSettings) {
        SoundSystemConfig.setSoundFilesPackage("sounds/data/");
        PropertiesLoader propertiesLoader = new PropertiesLoader();
        propertiesLoader.addPath("game/");
        resourceManager.registerLoader(propertiesLoader);
        TrackLoader trackLoader = new TrackLoader();
        trackLoader.addPath("tracks/");
        trackLoader.addSuffix(".txt");
        resourceManager.registerLoader(trackLoader);
        Track1DLoader track1DLoader = new Track1DLoader();
        track1DLoader.addPath("tracks/");
        track1DLoader.addSuffix(".msmtrack");
        resourceManager.registerLoader(track1DLoader);
        TextureLoader textureLoader = new TextureLoader();
        textureLoader.addPath("textures");
        textureLoader.addPath("images");
        textureLoader.addPath("images/gui");
        resourceManager.registerLoader(textureLoader);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.addPath("textures");
        imageLoader.addPath("images");
        imageLoader.addPath("images/gui");
        resourceManager.registerLoader(imageLoader);
        FontLoader fontLoader = new FontLoader();
        fontLoader.addPath("fonts");
        resourceManager.registerLoader(fontLoader);
        MusicLoader musicLoader = new MusicLoader();
        musicLoader.addPath("sounds/music");
        musicLoader.addPath("sounds/data");
        resourceManager.registerLoader(musicLoader);
        SkinLoader skinLoader = new SkinLoader();
        skinLoader.addPath("skins");
        resourceManager.registerLoader(skinLoader);
        ParallaxLoader parallaxLoader = new ParallaxLoader();
        parallaxLoader.addPath("environments/backgrounds");
        resourceManager.registerLoader(parallaxLoader);
        MaterialLoader materialLoader = new MaterialLoader();
        materialLoader.addPath("environments/materials");
        resourceManager.registerLoader(materialLoader);
        ReplayAILoader replayAILoader = new ReplayAILoader();
        replayAILoader.addPath("tracks/replays");
        resourceManager.registerLoader(replayAILoader);
        DivisionDescriptorLoader divisionDescriptorLoader = new DivisionDescriptorLoader();
        divisionDescriptorLoader.addPath("game");
        resourceManager.registerLoader(divisionDescriptorLoader);
    }

    private static void initLogging() {
        try {
            Handler handler2;
            for (Handler handler2 : Logger.getLogger("").getHandlers()) {
                Logger.getLogger("").removeHandler(handler2);
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(SystemFolder.getUserCreatedContentFolder(null) + File.separator + "log.zip"));
            zipOutputStream.putNextEntry(new ZipEntry("log.txt"));
            StreamHandler streamHandler = new StreamHandler(zipOutputStream, new SimpleFormatter());
            Logger.getLogger("").addHandler(streamHandler);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            Logger.getLogger("com.jme").addHandler(consoleHandler);
            Logger.getLogger("com.jmex").addHandler(consoleHandler);
            handler2 = new ConsoleHandler();
            Logger.getLogger("com.turborilla").addHandler(handler2);
            streamHandler.setLevel(Level.INFO);
            consoleHandler.setLevel(Level.SEVERE);
            handler2.setLevel(Level.SEVERE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void initStateEventListener(TurboJMEGame turboJMEGame, EventManager eventManager) {
        StateEventListener stateEventListener = new StateEventListener(GameStateManager.getInstance());
        eventManager.registerListener("SwitchState", stateEventListener);
        eventManager.registerListener("ActivateState", stateEventListener);
        eventManager.registerListener("DeactivateState", stateEventListener);
        eventManager.registerListener("PauseState", stateEventListener);
        eventManager.registerListener("UnpauseState", stateEventListener);
        eventManager.registerListener("PauseActivateState", stateEventListener);
        eventManager.registerListener("DeactivateUnpauseState", stateEventListener);
        eventManager.registerListener("UndoStateChange", stateEventListener);
        eventManager.registerListener("Quit", new QuitEventListener(turboJMEGame));
    }

    private static void initDisplayModeListener(TurboJMEGame turboJMEGame, EventManager eventManager, GlobalGameState globalGameState) {
        ChangeDisplayModeEventListener changeDisplayModeEventListener = new ChangeDisplayModeEventListener(eventManager, turboJMEGame);
        eventManager.registerListener("ChangeDisplayMode", changeDisplayModeEventListener);
        eventManager.registerListener("RevertDisplayChange", changeDisplayModeEventListener);
        globalGameState.addUpdatable(changeDisplayModeEventListener);
    }

    private static GlobalGameState initGlobalGameState(GameStateManager gameStateManager, EventManager eventManager, GameState gameState, GameSettings gameSettings) {
        GlobalGameState globalGameState = new GlobalGameState(eventManager, 88, gameSettings);
        globalGameState.getInput().addAction(new BreakPointAction(gameStateManager, gameState), "keyboard", 68, -1, false);
        globalGameState.getInput().addAction(new ReloadResourcesAction(eventManager), "keyboard", 63, -1, false);
        if (gameState != null) {
            globalGameState.getInput().addAction(new MenuAction(gameStateManager, gameState.getEventManager(), eventManager), "keyboard", 1, -1, false);
        }
        gameStateManager.attachChild(globalGameState);
        gameStateManager.activateChildNamed(globalGameState.getName());
        return globalGameState;
    }

    private static BaseMenuState initMenuState(TurboJMEGame turboJMEGame, EventManager eventManager, InputHandler inputHandler, GameState gameState) {
        URL uRL = null;
        MenuState menuState = new MenuState("MenuState", turboJMEGame.getSettings(), uRL, inputHandler, gameState);
        ((BaseMenuState)menuState).setGlobalEventManager(eventManager);
        return menuState;
    }

    private static BetweenRacesGUIState initBetweenRacesGUIState(TurboJMEGame turboJMEGame, EventManager eventManager, InputHandler inputHandler, GameState gameState) {
        BetweenRacesGUIState betweenRacesGUIState = new BetweenRacesGUIState("BetweenRacesGUIState", turboJMEGame.getSettings(), inputHandler, gameState);
        betweenRacesGUIState.setGlobalEventManager(eventManager);
        return betweenRacesGUIState;
    }

    private static void setDefaultDisplayAsDesktop(PreferencesGameSettingsWithDefaults preferencesGameSettingsWithDefaults) {
        java.awt.DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        Logger.getLogger(Game.class.getName()).info("Desktop display mode (AWT): " + displayMode.getWidth() + "x" + displayMode.getHeight() + "x" + displayMode.getBitDepth() + " @" + displayMode.getRefreshRate() + "Hz");
        DisplayMode displayMode2 = Display.getDisplayMode();
        Logger.getLogger(Game.class.getName()).info("Desktop display mode (LWJGL): " + displayMode2.getWidth() + "x" + displayMode2.getHeight() + "x" + displayMode2.getBitsPerPixel() + " @" + displayMode2.getFrequency() + "Hz");
        if (preferencesGameSettingsWithDefaults.getInt("GameWidth", -1) < 0 || preferencesGameSettingsWithDefaults.getInt("GameHeight", -1) < 0 || preferencesGameSettingsWithDefaults.getInt("GameDepth", -1) < 0 || preferencesGameSettingsWithDefaults.getInt("GameFrequency", -1) < 0) {
            int n = displayMode2.getBitsPerPixel();
            int n2 = displayMode2.getFrequency();
            if (n <= 0) {
                n = displayMode.getBitDepth();
            }
            if (n <= 0) {
                n = 32;
            }
            if (n2 <= 0) {
                n2 = displayMode.getRefreshRate();
            }
            if (n2 <= 0) {
                n2 = 60;
            }
            int n3 = 800;
            int n4 = 600;
            if (preferencesGameSettingsWithDefaults.isFullscreen()) {
                n3 = displayMode2.getWidth();
                n4 = displayMode2.getHeight();
                if (n3 <= 0) {
                    n3 = displayMode.getWidth();
                }
                if (n3 <= 0) {
                    n3 = 800;
                }
                if (n4 <= 0) {
                    n4 = displayMode.getHeight();
                }
                if (n4 <= 0) {
                    n4 = 600;
                }
            }
            preferencesGameSettingsWithDefaults.setWidth(n3);
            preferencesGameSettingsWithDefaults.setHeight(n4);
            preferencesGameSettingsWithDefaults.setDepth(n);
            preferencesGameSettingsWithDefaults.setFrequency(n2);
        }
    }

    public static void unzip(File file, String string, File file2) {
        ZipFile zipFile = null;
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            zipFile = new ZipFile(new File(file, string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file3;
                zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0 || (file3 = new File(file2, zipEntry.getName())).exists()) continue;
                file3.mkdirs();
            }
            enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0) continue;
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[2048];
                File file4 = new File(file2, zipEntry.getName());
                if (file4.exists()) {
                    file4.delete();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void buy(String string) {
        String string2 = null;
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                string2 = "";
                break;
            }
            case 2: {
                string2 = "";
                break;
            }
            case 1: {
                string2 = "";
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = "";
        }
        if (string2 == null || string2.length() <= 0) {
            String string3;
            String string4 = System.getProperty("os.name", "unknown").toLowerCase();
            int n = Math.round(Float.parseFloat(settings.get("time", "-1")) / 60.0f);
            long l = -1L;
            if (settings.get("timeOfFirstRun", null) != null) {
                string3 = Game.getCurrentTimeString();
                try {
                    l = Game.getDifferenceInMinutes(settings.get("timeOfFirstRun", string3), string3);
                }
                catch (ParseException parseException) {
                    l = -1L;
                }
            }
            try {
                string3 = "http://www.madskillsmotocross.com/buy.php?dv=" + URLEncoder.encode("" + demoVariant, "US-ASCII") + "&convtime=" + URLEncoder.encode("" + l, "US-ASCII") + "&playtime=" + URLEncoder.encode("" + n, "US-ASCII") + "&b=" + URLEncoder.encode(string, "US-ASCII") + "&os=" + URLEncoder.encode(string4, "US-ASCII") + "&ref=" + URLEncoder.encode(settings.get("referrer", ""), "US-ASCII");
                game.shutdownAndOpenURL(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                game.shutdownAndOpenURL("http://www.madskillsmotocross.com/buy.php");
            }
        } else {
            game.shutdownAndOpenURL(string2);
        }
    }

    public static long getDifferenceInMinutes(String string, String string2) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-mm-dd hh:mm");
        Date date = simpleDateFormat.parse(string);
        Date date2 = simpleDateFormat.parse(string2);
        long l = date.getTime();
        long l2 = date2.getTime();
        return (l2 - l) / 60000L;
    }

    static {
        doFastStart = false;
        doSceneMonitor = false;
        doResetProfile = false;
        doClearSettings = false;
        simulationModeAvailable = false;
        testVersion = -1;
        availableDemoVariants = new int[]{6, 7};
        demoVariant = 0;
        bestBefore = Calendar.getInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Version {
        Full,
        InternalTest,
        ExternalTest,
        Demo,
        Review;

    }
}

