/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.jops.jme;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Node;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.turborilla.jops.jme.ParticleGeneratorMesh;
import java.util.ArrayList;
import java.util.List;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.softmed.jops.Generator;
import org.softmed.jops.ParticleSystem;

public class JopsNode
extends Node {
    private Node particleNode;
    private ArrayList<ParticleGeneratorMesh> generators;
    private ParticleSystem particleSystem;
    private Camera camera;
    private Quaternion4f maliQuat = new Quaternion4f();
    private float[] position = new float[3];
    private Vector3f worldTranslation = new Vector3f();
    private Quaternion worldRotation = this.getWorldRotation();

    public JopsNode() {
        this.init();
    }

    public JopsNode(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.particleNode = new Node(this.getName() + ":ParticleNode");
        this.generators = new ArrayList();
        this.setRenderQueueMode(3);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setWritable(false);
        this.setRenderState(zBufferState);
        this.updateRenderState();
    }

    public void update(float f) {
        if (this.particleSystem != null && this.particleNode.getParent() != this) {
            this.worldTranslation.set(this.getWorldTranslation());
            this.worldRotation.set(this.getWorldRotation());
            this.particleNode.getLocalScale().set(this.getLocalScale());
            this.worldTranslation.divideLocal(this.getWorldScale());
            this.maliQuat.set(this.worldRotation.x, this.worldRotation.y, this.worldRotation.z, this.worldRotation.w);
            this.particleSystem.getRotation().set(this.maliQuat);
            this.worldRotation.inverseLocal();
            this.worldRotation.mult(this.worldTranslation, this.worldTranslation);
            this.particleSystem.getPosition().set(this.worldTranslation.toArray(this.position));
        }
    }

    private ParticleGeneratorMesh createGenerator(Generator generator) {
        ParticleGeneratorMesh particleGeneratorMesh = new ParticleGeneratorMesh(generator.getName(), generator);
        this.particleNode.attachChild(particleGeneratorMesh);
        particleGeneratorMesh.setCamera(this.camera);
        return particleGeneratorMesh;
    }

    private void installGenerators() {
        List<Generator> list = this.particleSystem.getGenerators();
        for (int i = 0; i < list.size(); ++i) {
            this.createGenerator(list.get(i));
        }
    }

    private void clearGenerators() {
        for (int i = 0; i < this.generators.size(); ++i) {
            this.particleNode.detachChild(this.generators.get(i));
        }
        this.generators.clear();
    }

    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public void setParticleSystem(ParticleSystem particleSystem) {
        this.particleSystem = particleSystem;
        if (particleSystem.getRotation() == null) {
            particleSystem.setRotation(new Matrix4f(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        }
        if (particleSystem.getPosition() == null) {
            particleSystem.setPosition(new Point3f());
        }
        this.installGenerators();
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        this.update(f);
    }

    public Node getParticleNode() {
        return this.particleNode;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }
}

