/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui.widget.utils;

import com.jme.bounding.BoundingBox;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.gui.widget.utils.ILayout;
import com.turborilla.gui.widget.utils.IResizableWidget;
import java.util.ArrayList;

public class Panel
extends BaseWidget
implements IResizableWidget {
    private GuiHandler guiHandler;
    private ILayout layout;
    private float width = 0.0f;
    private float height = 0.0f;
    private BoundingBox boundingBox = new BoundingBox();
    private ArrayList<IWidget> wasEnabled;

    public Panel(String string, float f, float f2, GuiHandler guiHandler) {
        super(string);
        this.width = f;
        this.height = f2;
        this.guiHandler = guiHandler;
        this.setActivatable(true);
        this.setFocusable(false);
    }

    public void addWidget(BaseWidget baseWidget) {
        this.addWidget(baseWidget, new Vector2f(), true, true);
    }

    public void addWidget(BaseWidget baseWidget, Vector2f vector2f, boolean bl, boolean bl2) {
        float f = bl ? vector2f.x * this.width - this.width * 0.5f : vector2f.x;
        float f2 = bl2 ? vector2f.y * this.height - this.height * 0.5f : vector2f.y;
        baseWidget.getMover().setPosition(new Vector3f(f, f2, baseWidget.getSpatial().getLocalTranslation().z));
        this.addLayer(baseWidget);
        baseWidget.setGuiHandler(this.guiHandler);
        baseWidget.updateRenderState();
    }

    public void removeWidget(BaseWidget baseWidget) {
        this.detachChild(baseWidget.getSpatial());
        this.getLayers().remove(baseWidget);
        baseWidget.setGuiHandler(null);
        baseWidget.updateRenderState();
    }

    public void removeWidget(IWidget iWidget) {
        this.detachChild(iWidget.getSpatial());
        this.getLayers().remove(iWidget);
        this.updateRenderState();
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox boundingBox = super.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = this.boundingBox;
            boundingBox.getCenter().set(this.getLocalTranslation());
            boundingBox.xExtent = this.width * 0.5f;
            boundingBox.yExtent = this.height * 0.5f;
            boundingBox.zExtent = 0.0f;
        }
        return boundingBox;
    }

    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        if (this.layout != null) {
            this.layout.setSize(f, f2);
            this.layout.doLayout();
        }
    }

    public void disableTemporarily() {
        if (!this.isEnabled() && this.wasEnabled != null) {
            return;
        }
        if (this.wasEnabled == null) {
            this.wasEnabled = new ArrayList();
        }
        this.wasEnabled.clear();
        for (int i = 0; i < this.getLayers().size(); ++i) {
            IWidget iWidget = this.getLayers().get(i);
            if (iWidget.isEnabled()) {
                this.wasEnabled.add(iWidget);
            }
            if (iWidget instanceof Panel) {
                ((Panel)iWidget).disableTemporarily();
                continue;
            }
            iWidget.setEnabled(false);
        }
        this.setEnabled(false, false);
    }

    public void enableFromTemporaryDisable() {
        if (this.wasEnabled == null || this.wasEnabled.isEmpty()) {
            for (int i = 0; i < this.getLayers().size(); ++i) {
                IWidget iWidget = this.getLayers().get(i);
                if (iWidget == null) continue;
                if (iWidget instanceof Panel) {
                    ((Panel)iWidget).enableFromTemporaryDisable();
                    continue;
                }
                iWidget.setEnabled(true);
            }
            return;
        }
        this.setEnabled(true, false);
        for (int i = 0; i < this.wasEnabled.size(); ++i) {
            IWidget iWidget = this.wasEnabled.get(i);
            if (iWidget == null) continue;
            if (iWidget instanceof Panel) {
                ((Panel)iWidget).enableFromTemporaryDisable();
                continue;
            }
            iWidget.setEnabled(true);
        }
    }

    public ILayout getLayout() {
        return this.layout;
    }

    public void setLayout(ILayout iLayout) {
        this.layout = iLayout;
        iLayout.setSize(this.width, this.height);
        this.doLayout();
    }

    public void doLayout() {
        this.getLayout().setSize(this.getWidth(), this.getHeight());
        this.layout.doLayout();
    }
}

