/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui.widget;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.msm.gui.turbogui.listeners.IMouseOverListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import com.turborilla.utils.controllers.SpatialScaleController;
import com.turborilla.utils.controllers.SpatialTranslationController;
import java.util.ArrayList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWidget
extends Node
implements IWidget {
    protected ArrayList<IWidget> layers;
    protected SpatialFadeController fader;
    protected SpatialTranslationController mover;
    protected SpatialScaleController scaler;
    private GuiHandler guiHandler;
    private boolean focusable = false;
    private boolean activatable = false;
    private boolean mouseOver = false;
    private boolean focused = false;
    private boolean active = false;
    private boolean visible = true;
    private int order = 0;
    protected IMouseOverListener<BaseWidget> mouseOverListener;
    private boolean enabled = true;
    private Vector2f tempPos = new Vector2f();
    protected static final ColorRGBA defaultColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected static final ColorRGBA mouseOverColor = new ColorRGBA(0.8f, 0.0f, 0.0f, 0.7f);
    protected static final ColorRGBA mouseDownColor = new ColorRGBA(0.5f, 0.0f, 0.0f, 0.8f);
    protected static final ColorRGBA focusedColor = new ColorRGBA(0.2f, 0.0f, 0.0f, 0.5f);
    protected static ColorRGBA noAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    protected static final Vector3f defaultScale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected static final Vector3f mouseOverScale = new Vector3f(1.2f, 1.2f, 1.0f);
    protected static final Vector3f mouseDownScale = new Vector3f(1.15f, 1.15f, 1.0f);
    protected static final float scaleTime = 4.8f;
    protected static final float scaleDamp = 0.1f;
    protected static final float fadeTime = 0.2f;
    protected static final float moveTime = 4.8f;
    protected static final float moveDamp = 0.1f;
    private final Properties loaderProperties = new Properties();
    private static Ray ray = new Ray();
    private static Vector3f rayOrigin = new Vector3f();
    private static Vector3f rayDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    private static ArrayList<IWidget> tempList = new ArrayList();
    boolean wasFocusable = false;
    boolean wasActivatable = false;
    boolean wasEnabled = true;
    private IWidget nextWidget = null;
    private IWidget previousWidget = null;
    private Node parent;

    public BaseWidget(String string) {
        super(string);
        this.layers = new ArrayList();
        this.setModelBound(new BoundingBox());
        this.setCullMode(3);
        this.fader = new SpatialFadeController(this);
        this.fader.initRenderStates();
        this.addController(this.fader);
        this.mover = new SpatialTranslationController(this);
        this.addController(this.mover);
        this.scaler = new SpatialScaleController(this);
        this.addController(this.scaler);
        this.fader.setColor(defaultColor);
        this.scaler.setScale(defaultScale);
        this.scaler.setDamping(0.1f);
        this.setOrder(this.order);
        this.updateWorldData(0.0f);
        this.loaderProperties.setProperty("textureMinFilter", "5");
        this.loaderProperties.setProperty("textureMagFilter", "1");
    }

    public void addLayer(IWidget iWidget) {
        this.layers.add(iWidget);
        this.attachChild(iWidget.getSpatial());
        iWidget.setOrder(this.order, true);
    }

    public void setGuiHandler(GuiHandler guiHandler) {
        this.guiHandler = guiHandler;
    }

    @Override
    public int attachChild(Spatial spatial) {
        if (spatial.getWorldBound() == null) {
            spatial.setModelBound(new BoundingBox());
            spatial.updateWorldBound();
        }
        return super.attachChild(spatial);
    }

    protected void takeFocus() {
        if (this.guiHandler != null) {
            this.guiHandler.focusWidget(this);
        }
    }

    protected void releaseFocus() {
        if (this.guiHandler != null && this.isFocused() && this.guiHandler.getFocusedWidget() == this) {
            this.guiHandler.focusWidget(null);
        }
    }

    protected void forceDeactivate() {
        if (this.guiHandler != null) {
            this.guiHandler.activateWidget(null);
        }
    }

    @Override
    public Spatial getSpatial() {
        return this.getNode();
    }

    @Override
    public boolean isInside(Vector3f vector3f) {
        this.updateModelBound();
        this.updateWorldBound();
        BoundingVolume boundingVolume = this.getWorldBound();
        if (boundingVolume == null && (boundingVolume = this.getBoundingBox()) == null) {
            return false;
        }
        rayOrigin.set(vector3f.x, vector3f.y, Float.MAX_VALUE);
        ray.setOrigin(rayOrigin);
        ray.setDirection(rayDirection);
        boolean bl = boundingVolume.intersects(ray);
        return bl;
    }

    public BoundingBox getBoundingBox() {
        this.updateModelBound();
        this.updateWorldBound();
        BoundingVolume boundingVolume = this.getWorldBound();
        if (boundingVolume == null || !(boundingVolume instanceof BoundingBox)) {
            boundingVolume = new BoundingBox();
            this.setModelBound(boundingVolume);
            this.updateModelBound();
            this.updateWorldBound();
        }
        BoundingBox boundingBox = (BoundingBox)this.getWorldBound();
        return boundingBox;
    }

    public float getWidth() {
        float f = 0.0f;
        f = this.getBoundingBox().xExtent * 2.0f;
        return f;
    }

    public float getHeight() {
        float f = 0.0f;
        f = this.getBoundingBox().yExtent * 2.0f;
        return f;
    }

    public IWidget getLayer(String string) {
        for (int i = 0; i < this.layers.size(); ++i) {
            IWidget iWidget = this.layers.get(i);
            if (!string.equals(iWidget.getName())) continue;
            return iWidget;
        }
        return null;
    }

    public SpatialFadeController getFader() {
        return this.fader;
    }

    public SpatialTranslationController getMover() {
        return this.mover;
    }

    public SpatialScaleController getScaler() {
        return this.scaler;
    }

    protected Node getNode() {
        return this;
    }

    private ArrayList<IWidget> getLayersInside(Vector3f vector3f) {
        tempList.clear();
        for (int i = 0; i < this.layers.size(); ++i) {
            IWidget iWidget = this.layers.get(i);
            if (!iWidget.isInside(vector3f)) continue;
            tempList.add(iWidget);
        }
        return tempList;
    }

    @Override
    public boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public void setFocusable(boolean bl) {
        this.focusable = bl;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void setMouseOver(boolean bl) {
        this.mouseOver = bl;
        if (this.mouseOverListener != null) {
            if (bl) {
                this.mouseOverListener.onMouseOver(this);
            } else {
                this.mouseOverListener.onMouseOut(this);
            }
        }
    }

    @Override
    public ArrayList<IWidget> getLayers() {
        return this.layers;
    }

    @Override
    public boolean isActivatable() {
        return this.activatable;
    }

    @Override
    public void setActivatable(boolean bl) {
        this.activatable = bl;
    }

    @Override
    public boolean isMoving() {
        return this.getMover().isTranslating();
    }

    @Override
    public void onActivate() {
    }

    @Override
    public void onBlur() {
    }

    @Override
    public void onDeactivate() {
    }

    @Override
    public void onFocus() {
    }

    @Override
    public boolean onKeyDown(int n, char c) {
        return false;
    }

    @Override
    public boolean onKeyTyped(int n, char c) {
        return false;
    }

    @Override
    public boolean onKeyUp(int n, char c) {
        return false;
    }

    @Override
    public void onLeftMouseClicked(Vector3f vector3f) {
    }

    @Override
    public void onLeftMouseDown(Vector3f vector3f) {
    }

    @Override
    public void onLeftMouseUp(Vector3f vector3f) {
    }

    @Override
    public void onMiddleMouseClicked(Vector3f vector3f) {
    }

    @Override
    public void onMiddleMouseDown(Vector3f vector3f) {
    }

    @Override
    public void onMiddleMouseUp(Vector3f vector3f) {
    }

    @Override
    public void onMouseMove(Vector3f vector3f, boolean bl) {
    }

    @Override
    public void onMouseOut() {
    }

    @Override
    public void onMouseOver(boolean bl) {
    }

    @Override
    public void onRightMouseClicked(Vector3f vector3f) {
    }

    @Override
    public void onRightMouseDown(Vector3f vector3f) {
    }

    @Override
    public void onRightMouseUp(Vector3f vector3f) {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public boolean setActive(boolean bl) {
        this.active = bl;
        return true;
    }

    @Override
    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.setOrder(n, false);
    }

    @Override
    public void setOrder(int n, boolean bl) {
        this.order = n;
        if (this.getChildren() != null) {
            this.setZOrder(n, true);
        } else {
            this.setZOrder(n);
        }
        if (bl && this.layers != null) {
            for (int i = 0; i < this.layers.size(); ++i) {
                this.layers.get(i).setOrder(n, bl);
            }
        }
    }

    public IMouseOverListener getMouseOverListener() {
        return this.mouseOverListener;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEnabled(bl, true);
    }

    public void setEnabled(boolean bl, boolean bl2) {
        if (this.enabled && !bl) {
            this.wasFocusable = this.focusable;
            this.wasActivatable = this.activatable;
        } else if (!this.enabled && bl) {
            this.setFocusable(this.wasFocusable);
            this.setActivatable(this.wasActivatable);
        }
        this.enabled = bl;
        if (!bl) {
            this.releaseFocus();
            if (this.isActive()) {
                this.forceDeactivate();
            }
            this.setFocusable(false);
            this.setActivatable(false);
            this.onDisable();
        } else {
            this.onEnable();
        }
        if (bl2) {
            ArrayList<IWidget> arrayList = this.getLayers();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setEnabled(bl);
            }
        }
    }

    public void setMouseOverListener(IMouseOverListener iMouseOverListener) {
        this.mouseOverListener = iMouseOverListener;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Vector2f getPosition() {
        return this.tempPos.set(this.getLocalTranslation().x, this.getLocalTranslation().y);
    }

    public void setPosition(Vector2f vector2f) {
        this.getMover().setPosition(vector2f.x, vector2f.y, this.getLocalTranslation().z);
    }

    @Override
    public IWidget getNextWidget() {
        return this.nextWidget;
    }

    @Override
    public void setNextWidget(IWidget iWidget) {
        this.nextWidget = iWidget;
    }

    @Override
    public IWidget getPreviousWidget() {
        return this.previousWidget;
    }

    @Override
    public void setPreviousWidget(IWidget iWidget) {
        this.previousWidget = iWidget;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void onLeftMouseDoubleClicked(Vector3f vector3f) {
    }

    @Override
    public void onMiddleMouseDoubleClicked(Vector3f vector3f) {
    }

    @Override
    public void onRightMouseDoubleClicked(Vector3f vector3f) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(bl, true);
    }

    public void setVisible(boolean bl, boolean bl2) {
        if (this.visible != bl) {
            if (!bl) {
                this.parent = this.getParent();
                if (this.parent != null) {
                    this.parent.detachChild(this);
                }
                this.wasEnabled = this.isEnabled();
                if (this.wasEnabled) {
                    this.setEnabled(false, false);
                }
            } else {
                if (this.parent != null) {
                    this.parent.attachChild(this);
                }
                if (this.wasEnabled != this.isEnabled()) {
                    this.setEnabled(this.wasEnabled, false);
                }
            }
        }
        this.visible = bl;
        if (bl2) {
            ArrayList<IWidget> arrayList = this.getLayers();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setVisible(bl);
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected Properties getLoaderProperties() {
        return new Properties(this.loaderProperties);
    }

    public Properties editLoaderProperties() {
        return this.loaderProperties;
    }
}

