/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.turborilla.gui.Label;
import com.turborilla.gui.VerticalAlignment;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import com.turborilla.utils.controllers.SpatialTranslationController;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalLabelList {
    private List<LabelEntry> labelQueue;
    private VerticalAlignment verticalAlignment;
    private Vector3f newLinesEnterPosition;
    private float lineHeight;
    private Vector3f min;
    private Vector3f max;
    private Node node;
    private float moveTime = 2.0f;
    private float moveDamping = 0.08f;
    private boolean updatePositionsNextFrame = false;
    private ColorRGBA noAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    private ColorRGBA fullAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private LabelDetacher labelDetacher;

    public VerticalLabelList(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.lineHeight = f;
        this.labelQueue = new LinkedList<LabelEntry>();
        this.verticalAlignment = VerticalAlignment.BOTTOM;
        this.newLinesEnterPosition = new Vector3f(vector3f).subtractLocal(0.0f, f, 0.0f);
        this.min = vector3f;
        this.max = vector3f2;
        this.node = new Node("VerticalLabelListNode");
    }

    public VerticalLabelList(Vector3f vector3f, Vector3f vector3f2) {
        this(vector3f, vector3f2, 35.0f);
    }

    public void updatePositions() {
        block11: {
            int n;
            int n2;
            block10: {
                n2 = this.labelQueue.size();
                n = 0;
                if (this.verticalAlignment != VerticalAlignment.BOTTOM) break block10;
                for (LabelEntry labelEntry : this.labelQueue) {
                    float f = this.min.y + this.lineHeight * (float)(n2 - n);
                    if (!labelEntry.removing) {
                        if (f > this.max.y && ((LabelEntry)labelEntry).targetPosition.y <= this.max.y) {
                            labelEntry.fader.fadeTo(this.noAlpha, 1.0f);
                            labelEntry.fader.clearListeners();
                            labelEntry.fader.add(new LabelDetacher(labelEntry, this));
                        } else if (f <= this.max.y && ((LabelEntry)labelEntry).targetPosition.y > this.max.y) {
                            labelEntry.fader.clearListeners();
                            labelEntry.fader.fadeTo(this.fullAlpha, 0.2f);
                        }
                    }
                    labelEntry.setTargetPositionY(f);
                    labelEntry.setTargetPositionX(this.min.x);
                    ++n;
                }
                break block11;
            }
            if (this.verticalAlignment != VerticalAlignment.TOP) break block11;
            for (LabelEntry labelEntry : this.labelQueue) {
                float f = this.max.y - this.lineHeight * (float)(n2 - n);
                if (!labelEntry.removing) {
                    if (f < this.min.y && ((LabelEntry)labelEntry).targetPosition.y >= this.min.y) {
                        labelEntry.fader.fadeTo(this.noAlpha, 1.0f);
                        labelEntry.fader.clearListeners();
                        labelEntry.fader.add(new LabelDetacher(labelEntry, this));
                    } else if (f >= this.min.y && ((LabelEntry)labelEntry).targetPosition.y < this.min.y) {
                        labelEntry.fader.clearListeners();
                        labelEntry.fader.fadeTo(this.fullAlpha, 0.2f);
                    }
                }
                labelEntry.setTargetPositionY(f);
                labelEntry.setTargetPositionX(this.min.x);
                ++n;
            }
        }
    }

    public void update(float f) {
    }

    public void addLabel(LabelEntry labelEntry) {
        this.labelQueue.add(labelEntry);
        labelEntry.mover.setPosition(this.newLinesEnterPosition);
        labelEntry.fader.setColor(this.noAlpha);
        labelEntry.fader.fadeTo(this.fullAlpha, 0.2f);
        this.node.attachChild(labelEntry.label);
        this.updatePositions();
    }

    public void removeLabel(LabelEntry labelEntry) {
        this.labelQueue.remove(labelEntry);
        this.node.detachChild(labelEntry.label);
        this.updatePositions();
    }

    public void fadeOutAndRemoveLabel(LabelEntry labelEntry) {
        this.fadeOutAndRemoveLabel(labelEntry, null, this.noAlpha);
    }

    public void fadeOutAndRemoveLabel(LabelEntry labelEntry, IControllerListener iControllerListener) {
        this.fadeOutAndRemoveLabel(labelEntry, iControllerListener, this.noAlpha);
    }

    public void fadeOutAndRemoveLabel(LabelEntry labelEntry, IControllerListener iControllerListener, ColorRGBA ... colorRGBAArray) {
        this.fadeOutAndRemoveLabel(labelEntry, 1.0f, iControllerListener, colorRGBAArray);
    }

    public void fadeOutAndRemoveLabel(LabelEntry labelEntry, float f, IControllerListener iControllerListener, ColorRGBA ... colorRGBAArray) {
        labelEntry.removing = true;
        labelEntry.fader.clearFadeQueue();
        labelEntry.fader.clearListeners();
        for (ColorRGBA colorRGBA : colorRGBAArray) {
            labelEntry.fader.fadeTo(colorRGBA, f / (float)colorRGBAArray.length);
        }
        labelEntry.fader.add(new LabelDetacher(labelEntry, this));
        if (iControllerListener != null) {
            labelEntry.fader.add(iControllerListener);
        }
    }

    private void removeLabelNoUpdate(LabelEntry labelEntry) {
        this.labelQueue.remove(labelEntry);
        this.node.detachChild(labelEntry.label);
        this.updatePositions();
    }

    public void clear() {
        for (LabelEntry labelEntry : this.labelQueue) {
            this.node.detachChild(labelEntry.label);
        }
        this.labelQueue.clear();
        this.updatePositions();
    }

    public LabelEntry findLabel(String string) {
        for (LabelEntry labelEntry : this.labelQueue) {
            if (!string.equals(labelEntry.label.getName())) continue;
            return labelEntry;
        }
        return null;
    }

    public List<LabelEntry> getLabelQueue() {
        return this.labelQueue;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNewLinesEnterPosition(Vector3f vector3f) {
        this.newLinesEnterPosition.set(vector3f);
    }

    public float getMoveDamping() {
        return this.moveDamping;
    }

    public void setMoveDamping(float f) {
        this.moveDamping = f;
    }

    public float getMoveTime() {
        return this.moveTime;
    }

    public void setMoveTime(float f) {
        this.moveTime = f;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float f) {
        this.lineHeight = f;
    }

    public Vector3f getMin() {
        return this.min;
    }

    public void setMin(Vector3f vector3f) {
        this.min = vector3f;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public void setMax(Vector3f vector3f) {
        this.max = vector3f;
    }

    private class LabelDetacher
    implements IControllerListener {
        VerticalLabelList list;
        LabelEntry labelEntry;

        public LabelDetacher(LabelEntry labelEntry, VerticalLabelList verticalLabelList2) {
            this.list = verticalLabelList2;
            this.labelEntry = labelEntry;
        }

        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            this.list.removeLabelNoUpdate(this.labelEntry);
        }
    }

    public class LabelEntry {
        private Label label;
        private SpatialFadeController fader;
        private SpatialTranslationController mover;
        private Vector3f targetPosition;
        private boolean removing;

        public LabelEntry(Label label) {
            this.label = label;
            label.setLightCombineMode(4);
            this.fader = new SpatialFadeController(label);
            this.mover = new SpatialTranslationController(label);
            this.mover.setDamping(VerticalLabelList.this.moveDamping);
            this.targetPosition = new Vector3f(label.getLocalTranslation());
            this.mover.setPosition(this.targetPosition);
            this.removing = false;
        }

        public void setTargetPosition(Vector3f vector3f) {
            vector3f.set(vector3f);
            this.apply();
        }

        public void setTargetPositionX(float f) {
            this.targetPosition.x = f;
            this.apply();
        }

        public void setTargetPositionY(float f) {
            this.targetPosition.y = f;
            this.apply();
        }

        public void setTargetPositionZ(float f) {
            this.targetPosition.z = f;
            this.apply();
        }

        private void apply() {
            this.mover.clearTranslationQueue();
            this.mover.addTranslationToQueue(this.targetPosition, VerticalLabelList.this.moveTime, VerticalLabelList.this.moveTime);
        }

        public Label getLabel() {
            return this.label;
        }

        public SpatialFadeController getFader() {
            return this.fader;
        }

        public SpatialTranslationController getMover() {
            return this.mover;
        }
    }
}

