/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui;

import com.jme.math.Vector2f;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.state.AlphaState;
import com.jme.system.DisplaySystem;
import com.turborilla.utils.Font;

public class Label
extends Node {
    protected int length;
    protected Font font;
    protected float updateInterval = 0.1f;
    protected boolean rightAligned = false;
    protected Vector2f fontStart = new Vector2f();
    private float timeAcc = 0.0f;
    private Vector2f fontVec = new Vector2f(0.0f, 0.0f);
    private String curString;
    protected String stringText = "";
    protected double doubleText;
    protected float floatText;
    protected long longText;
    protected int intText;
    protected short shortText;
    protected char charText;
    protected Type textType = Type.StringType;

    public Label(Font font, int n) {
        this.font = font;
        this.length = n;
        this.doInit();
    }

    public Label(String string, Font font, int n) {
        super(string);
        this.font = font;
        this.length = n;
        if (this.length <= 0) {
            this.length = 1;
        }
        this.doInit();
    }

    private void doInit() {
        this.detachAllChildren();
        this.initRenderStates();
        String string = "";
        for (int i = 0; i < this.length; ++i) {
            string = string + " ";
        }
        if (this.font != null) {
            this.font.drawString(string, this, new Vector2f(0.0f, 0.0f));
        }
        this.updateRenderState();
    }

    public void center() {
        float f = this.font.getLineHeight();
        float f2 = this.font.getBase();
        float f3 = f * 0.5f + f2 * 0.5f;
        float f4 = 0.0f;
        if (this.textType.getText(this).length() > 0) {
            f4 = (float)(-this.font.getWidth(this.textType.getText(this))) * 0.5f - (float)this.font.getWidth(this.textType.getText(this).substring(this.textType.getText(this).length() - 1, this.textType.getText(this).length())) * 0.25f;
        }
        this.fontStart.set(f4, f3);
        this.updateText(this.textType.getText(this));
    }

    public void leftAlign(float f) {
        float f2 = this.font.getLineHeight();
        float f3 = this.font.getBase();
        float f4 = f2 * 0.5f + f3 * 0.5f;
        float f5 = 0.0f - f / this.getLocalScale().x * 0.5f;
        this.fontStart.set(f5, f4);
        this.updateText(this.textType.getText(this));
    }

    public void rightAlign(float f) {
        float f2 = this.font.getLineHeight();
        float f3 = this.font.getBase();
        float f4 = f2 * 0.5f + f3 * 0.5f;
        float f5 = 0.0f;
        if (this.textType.getText(this).length() > 0) {
            f5 = f / this.getLocalScale().x * 0.5f - (float)this.font.getWidth(this.textType.getText(this)) - (float)this.font.getWidth(this.textType.getText(this).substring(this.textType.getText(this).length() - 1, this.textType.getText(this).length())) * 0.5f;
        }
        this.fontStart.set(f5, f4);
        this.updateText(this.textType.getText(this));
    }

    protected void initRenderStates() {
        this.setLightCombineMode(0);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.setRenderState(alphaState);
    }

    public void updateGeometricState(float f, boolean bl) {
        this.update(f);
        super.updateGeometricState(f, bl);
    }

    protected void update(float f) {
        if (this.updateInterval > 0.0f) {
            this.timeAcc += f;
            if (this.timeAcc > this.updateInterval) {
                this.timeAcc = 0.0f;
                this.updateAtInterval(this.updateInterval);
            }
        }
    }

    protected void updateAtInterval(float f) {
        String string = this.textType.getText(this);
        if (!string.equals(this.curString)) {
            this.updateText(string);
            this.textType = Type.StringType;
            this.stringText = string;
        }
    }

    protected void updateText(String string) {
        this.updateText(string, this.fontVec.set(this.fontStart));
    }

    protected void updateText(String string, Vector2f vector2f) {
        int n;
        this.curString = string;
        int n2 = n = string.length() < this.length ? string.length() : this.length;
        if (!this.rightAligned) {
            for (int i = 0; i < this.length; ++i) {
                if (i < n) {
                    this.font.getChar(string.charAt(i), i < n - 1 ? (int)string.charAt(i + 1) : -1, vector2f, (SharedMesh)this.getChild(i));
                    continue;
                }
                this.font.getChar(32, -1, vector2f, (SharedMesh)this.getChild(i));
            }
        } else {
            int n3;
            for (n3 = n - 1; n3 >= 0; --n3) {
                this.font.getCharRightToLeft(string.charAt(n3), n3 < n - 1 ? (int)string.charAt(n3 + 1) : -1, vector2f, (SharedMesh)this.getChild(n3 + (this.length - n)));
            }
            for (n3 = this.length - n - 1; n3 >= 0; --n3) {
                this.font.getCharRightToLeft(32, -1, vector2f, (SharedMesh)this.getChild(n3));
            }
        }
        this.updateRenderState();
    }

    public float getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(float f) {
        this.updateInterval = f;
        if (f < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(String string) {
        this.stringText = string;
        this.textType = Type.StringType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(double d) {
        this.doubleText = d;
        this.textType = Type.DoubleType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(float f) {
        this.floatText = f;
        this.textType = Type.FloatType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(long l) {
        this.longText = l;
        this.textType = Type.LongType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(int n) {
        this.intText = n;
        this.textType = Type.IntType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(short s) {
        this.shortText = s;
        this.textType = Type.ShortType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public void setText(char c) {
        this.charText = c;
        this.textType = Type.CharType;
        if (this.updateInterval < 0.0f) {
            this.updateText(this.textType.getText(this));
        }
    }

    public boolean isRightAligned() {
        return this.rightAligned;
    }

    public void setRightAligned(boolean bl) {
        this.rightAligned = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        StringType{

            public String getText(Label label) {
                return label.stringText;
            }
        }
        ,
        DoubleType{

            public String getText(Label label) {
                return String.valueOf(label.doubleText);
            }
        }
        ,
        FloatType{

            public String getText(Label label) {
                return String.valueOf(label.floatText);
            }
        }
        ,
        LongType{

            public String getText(Label label) {
                return String.valueOf(label.longText);
            }
        }
        ,
        IntType{

            public String getText(Label label) {
                return String.valueOf(label.intText);
            }
        }
        ,
        ShortType{

            public String getText(Label label) {
                return String.valueOf(label.shortText);
            }
        }
        ,
        CharType{

            public String getText(Label label) {
                return String.valueOf(label.charText);
            }
        };


        abstract String getText(Label var1);
    }
}

