/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gui;

import com.jme.input.InputHandler;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector2f;
import com.turborilla.Updatable;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.TriggerAction;

public class GuiKeyboard
implements Updatable {
    InputAction keyboardAction;
    InputHandler registeredInputHandler;
    GuiHandler guiHandler;
    private boolean paused = false;
    private Vector2f[] prevJoyAxisValue;
    private boolean[][] prevJoyButtonValue;
    private int xAxisIndex = 0;
    private int yAxisIndex = 1;
    private int selectButtonIndex = 0;
    private int tabButtonIndex = 1;
    private boolean invertJoystickY = false;
    private boolean invertJoystickX = false;
    private boolean joystickEnabled = true;
    private Vector2f temp = new Vector2f();

    public GuiKeyboard(GuiHandler guiHandler) {
        this.guiHandler = guiHandler;
        this.keyboardAction = new KeyboardAction();
    }

    public void registerWithInputHandler(InputHandler inputHandler) {
        Joystick joystick;
        int n;
        if (this.registeredInputHandler != null) {
            this.registeredInputHandler.removeAction(this.keyboardAction);
        }
        this.registeredInputHandler = inputHandler;
        if (inputHandler != null) {
            inputHandler.addAction(this.keyboardAction, "keyboard", Integer.MIN_VALUE, -1, false);
        }
        this.prevJoyAxisValue = new Vector2f[JoystickInput.get().getJoystickCount()];
        for (n = 0; n < this.prevJoyAxisValue.length; ++n) {
            joystick = JoystickInput.get().getJoystick(n);
            this.prevJoyAxisValue[n] = new Vector2f();
            this.prevJoyAxisValue[n].set(joystick.getAxisValue(this.xAxisIndex), joystick.getAxisValue(this.yAxisIndex));
        }
        this.prevJoyButtonValue = new boolean[JoystickInput.get().getJoystickCount()][2];
        for (n = 0; n < this.prevJoyButtonValue.length; ++n) {
            joystick = JoystickInput.get().getJoystick(n);
            for (int i = 0; i < this.prevJoyButtonValue[n].length; ++i) {
                this.prevJoyButtonValue[n][i] = joystick.isButtonPressed(i);
            }
        }
    }

    private void joy() {
        JoystickInput joystickInput = JoystickInput.get();
        for (int i = 0; i < joystickInput.getJoystickCount(); ++i) {
            TriggerAction triggerAction;
            TriggerAction.Action action;
            Joystick joystick = joystickInput.getJoystick(i);
            if (this.selectButtonIndex >= joystick.getButtonCount() || this.selectButtonIndex < 0 || this.xAxisIndex >= joystick.getAxisCount() || this.xAxisIndex < 0 || this.yAxisIndex >= joystick.getAxisCount() || this.yAxisIndex < 0) continue;
            if (i < this.prevJoyButtonValue.length) {
                boolean bl;
                boolean bl2;
                if (joystick.getButtonCount() >= 1) {
                    bl2 = this.prevJoyButtonValue[i][0];
                    bl = joystick.isButtonPressed(this.selectButtonIndex);
                    if (bl2 && !bl) {
                        action = TriggerAction.Action.UP;
                        triggerAction = new TriggerAction(null, action);
                        this.guiHandler.updatedKey(28, '\u0000', triggerAction);
                    }
                    if (!bl2 && bl) {
                        action = TriggerAction.Action.DOWN;
                        triggerAction = new TriggerAction(null, action);
                        this.guiHandler.updatedKey(28, '\u0000', triggerAction);
                    }
                    this.prevJoyButtonValue[i][0] = bl;
                }
                if (joystick.getButtonCount() >= 2) {
                    bl2 = this.prevJoyButtonValue[i][1];
                    bl = joystick.isButtonPressed(this.tabButtonIndex);
                    if (bl2 && !bl) {
                        action = TriggerAction.Action.UP;
                        triggerAction = new TriggerAction(null, action);
                        this.guiHandler.updatedKey(15, '\u0000', triggerAction);
                    }
                    if (!bl2 && bl) {
                        action = TriggerAction.Action.DOWN;
                        triggerAction = new TriggerAction(null, action);
                        this.guiHandler.updatedKey(15, '\u0000', triggerAction);
                    }
                    this.prevJoyButtonValue[i][1] = bl;
                }
            }
            if (joystick.getAxisCount() < 2 || i >= this.prevJoyAxisValue.length) continue;
            Vector2f vector2f = this.prevJoyAxisValue[i];
            Vector2f vector2f2 = this.temp.set(joystick.getAxisValue(this.xAxisIndex), joystick.getAxisValue(this.yAxisIndex));
            if (vector2f.x > 0.6f && vector2f2.x < 0.4f) {
                action = TriggerAction.Action.UP;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickX() ? 203 : 205, '\u0000', triggerAction);
            }
            if (vector2f.x < 0.4f && vector2f2.x > 0.6f) {
                action = TriggerAction.Action.DOWN;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickX() ? 203 : 205, '\u0000', triggerAction);
            }
            if (vector2f.x < -0.6f && vector2f2.x > -0.4f) {
                action = TriggerAction.Action.UP;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickX() ? 205 : 203, '\u0000', triggerAction);
            }
            if (vector2f.x > -0.4f && vector2f2.x < -0.6f) {
                action = TriggerAction.Action.DOWN;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickX() ? 205 : 203, '\u0000', triggerAction);
            }
            if (vector2f.y > 0.6f && vector2f2.y < 0.4f) {
                action = TriggerAction.Action.UP;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickY() ? 208 : 200, '\u0000', triggerAction);
            }
            if (vector2f.y < 0.4f && vector2f2.y > 0.6f) {
                action = TriggerAction.Action.DOWN;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickY() ? 208 : 200, '\u0000', triggerAction);
            }
            if (vector2f.y < -0.6f && vector2f2.y > -0.4f) {
                action = TriggerAction.Action.UP;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickY() ? 200 : 208, '\u0000', triggerAction);
            }
            if (vector2f.y > -0.4f && vector2f2.y < -0.6f) {
                action = TriggerAction.Action.DOWN;
                triggerAction = new TriggerAction(null, action);
                this.guiHandler.updatedKey(this.isInvertJoystickY() ? 200 : 208, '\u0000', triggerAction);
            }
            this.prevJoyAxisValue[i].set(vector2f2);
        }
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
        if (this.joystickEnabled) {
            this.joy();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isInvertJoystickY() {
        return this.invertJoystickY;
    }

    public void setInvertJoystickY(boolean bl) {
        this.invertJoystickY = bl;
    }

    public boolean isJoystickEnabled() {
        return this.joystickEnabled;
    }

    public void setJoystickEnabled(boolean bl) {
        this.joystickEnabled = bl;
    }

    public int getXAxisIndex() {
        return this.xAxisIndex;
    }

    public void setXAxisIndex(int n) {
        this.xAxisIndex = n;
    }

    public int getYAxisIndex() {
        return this.yAxisIndex;
    }

    public void setYAxisIndex(int n) {
        this.yAxisIndex = n;
    }

    public int getSelectButtonIndex() {
        return this.selectButtonIndex;
    }

    public void setSelectButtonIndex(int n) {
        this.selectButtonIndex = n;
    }

    public int getTabButtonIndex() {
        return this.tabButtonIndex;
    }

    public void setTabButtonIndex(int n) {
        this.tabButtonIndex = n;
    }

    public boolean isInvertJoystickX() {
        return this.invertJoystickX;
    }

    public void setInvertJoystickX(boolean bl) {
        this.invertJoystickX = bl;
    }

    private class KeyboardAction
    extends InputAction {
        private KeyboardAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            int n = inputActionEvent.getTriggerIndex();
            char c = inputActionEvent.getTriggerCharacter();
            TriggerAction.Action action = inputActionEvent.getTriggerPressed() ? TriggerAction.Action.DOWN : TriggerAction.Action.UP;
            TriggerAction triggerAction = new TriggerAction(null, action);
            GuiKeyboard.this.guiHandler.updatedKey(n, c, triggerAction);
        }
    }
}

