/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gameobject;

import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IGameObjectHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class GameObjectHandler
implements IGameObjectHandler {
    private static final Logger logger = Logger.getLogger(GameObjectHandler.class.getName());
    private List<GameObject> pausedGameObjects;
    private List<GameObject> gameObjectList;
    private boolean paused = false;
    LinkedList<GameObject> destructionQueue = new LinkedList();

    public GameObjectHandler() {
        this.gameObjectList = new ArrayList<GameObject>();
        this.pausedGameObjects = new ArrayList<GameObject>();
    }

    public void addGameObject(GameObject gameObject) {
        if (this.gameObjectList.contains(gameObject)) {
            logger.warning("gameObject " + gameObject + " already exists in the gameObjectList");
            return;
        }
        this.gameObjectList.add(gameObject);
        if (this.isPaused()) {
            this.pausedGameObjects.add(gameObject);
            gameObject.setPaused(true);
        }
    }

    public boolean removeGameObject(GameObject gameObject) {
        if (gameObject == null) {
            return false;
        }
        this.pausedGameObjects.remove(gameObject);
        if (this.gameObjectList.remove(gameObject)) {
            gameObject.onDetach();
            return true;
        }
        return false;
    }

    public boolean removeGameObject(String string) {
        return this.removeGameObject(this.hasGameObject(string));
    }

    public void removeAllGameObjects() {
        for (int i = 0; i < this.gameObjectList.size(); ++i) {
            this.removeGameObject(this.gameObjectList.get(i));
        }
        this.pausedGameObjects.clear();
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
        for (GameObject gameObject : this.gameObjectList) {
            if (gameObject.isToBeDetached()) {
                this.destructionQueue.add(gameObject);
                continue;
            }
            gameObject.update(f);
        }
        this.removeThoseQueuedForDestruction();
    }

    public void setPaused(boolean bl) {
        if (!this.isPaused() && bl) {
            for (GameObject gameObject : this.gameObjectList) {
                if (gameObject == null || gameObject.isPaused()) continue;
                this.pausedGameObjects.add(gameObject);
                gameObject.setPaused(true);
            }
        } else if (this.isPaused() && !bl) {
            for (int i = 0; i < this.pausedGameObjects.size(); ++i) {
                GameObject gameObject = this.pausedGameObjects.get(i);
                if (gameObject == null || !gameObject.isPaused()) continue;
                gameObject.setPaused(false);
            }
            this.pausedGameObjects.clear();
        }
        this.paused = bl;
    }

    public GameObject hasGameObject(String string) {
        GameObject gameObject = null;
        for (GameObject gameObject2 : this.gameObjectList) {
            if (!gameObject2.getName().equals(string)) continue;
            gameObject = gameObject2;
            break;
        }
        return gameObject;
    }

    protected void removeThoseQueuedForDestruction() {
        GameObject gameObject;
        while ((gameObject = this.destructionQueue.poll()) != null) {
            this.removeGameObject(gameObject);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }
}

