/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.gameobject;

import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.ComponentHandler;
import com.turborilla.msm.states.GameObjectState;

public class GameObject
extends ComponentHandler
implements IEventListener {
    private String name;
    private EventManager eventManager;
    private GameObjectState parentGameState;
    private boolean toBeDetached = false;

    public GameObject(String string) {
        this.name = string;
        this.setParentGameObject(this);
    }

    public void update(float f) {
        if (this.eventManager != null) {
            this.eventManager.handleEvents(this);
        }
        if (!this.paused) {
            super.update(f);
        }
    }

    protected void detachThis() {
        this.toBeDetached = true;
    }

    public void onDetach() {
        this.parentGameState = null;
        if (this.eventManager != null) {
            this.eventManager.unregisterListener(this);
        }
        this.toBeDetached = false;
        this.clearComponents();
    }

    public void registerForEvents(EventManager eventManager) {
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        if (eventManager != null) {
            eventManager.unregisterListener(this);
        }
        this.eventManager = eventManager;
        if (this.eventManager != null) {
            this.registerForEvents(this.eventManager);
        }
    }

    public GameObjectState getParentGameState() {
        return this.parentGameState;
    }

    public void setParentGameState(GameObjectState gameObjectState) {
        this.parentGameState = gameObjectState;
        if (this.eventManager != null) {
            this.eventManager.unregisterListener(this);
        }
        this.eventManager = gameObjectState != null ? gameObjectState.getEventManager() : null;
        if (this.eventManager != null) {
            this.registerForEvents(this.eventManager);
        }
    }

    public boolean isToBeDetached() {
        return this.toBeDetached;
    }

    public boolean isRemoveMeFromEventmanager() {
        return false;
    }
}

