/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.fx.shadows;

import com.jme.light.Light;
import com.jme.renderer.Renderer;
import com.jme.renderer.pass.ShadowedRenderPass;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shadow.MeshShadows;
import com.jme.scene.state.LightState;
import com.turborilla.fx.shadows.SimplifiedMeshShadows;

public class SimplifiedShadowedRenderPass
extends ShadowedRenderPass {
    protected void generateVolumes() {
        for (int i = 0; i < this.occluderMeshes.size(); ++i) {
            TriangleBatch triangleBatch = (TriangleBatch)this.occluderMeshes.get(i);
            if (!this.getShadowGate().shouldUpdateShadows(triangleBatch)) continue;
            if (!this.meshes.containsKey(triangleBatch)) {
                this.meshes.put(triangleBatch, new SimplifiedMeshShadows(triangleBatch));
            } else if ((triangleBatch.getLocks() & 8) != 0) continue;
            MeshShadows meshShadows = (MeshShadows)this.meshes.get(triangleBatch);
            meshShadows.createGeometry((LightState)triangleBatch.states[3]);
        }
    }

    public void doRender(Renderer renderer) {
        Light light;
        this.init();
        if (!this.renderShadows) {
            this.renderScene(renderer);
            if (this.renderVolume) {
                this.getShadowLights();
                this.setupOccluderMeshes();
                this.generateVolumes();
                this.drawVolumes(renderer);
            }
            return;
        }
        this.getShadowLights();
        this.setupOccluderMeshes();
        if (this.occluderMeshes.size() == 0 || this.shadowLights.size() == 0) {
            this.renderScene(renderer);
            this.cleanup();
            return;
        }
        if (this.lightingMethod == 0) {
            this.maskShadowLights(6);
            this.saveEnforcedStates();
            this.context.enforceState(noTexture);
            this.renderScene(renderer);
            this.replaceEnforcedStates();
            this.unmaskShadowLights();
            renderer.setPolygonOffset(0.0f, -5.0f);
        } else {
            this.renderScene(renderer);
        }
        this.generateVolumes();
        int n = this.shadowLights.size();
        while (--n >= 0) {
            light = (Light)this.shadowLights.get(n);
            light.setEnabled(false);
        }
        n = this.shadowLights.size();
        while (--n >= 0) {
            light = (Light)this.shadowLights.get(n);
            renderer.clearStencilBuffer();
            light.setEnabled(true);
            this.saveEnforcedStates();
            this.context.enforceState(noTexture);
            this.context.enforceState(forTesting);
            this.context.enforceState(colorDisabled);
            this.context.enforceState(stencilFrontFaces);
            this.context.enforceState(cullBackFace);
            this.volumeNode.getChildren().clear();
            this.addShadowVolumes(light);
            this.volumeNode.updateWorldVectors();
            this.volumeNode.onDraw(renderer);
            this.context.enforceState(cullFrontFace);
            for (TriangleBatch triangleBatch : this.occluderMeshes) {
                triangleBatch.onDraw(renderer);
            }
            this.context.enforceState(stencilBackFaces);
            this.context.enforceState(cullFrontFace);
            this.volumeNode.onDraw(renderer);
            this.context.enforceState(cullBackFace);
            for (TriangleBatch triangleBatch : this.occluderMeshes) {
                triangleBatch.onDraw(renderer);
            }
            this.context.enforceState(colorEnabled);
            this.context.enforceState(forColorPassTesting);
            this.context.enforceState(cullBackFace);
            if (this.lightingMethod == 0) {
                this.context.enforceState(lights);
                this.context.enforceState(blended);
                lights.detachAll();
                lights.attach(light);
                this.context.enforceState(stencilDrawWhenNotSet);
                this.renderScene(renderer);
            } else if (rTexture) {
                this.context.enforceState(modblended);
                this.context.enforceState(zbufferAlways);
                this.context.enforceState(cullBackFace);
                this.context.enforceState(noLights);
                this.context.enforceState(stencilDrawOnlyWhenSet);
                this.shadowColor.a = 1.0f - light.getAmbient().a;
                this.shadowQuad.setDefaultColor(this.shadowColor);
                renderer.setOrtho();
                this.resetShadowQuad(renderer);
                this.shadowQuad.draw(renderer);
                renderer.unsetOrtho();
            }
            light.setEnabled(false);
            this.replaceEnforcedStates();
        }
        n = this.shadowLights.size();
        while (--n >= 0) {
            light = (Light)this.shadowLights.get(n);
            light.setEnabled(true);
        }
        if (this.lightingMethod == 0 && rTexture) {
            this.saveEnforcedStates();
            this.context.enforceState(noStencil);
            this.context.enforceState(colorEnabled);
            this.context.enforceState(cullBackFace);
            this.context.enforceState(blendTex);
            this.renderScene(renderer);
            this.replaceEnforcedStates();
        }
        if (this.renderVolume) {
            this.drawVolumes(renderer);
        }
        this.cleanup();
    }
}

