/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.fx.shadows;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shadow.MeshShadows;
import com.jme.scene.shadow.ShadowEdge;
import com.jme.scene.shadow.ShadowVolume;
import com.jme.scene.state.LightState;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;

public class SimplifiedMeshShadows
extends MeshShadows {
    private int maxIndex;
    private ShadowEdge[] edges = null;
    private Vector3f[] normals = null;
    private FloatBuffer worldCoords = null;
    private static Vector3f p0 = new Vector3f();
    private static Vector3f p1 = new Vector3f();
    private static Vector3f p2 = new Vector3f();
    private static Vector3f p3 = new Vector3f();
    private static Vector3f direction = new Vector3f();
    private static Vector3f location = new Vector3f();
    private static Vector3f normal = new Vector3f();
    private static Vector3f tempNormal = new Vector3f();

    public SimplifiedMeshShadows(TriangleBatch triangleBatch) {
        super(triangleBatch);
        this.faces = null;
        this.facing = null;
    }

    protected ShadowEdge[] getShadowEdges(IntBuffer intBuffer) {
        ArrayList<ShadowEdge> arrayList = new ArrayList<ShadowEdge>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        intBuffer.rewind();
        IntBuffer intBuffer2 = intBuffer.duplicate();
        while (intBuffer.hasRemaining()) {
            n = intBuffer.get();
            n2 = intBuffer.get();
            n3 = intBuffer.get();
            ShadowEdge shadowEdge = new ShadowEdge(n, n2);
            if (this.checkIfEdgeIsOnBoundary(shadowEdge, intBuffer2)) {
                arrayList.add(shadowEdge);
            }
            if (this.checkIfEdgeIsOnBoundary(shadowEdge = new ShadowEdge(n2, n3), intBuffer2)) {
                arrayList.add(shadowEdge);
            }
            if (!this.checkIfEdgeIsOnBoundary(shadowEdge = new ShadowEdge(n3, n), intBuffer2)) continue;
            arrayList.add(shadowEdge);
        }
        intBuffer.rewind();
        return arrayList.toArray(new ShadowEdge[0]);
    }

    protected boolean checkIfEdgeIsOnBoundary(ShadowEdge shadowEdge, IntBuffer intBuffer) {
        intBuffer.rewind();
        while (intBuffer.hasRemaining()) {
            int n = intBuffer.get();
            int n2 = intBuffer.get();
            int n3 = intBuffer.get();
            if (shadowEdge.p0 == n2 && shadowEdge.p1 == n) {
                return false;
            }
            if (shadowEdge.p0 == n3 && shadowEdge.p1 == n2) {
                return false;
            }
            if (shadowEdge.p0 != n || shadowEdge.p1 != n3) continue;
            return false;
        }
        intBuffer.rewind();
        return true;
    }

    protected Vector3f[] getNormals(ShadowEdge[] shadowEdgeArray, FloatBuffer floatBuffer) {
        Vector3f[] vector3fArray = this.normals != null && this.normals.length == shadowEdgeArray.length ? this.normals : new Vector3f[shadowEdgeArray.length];
        for (int i = 0; i < shadowEdgeArray.length; ++i) {
            int n = shadowEdgeArray[i].p0;
            if (vector3fArray[i] == null) {
                vector3fArray[i] = new Vector3f();
            }
            BufferUtils.populateFromBuffer(vector3fArray[i], floatBuffer, n);
        }
        return vector3fArray;
    }

    public void createGeometry(LightState lightState) {
        if (lightState.getQuantity() != 0) {
            LightState lightState2 = lightState;
            for (int i = 0; i < lightState2.getQuantity(); ++i) {
                IntBuffer intBuffer;
                FloatBuffer floatBuffer;
                int n;
                Light light = lightState2.get(i);
                if (!light.isShadowCaster() || light.getType() != 0 && light.getType() != 1) continue;
                ShadowVolume shadowVolume = this.getShadowVolume(light);
                if (shadowVolume == null) {
                    shadowVolume = new ShadowVolume(light);
                    if (shadowVolume.getBatchCount() < 1) {
                        shadowVolume.addBatch(new TriangleBatch());
                    }
                    this.volumes.add(shadowVolume);
                    shadowVolume.setUpdate(true);
                }
                if (!this.target.isEnabled() || !this.target.isCastsShadows()) {
                    shadowVolume.getBatch(0).setEnabled(false);
                    continue;
                }
                shadowVolume.getBatch(0).setEnabled(true);
                if (this.worldCoords == null || this.worldCoords.capacity() != this.target.getVertexBuffer().limit()) {
                    this.worldCoords = BufferUtils.createFloatBuffer(this.target.getVertexBuffer().limit());
                }
                int n2 = this.worldCoords.capacity() / 3;
                for (n = 0; n < n2; ++n) {
                    BufferUtils.populateFromBuffer(compVect, this.target.getVertexBuffer(), n);
                    this.target.getParentGeom().getWorldRotation().multLocal(compVect).multLocal(this.target.getParentGeom().getWorldScale()).addLocal(this.target.getParentGeom().getWorldTranslation());
                    BufferUtils.setInBuffer(compVect, this.worldCoords, n);
                }
                this.worldCoords.clear();
                if (this.edges == null || shadowVolume.isUpdate()) {
                    shadowVolume.setUpdate(false);
                    this.edges = this.getShadowEdges(this.target.getIndexBuffer());
                    this.normals = this.getNormals(this.edges, this.target.getNormalBuffer());
                }
                n = this.edges.length;
                FloatBuffer floatBuffer2 = shadowVolume.getBatch(0).getVertexBuffer();
                if (floatBuffer2 == null || floatBuffer2.capacity() < n * 12) {
                    floatBuffer2 = BufferUtils.createVector3Buffer(n * 4);
                }
                if ((floatBuffer = shadowVolume.getBatch(0).getNormalBuffer()) == null || floatBuffer.capacity() < n * 12) {
                    floatBuffer = BufferUtils.createVector3Buffer(n * 4);
                }
                if ((intBuffer = shadowVolume.getBatch(0).getIndexBuffer()) == null || intBuffer.capacity() < n * 6) {
                    intBuffer = BufferUtils.createIntBuffer(n * 6);
                }
                floatBuffer2.limit(n * 12);
                floatBuffer.limit(n * 12);
                intBuffer.limit(n * 6);
                this.createShadowQuads(this.worldCoords, this.edges, floatBuffer2, floatBuffer, intBuffer, light);
                shadowVolume.reconstruct(floatBuffer2, floatBuffer, null, null, intBuffer, 0);
                floatBuffer2.rewind();
                shadowVolume.getBatch(0).setVertexCount(floatBuffer2.remaining() / 3);
                intBuffer.rewind();
                shadowVolume.getBatch(0).setTriangleQuantity(intBuffer.remaining() / 3);
                shadowVolume.updateModelBound();
                if ((this.target.getLocks() & 8) == 0) continue;
                shadowVolume.lock();
            }
        } else {
            this.volumes.clear();
        }
    }

    protected void createShadowQuads(FloatBuffer floatBuffer, ShadowEdge[] shadowEdgeArray, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, IntBuffer intBuffer, Light light) {
        boolean bl;
        boolean bl2 = bl = light.getType() == 0;
        if (bl) {
            direction.set(((DirectionalLight)light).getDirection());
        } else {
            location.set(((PointLight)light).getLocation());
        }
        for (int i = 0; i < shadowEdgeArray.length; ++i) {
            BufferUtils.populateFromBuffer(p0, floatBuffer, shadowEdgeArray[i].p0);
            BufferUtils.populateFromBuffer(p3, floatBuffer, shadowEdgeArray[i].p1);
            if (!bl) {
                p0.subtract(location, direction).normalizeLocal();
            }
            direction.mult(this.projectionLength, p1).addLocal(p0);
            if (!bl) {
                p3.subtract(location, direction).normalizeLocal();
            }
            p2.set(direction).multLocal(this.projectionLength).addLocal(p3);
            int n = i * 4;
            BufferUtils.setInBuffer(p0, floatBuffer2, n);
            BufferUtils.setInBuffer(p1, floatBuffer2, n + 1);
            BufferUtils.setInBuffer(p2, floatBuffer2, n + 2);
            BufferUtils.setInBuffer(p3, floatBuffer2, n + 3);
            p1.subtract(p0, normal).normalizeLocal().crossLocal(p3.subtract(p0, tempNormal).normalizeLocal()).normalizeLocal();
            BufferUtils.setInBuffer(normal, floatBuffer3, n);
            BufferUtils.setInBuffer(normal, floatBuffer3, n + 1);
            BufferUtils.setInBuffer(normal, floatBuffer3, n + 2);
            BufferUtils.setInBuffer(normal, floatBuffer3, n + 3);
            int n2 = i * 6;
            if (this.normals[i].dot(direction) <= 0.0f) {
                intBuffer.put(n2 + 0, n + 0);
                intBuffer.put(n2 + 1, n + 1);
                intBuffer.put(n2 + 2, n + 3);
                intBuffer.put(n2 + 3, n + 3);
                intBuffer.put(n2 + 4, n + 1);
                intBuffer.put(n2 + 5, n + 2);
                continue;
            }
            intBuffer.put(n2 + 0, n + 0);
            intBuffer.put(n2 + 2, n + 1);
            intBuffer.put(n2 + 1, n + 3);
            intBuffer.put(n2 + 3, n + 3);
            intBuffer.put(n2 + 5, n + 1);
            intBuffer.put(n2 + 4, n + 2);
        }
    }
}

