/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.event.typesafe;

import com.turborilla.event.typesafe.Event;
import com.turborilla.event.typesafe.EventErrorException;
import com.turborilla.event.typesafe.IEventListener;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.event.typesafe.ValidEventsXMLParser;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class EventManager {
    private static final Logger logger = Logger.getLogger(EventManager.class.getName());
    protected Map<String, ArrayList<IEventListener>> registeredListeners;
    protected Map<IEventListener, LinkedList<ReceivedEvent>> listenerEventQueue;
    protected Map<String, ValidEvent> validEvents;
    protected URL validEventsFile;
    protected boolean checkArgumentTypes = true;
    protected boolean loggingEnabled = true;
    ArrayList<ReceivedEvent> eventList = new ArrayList();
    private boolean handlingAllEvents = false;
    private ArrayList<ListenerEventPair> listenerEventList = new ArrayList();
    private ArrayList<IEventListener> toBeRemoved = new ArrayList();
    public boolean cleanedUp = false;
    private ArrayList<ValidEvent.Argument> argumentsXML;
    private ValidEvent eventXML = null;

    public EventManager(URL uRL) throws EventErrorException {
        this.validEventsFile = uRL;
        this.validEvents = new HashMap<String, ValidEvent>();
        this.listenerEventQueue = Collections.synchronizedMap(new WeakHashMap());
        this.registeredListeners = new HashMap<String, ArrayList<IEventListener>>();
        try {
            new ValidEventsXMLParser(this, uRL);
        }
        catch (Exception exception) {
            throw new EventErrorException("Could not parse valid events file: \"" + uRL + "\". Remember that upper or lower case matters.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String string, IEventListener iEventListener) throws EventErrorException {
        if (!this.validEvents.containsKey(string)) {
            throw new EventErrorException("\"" + string + "\" is not a valid event for this EventManager as specified by " + this.validEventsFile.toString());
        }
        ArrayList<IEventListener> arrayList = this.registeredListeners.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(iEventListener);
            this.registeredListeners.put(string, arrayList);
        } else if (arrayList.contains(iEventListener)) {
            logger.warning("listener is already in the list for event \"" + string + "\"");
        } else {
            arrayList.add(iEventListener);
        }
        Map<IEventListener, LinkedList<ReceivedEvent>> map = this.listenerEventQueue;
        synchronized (map) {
            if (this.listenerEventQueue.get(iEventListener) == null) {
                this.listenerEventQueue.put(iEventListener, new LinkedList());
            }
        }
    }

    public boolean unregisterListenerForEvent(IEventListener iEventListener, String string) {
        ArrayList<IEventListener> arrayList = this.registeredListeners.get(string);
        if (arrayList != null) {
            return arrayList.remove(iEventListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(IEventListener iEventListener) {
        boolean bl = false;
        this.handleEvents(iEventListener);
        for (Map.Entry<String, ArrayList<IEventListener>> entry : this.registeredListeners.entrySet()) {
            ArrayList<IEventListener> arrayList = entry.getValue();
            if (arrayList == null || !arrayList.remove(iEventListener)) continue;
            bl = true;
        }
        Map<IEventListener, LinkedList<ReceivedEvent>> map = this.listenerEventQueue;
        synchronized (map) {
            this.listenerEventQueue.remove(iEventListener);
        }
        return bl;
    }

    public void fireEvent(String string) {
        this.fireEvent(string, (String[][])null);
    }

    public void fireEvent(String string, String[][] stringArray) throws EventErrorException {
        ValidEvent validEvent = this.getValidEvent(string);
        String[][] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[2][stringArray[0].length];
            for (int i = 0; i < stringArray[0].length; ++i) {
                stringArray2[0][i] = stringArray[0][i];
                stringArray2[1][i] = stringArray[1][i];
            }
        } else {
            stringArray2 = new String[0][0];
        }
        Event event = new Event(string, stringArray2);
        this.fireEvent(validEvent, event);
    }

    public void fireEvent(Event event) throws EventErrorException {
        ValidEvent validEvent = this.getValidEvent(event.name);
        this.fireEvent(validEvent, event.getReceivedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleEvents(IEventListener iEventListener) {
        int n = 0;
        ReceivedEvent receivedEvent = null;
        Map<IEventListener, LinkedList<ReceivedEvent>> map = this.listenerEventQueue;
        synchronized (map) {
            LinkedList<ReceivedEvent> linkedList = this.listenerEventQueue.get(iEventListener);
            if (linkedList != null) {
                while ((receivedEvent = linkedList.poll()) != null) {
                    this.eventList.add(receivedEvent);
                    ++n;
                }
            }
        }
        for (int i = 0; i < this.eventList.size(); ++i) {
            receivedEvent = this.eventList.get(i);
            iEventListener.handleEvent(receivedEvent);
            if (!this.loggingEnabled) continue;
            logger.info("Event \"" + receivedEvent.name + "\" was handled by listener \"" + iEventListener.getName() + "\"");
        }
        this.eventList.clear();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAllEvents() {
        if (this.handlingAllEvents) {
            return;
        }
        this.handlingAllEvents = true;
        Map<IEventListener, LinkedList<ReceivedEvent>> map = this.listenerEventQueue;
        synchronized (map) {
            for (Map.Entry<IEventListener, LinkedList<ReceivedEvent>> object : this.listenerEventQueue.entrySet()) {
                ReceivedEvent receivedEvent;
                IEventListener iEventListener = object.getKey();
                LinkedList<ReceivedEvent> linkedList = object.getValue();
                if (linkedList == null) continue;
                while ((receivedEvent = linkedList.poll()) != null) {
                    this.listenerEventList.add(new ListenerEventPair(iEventListener, receivedEvent));
                }
            }
        }
        for (int i = 0; i < this.listenerEventList.size(); ++i) {
            ListenerEventPair listenerEventPair = this.listenerEventList.get(i);
            IEventListener iEventListener = (IEventListener)listenerEventPair.listener.get();
            if (iEventListener == null) continue;
            iEventListener.handleEvent(listenerEventPair.event);
            if (!this.loggingEnabled) continue;
            logger.info("Event \"" + listenerEventPair.event.name + "\" was handled by listener \"" + iEventListener.getName() + "\"");
        }
        this.listenerEventList.clear();
        this.handlingAllEvents = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ValidEvent validEvent, ReceivedEvent receivedEvent) throws EventErrorException {
        if (this.checkArgumentTypes && !this.isValidArguments(validEvent, receivedEvent)) {
            throw new EventErrorException("Not valid arguments for event: " + receivedEvent);
        }
        if (!validEvent.enabled) {
            return;
        }
        receivedEvent.setEventManager(this);
        int n = 0;
        ArrayList<IEventListener> arrayList = this.registeredListeners.get(receivedEvent.name);
        if (arrayList != null) {
            Map<IEventListener, LinkedList<ReceivedEvent>> map = this.listenerEventQueue;
            synchronized (map) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.listenerEventQueue.get(arrayList.get(n)).add(receivedEvent);
                    ++n;
                }
            }
        }
        if (this.loggingEnabled) {
            logger.info("Enqueued event \"" + receivedEvent.name + "\" with arguments \"" + Arrays.deepToString((Object[])receivedEvent.arguments) + "\". " + n + " listeners cared.");
        }
    }

    ValidEvent getValidEvent(String string) throws EventErrorException {
        ValidEvent validEvent = this.validEvents.get(string);
        if (validEvent == null) {
            throw new EventErrorException("\"" + string + "\" is not a valid event for this EventManager as specified by " + this.validEventsFile.toString());
        }
        return validEvent;
    }

    boolean isValidArguments(ValidEvent validEvent, ReceivedEvent receivedEvent) {
        boolean bl = true;
        if (validEvent.arguments == null && receivedEvent.arguments != null && receivedEvent.arguments.length != 0) {
            return false;
        }
        if (receivedEvent.arguments != null && receivedEvent.arguments.length > 0) {
            for (String object : receivedEvent.arguments[0]) {
                boolean string = false;
                for (ValidEvent.Argument argument : validEvent.arguments) {
                    if (!argument.name.equals(object)) continue;
                    string = true;
                    break;
                }
                if (string) continue;
                throw new EventErrorException("\"" + (String)object + "\" is not a valid argument name for event \"" + validEvent.name + "\"");
            }
        }
        if (validEvent.arguments == null) {
            return true;
        }
        for (ValidEvent.Argument argument : validEvent.arguments) {
            String string = receivedEvent.getArgumentValue(argument.name);
            if (argument.required && string == null) {
                throw new EventErrorException("Argument \"" + argument.name + "\" missing for event \"" + validEvent.name + "\"");
            }
            if (string == null) continue;
            try {
                argument.type.getValue(string);
            }
            catch (RuntimeException runtimeException) {
                throw new EventErrorException("\"" + string + "\" cannot be parsed to the type \"" + (Object)((Object)argument.type) + "\" for argument \"" + argument.name + "\" of event \"" + validEvent.name + "\"", runtimeException);
            }
        }
        return bl;
    }

    public boolean isCheckArgumentTypes() {
        return this.checkArgumentTypes;
    }

    public void setCheckArgumentTypes(boolean bl) {
        this.checkArgumentTypes = bl;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }

    public void handleRemoveRequests() {
        for (Map.Entry<String, ArrayList<IEventListener>> entry : this.registeredListeners.entrySet()) {
            ArrayList<IEventListener> arrayList;
            if (entry == null || (arrayList = entry.getValue()) == null) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).isRemoveMeFromEventmanager()) continue;
                this.toBeRemoved.add(arrayList.get(i));
            }
        }
        for (int i = 0; i < this.toBeRemoved.size(); ++i) {
            this.unregisterListener(this.toBeRemoved.get(i));
        }
        this.toBeRemoved.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        IEventListener iEventListener;
        Map.Entry<String, ArrayList<IEventListener>> entry22;
        if (this.cleanedUp) {
            return;
        }
        this.cleanedUp = true;
        String string = "Listeners registered in eventmanager: \n";
        int n = 0;
        for (Map.Entry<String, ArrayList<IEventListener>> entry22 : this.registeredListeners.entrySet()) {
            if (entry22 == null || entry22.getValue() == null) continue;
            ArrayList<IEventListener> arrayList = entry22.getValue();
            Iterator<IEventListener> object = arrayList.iterator();
            while (object.hasNext()) {
                iEventListener = object.next();
                string = string + n++ + ": " + iEventListener.getName() + "\n";
            }
        }
        string = string + "Listeners registered in listenerEventQueue: \n";
        int n2 = 0;
        entry22 = this.listenerEventQueue;
        synchronized (entry22) {
            for (Map.Entry entry : this.listenerEventQueue.entrySet()) {
                if (entry == null || entry.getKey() == null || (iEventListener = (IEventListener)entry.getKey()) == null) continue;
                string = string + n2++ + ": " + iEventListener.getName() + "\n";
            }
        }
        string = string + "registeredListeners.size() = " + n + "\n";
        string = string + "listenerEventQueue.size() =  " + n2 + "\n";
        string = string + "eventList.size() =           " + this.eventList.size() + "\n";
        string = string + "listenerEventList.size() =   " + this.listenerEventList.size() + "\n";
        System.out.println("EventManager:\n" + string);
        this.registeredListeners.clear();
        this.eventList.clear();
        this.listenerEventList.clear();
        this.listenerEventQueue.clear();
    }

    void startEvent(String string, boolean bl) {
        this.eventXML = new ValidEvent();
        this.eventXML.name = string;
        this.eventXML.enabled = bl;
        if (this.argumentsXML == null) {
            this.argumentsXML = new ArrayList();
        } else {
            this.argumentsXML.clear();
        }
    }

    void startArgument(String string, String string2, boolean bl) throws SAXException {
        ValidEvent validEvent = this.eventXML;
        validEvent.getClass();
        this.argumentsXML.add(validEvent.new ValidEvent.Argument(string, string2, bl));
    }

    void endEvent() throws SAXException {
        this.eventXML.arguments = this.argumentsXML.size() > 0 ? this.argumentsXML.toArray(new ValidEvent.Argument[0]) : null;
        if (this.validEvents.containsKey(this.eventXML.name)) {
            throw new SAXException("\"" + this.eventXML.name + "\" is declared more than once in " + this.validEventsFile.toString());
        }
        this.validEvents.put(this.eventXML.name, this.eventXML);
        this.eventXML = null;
    }

    void endParsing() {
        this.argumentsXML = null;
        this.eventXML = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ArgumentType {
        Integer{

            Object getValue(String string) {
                return new Integer(string);
            }
        }
        ,
        Decimal{

            Object getValue(String string) {
                return new Double(string);
            }
        }
        ,
        Boolean{

            Object getValue(String string) {
                return java.lang.Boolean.valueOf(string);
            }
        }
        ,
        String{

            Object getValue(String string) {
                return string;
            }
        };


        abstract Object getValue(String var1);
    }

    protected class ValidEvent {
        String name;
        Argument[] arguments;
        boolean enabled;

        ValidEvent() {
        }

        ValidEvent(String string, Argument[] argumentArray, boolean bl) {
            this.name = string;
            this.arguments = argumentArray;
            this.enabled = bl;
        }

        public class Argument {
            String name;
            ArgumentType type;
            boolean required;

            Argument() {
            }

            Argument(String string, String string2, boolean bl) throws SAXException {
                this.name = string;
                this.type = ArgumentType.valueOf(string2);
                this.required = bl;
            }
        }
    }

    private class ListenerEventPair {
        public WeakReference<IEventListener> listener;
        public ReceivedEvent event;

        ListenerEventPair(IEventListener iEventListener, ReceivedEvent receivedEvent) {
            this.listener = new WeakReference<IEventListener>(iEventListener);
            this.event = receivedEvent;
        }
    }
}

