/*
 * Decompiled with CFR 0.152.
 */
package com.tobbes.xbike.track;

import com.jme.bounding.BoundingBox;
import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import com.tobbes.terrain.ImageHeightMap;
import com.tobbes.xbike.track.Track;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.physics.collision.Collision1DHeightMap;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.utils.math.Vector3d;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Random;

@Deprecated
public class Track1D
extends Track
implements Externalizable {
    private static final long serialVersionUID = -7708713603039456277L;
    protected ImageHeightMap collisionHeightMap;
    protected ImageHeightMap featureMap;
    protected ImageHeightMap originalHeightMap;
    protected ImageHeightMap originalFeatureMap;
    protected int originalHeightMapStartsAt = -1;
    protected float forceWidthAdder = 0.0f;
    protected float lastRowAdder = 60.0f;
    protected Collision1DHeightMap collisionStructure;
    protected int driveAreaBeginYIndex = 0;
    private int extendX;

    public com.turborilla.msm.track.Track1D convert() {
        com.turborilla.msm.track.Track1D track1D = new com.turborilla.msm.track.Track1D(this.name, this.originalHeightMap.convert(), this.originalFeatureMap.convert(), this.stepScale, this.offset, this.offsetAmount, this.textureScale);
        return track1D;
    }

    public Track1D() {
        super("");
    }

    public Track1D(String string, ImageHeightMap imageHeightMap, ImageHeightMap imageHeightMap2, Vector3f vector3f, Vector2f vector2f, int n, Vector2f vector2f2) {
        super(string);
        this.stepScale = vector3f;
        vector3f.z = 0.7f;
        this.offset = vector2f;
        this.offsetAmount = n;
        this.textureScale = vector2f2;
        this.reconstruct(imageHeightMap, imageHeightMap2);
    }

    public void reconstruct(ImageHeightMap imageHeightMap, ImageHeightMap imageHeightMap2) {
        int n;
        this.unlock();
        try {
            this.originalHeightMap = imageHeightMap.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        try {
            this.originalFeatureMap = imageHeightMap2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        this.extendX = (int)(7.5f / this.stepScale.x);
        imageHeightMap.extendHeightMap(this.extendX * 6, this.extendX * 60, 0, 0, 0);
        imageHeightMap2.extendHeightMap(this.extendX * 6, this.extendX * 60, 0, 0);
        this.originalHeightMapStartsAt = this.extendX * 6;
        this.collisionHeightMap = imageHeightMap;
        this.collisionHeightMap.setStepScale(this.stepScale);
        this.featureMap = imageHeightMap2;
        ImageHeightMap imageHeightMap3 = new ImageHeightMap();
        int[] nArray = new int[imageHeightMap.getXsize() * 2];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 = n < imageHeightMap.getXsize() ? n : n - imageHeightMap.getXsize();
            nArray[n] = imageHeightMap.getHeightMap()[n2];
        }
        imageHeightMap3.setHeightData(nArray, imageHeightMap.getXsize(), 2);
        imageHeightMap3.extendHeightMap(0, 0, 1, 1);
        n = 10;
        int n3 = 20;
        imageHeightMap3.extendHeightMap(0, 0, n, (int)((float)n3 * 0.5f), 0);
        this.driveAreaBeginYIndex = 1 + n;
        this.forceWidth = 58.0f;
        this.makeJaggedWallEdge(imageHeightMap3, 500);
        this.xsize = imageHeightMap3.getXsize();
        this.ysize = imageHeightMap3.getYsize();
        if (this.mesh != null) {
            this.detachChild(this.mesh);
        }
        this.buildVertices(imageHeightMap3);
        this.attachChild(this.mesh);
        this.actualWidth = this.forceWidth;
        this.actualLength = (float)this.xsize * this.stepScale.x;
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        this.updateWorldBound();
        this.updateWorldData(0.0f);
        this.lock();
    }

    public float getFinishPosition() {
        return this.actualLength - (float)(this.extendX * 60) * this.stepScale.x + 1.0f;
    }

    protected void makeJaggedWallEdge(ImageHeightMap imageHeightMap, int n) {
        int[] nArray = imageHeightMap.getHeightMap();
        int n2 = imageHeightMap.getXsize();
        Random random = new Random(n2);
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray[i] = n3 = (int)(random.nextDouble() * (double)n * (double)this.stepScale.y);
        }
    }

    protected void buildVertices(ImageHeightMap imageHeightMap) {
        if (this.mesh == null) {
            this.mesh = new TriMesh(this.getName() + ":mesh");
        }
        if (this.boostArrowNode == null) {
            this.boostArrowNode = new Node(this.getName() + ":boostArrowNode");
        } else {
            this.boostArrowNode.detachAllChildren();
        }
        int n = (int)(this.batchLength / this.stepScale.x);
        if (n % 2 != 0) {
            ++n;
        }
        int[] nArray = imageHeightMap.getHeightMap();
        Vector3f vector3f = new Vector3f();
        int n2 = 0;
        this.forceWidthAdder = 0.0f;
        if (this.forceWidth > 0.0f) {
            this.forceWidthAdder = this.forceWidth - (float)this.ysize * this.stepScale.z;
        }
        this.offset.x += (float)((int)((float)this.offsetAmount * this.stepScale.x));
        this.offset.y += (float)((int)((float)this.offsetAmount * this.stepScale.z));
        float f = this.textureScale.x;
        float f2 = this.textureScale.y;
        if (this.forceTextureRepeatAlongWidth > 0.0f) {
            f2 = (float)this.ysize / this.forceTextureRepeatAlongWidth;
        }
        for (int i = 0; i < this.xsize / n + 1; ++i) {
            int n3;
            TriangleBatch triangleBatch;
            if (i >= this.mesh.getBatchCount()) {
                triangleBatch = new TriangleBatch();
                this.mesh.addBatch(triangleBatch);
            } else {
                triangleBatch = this.mesh.getBatch(i);
            }
            if (i == 0) {
                triangleBatch.setVertexCount((n + 2) * this.ysize);
            } else if (i + 1 < this.xsize / n + 1) {
                triangleBatch.setVertexCount((n + 3) * this.ysize);
            } else {
                triangleBatch.setVertexCount((this.xsize % n + 1) * this.ysize);
            }
            triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
            FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
            floatBuffer.clear();
            FloatBuffer floatBuffer2 = BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount());
            triangleBatch.getTextureBuffers().set(0, floatBuffer2);
            floatBuffer2.clear();
            int n4 = 0;
            for (n3 = i * n - 1; n3 < (i + 1) * n + 2; ++n3) {
                int n5;
                if (n3 < 0) continue;
                if (n3 >= this.xsize) break;
                for (n5 = 0; n5 < this.ysize; ++n5) {
                    n2 = n5 * this.xsize;
                    if (n5 > this.driveAreaBeginYIndex) {
                        if (n5 == this.ysize - 1) {
                            vector3f.set((float)n3 * this.stepScale.x, (float)nArray[n3 + n2] * this.stepScale.y, (float)n5 * this.stepScale.z + this.forceWidthAdder + this.lastRowAdder);
                        } else {
                            vector3f.set((float)n3 * this.stepScale.x, (float)nArray[n3 + n2] * this.stepScale.y, (float)n5 * this.stepScale.z + this.forceWidthAdder);
                        }
                    } else {
                        vector3f.set((float)n3 * this.stepScale.x, (float)nArray[n3 + n2] * this.stepScale.y, (float)n5 * this.stepScale.z);
                    }
                    floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
                    floatBuffer2.put((vector3f.x + this.offset.x) / (f * 20.0f));
                    floatBuffer2.put((vector3f.z + this.offset.y) / f2);
                    ++n4;
                }
                if (n3 < i * n + 2) continue;
                n5 = 0;
                if (n3 < this.featureMap.getXsize()) {
                    n5 = this.featureMap.getTrueHeightAtPoint(n3, 0);
                }
                if (n5 != 255) continue;
                this.boostArrowNode.attachChild(this.makeBoostArrow(this.collisionHeightMap, n3, this.stepScale, this.forceWidthAdder));
            }
            floatBuffer.flip();
            floatBuffer2.flip();
            triangleBatch.setVertexCount(floatBuffer.limit() / 3);
            n3 = floatBuffer.limit() / (3 * this.ysize);
            if (i == 0) {
                n4 = 0;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n3 - 2) * 2);
            } else {
                n4 = this.ysize;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n3 - 3) * 2);
            }
            if (triangleBatch.getTriangleCount() * 3 < 0) {
                this.mesh.removeBatch(triangleBatch);
                break;
            }
            triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), triangleBatch.getTriangleCount() * 3));
            IntBuffer intBuffer = triangleBatch.getIndexBuffer();
            while (n4 < this.ysize * (n3 - 2)) {
                if ((n4 + 1) % this.ysize != 0) {
                    intBuffer.put(n4);
                    intBuffer.put(n4 + 1 + this.ysize);
                    intBuffer.put(n4 + this.ysize);
                    intBuffer.put(n4);
                    intBuffer.put(n4 + 1);
                    intBuffer.put(n4 + 1 + this.ysize);
                }
                ++n4;
            }
            intBuffer.flip();
            FloatBuffer floatBuffer3 = BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount());
            this.buildNormals(triangleBatch.getVertexBuffer(), floatBuffer3, n3);
            triangleBatch.setNormalBuffer(floatBuffer3);
            triangleBatch.setModelBound(new BoundingBox());
            triangleBatch.updateModelBound();
        }
    }

    protected TriMesh makeBoostArrow(ImageHeightMap imageHeightMap, int n, Vector3f vector3f, float f) {
        System.out.println("Making boost arrow");
        float f2 = vector3f.z * 11.0f;
        float f3 = 4.0f;
        float f4 = 10.0f;
        float f5 = f / 4.0f - f3;
        float f6 = 0.01f;
        if (f5 <= 0.001f) {
            f5 = 0.5f;
        }
        int n2 = (int)(f4 / vector3f.x + 1.0f);
        int n3 = n2 * 2 * 4;
        int n4 = n3 - 8;
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(n3);
        FloatBuffer floatBuffer2 = BufferUtils.createVector2Buffer(n3);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n4 * 3);
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int n5 = 0;
        for (int i = n; i < n + n2; ++i) {
            float f7 = f2;
            for (float f8 = 0.0f; f8 < 4.0f; f8 += 1.0f) {
                vector3f2.set((float)(i - n) * vector3f.x, (float)imageHeightMap.getTrueHeightAtPoint(i, 0) * vector3f.y + f6, f7 += f3 / 2.0f);
                vector3f3.set((float)(i - n) * vector3f.x, (float)imageHeightMap.getTrueHeightAtPoint(i, 0) * vector3f.y + f6, f7 += f5);
                f7 += f3 / 2.0f;
                BufferUtils.setInBuffer(vector3f2, floatBuffer, n5);
                BufferUtils.setInBuffer(vector3f3, floatBuffer, n5 + 1);
                if (i > n) {
                    int n6 = n5 - 8;
                    intBuffer.put(n5 + 1).put(n5).put(n6 + 1);
                    intBuffer.put(n6).put(n6 + 1).put(n5);
                }
                float f9 = (float)(i - n) / (float)n2;
                floatBuffer2.put(f9).put(0.0f);
                floatBuffer2.put(f9).put(1.0f);
                n5 += 2;
            }
        }
        TriMesh triMesh = new TriMesh("boostArrowMesh");
        triMesh.setLocalTranslation((float)n * vector3f.x, 0.0f, 0.0f);
        TriangleBatch triangleBatch = triMesh.getBatch(0);
        triangleBatch.setVertexBuffer(floatBuffer);
        triangleBatch.setIndexBuffer(intBuffer);
        triangleBatch.setTextureBuffer(floatBuffer2, 0);
        this.computeNormals(triangleBatch);
        triangleBatch.setModelBound(new BoundingBox());
        triangleBatch.updateModelBound();
        try {
            Texture texture = (Texture)ResourceManager.getInstance().load("texture", "frontwheel", null);
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setTexture(texture);
            triangleBatch.setRenderState(textureState);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return triMesh;
    }

    protected void buildTextureCoordinates(TriangleBatch triangleBatch) {
        this.offset.x += (float)((int)((float)this.offsetAmount * this.stepScale.x));
        this.offset.y += (float)((int)((float)this.offsetAmount * this.stepScale.z));
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount());
        triangleBatch.getTextureBuffers().set(0, floatBuffer);
        floatBuffer.clear();
        float f = this.textureScale.x;
        float f2 = this.textureScale.y;
        if (this.forceTextureRepeatAlongWidth > 0.0f) {
            f2 = (float)this.ysize / this.forceTextureRepeatAlongWidth;
        }
        triangleBatch.getVertexBuffer().rewind();
        for (int i = 0; i < triangleBatch.getVertexCount(); ++i) {
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.x) / (this.stepScale.x * f));
            triangleBatch.getVertexBuffer().get();
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.y) / ((this.stepScale.z + this.forceWidthAdder) * f2));
        }
    }

    protected void buildNormals(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n) {
        floatBuffer.rewind();
        floatBuffer2.rewind();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.ysize; ++j) {
                if (j == this.ysize / 2 || j == this.ysize / 2 + 1) {
                    // empty if block
                }
                if (j == this.ysize - 1) {
                    if (i == n - 1) {
                        n2 = n4 - this.ysize;
                        n3 = n4 - 1;
                    } else {
                        n2 = n4 - 1;
                        n3 = n4 + this.ysize;
                    }
                } else if (i == n - 1) {
                    n3 = n4 - 1;
                    n2 = n4 - this.ysize;
                } else {
                    n2 = n4 + this.ysize;
                    n3 = n4 + 1;
                }
                BufferUtils.populateFromBuffer(vector3f3, floatBuffer, n4);
                BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n2);
                BufferUtils.populateFromBuffer(vector3f, floatBuffer, n3);
                vector3f4.set(vector3f2).subtractLocal(vector3f3).crossLocal(vector3f.subtractLocal(vector3f3)).multLocal(-1.0f).normalizeLocal();
                BufferUtils.setInBuffer(vector3f4, floatBuffer2, n4);
                ++n4;
            }
        }
        floatBuffer2.position(n4 * 3);
        floatBuffer2.flip();
    }

    public Track1D(String string, ImageHeightMap imageHeightMap) {
        super(string, imageHeightMap);
    }

    public CollisionStructure constructCollisionStructure() {
        return null;
    }

    public CollisionStructure reconstructCollisionStructure() {
        return this.reconstructCollisionStructure(this.collisionStructure);
    }

    public CollisionStructure reconstructCollisionStructure(CollisionStructure collisionStructure) {
        return null;
    }

    public double getHeightAt(int n) {
        if (n >= this.getXsize()) {
            return 0.0;
        }
        return (float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y;
    }

    public double getInterpolatedHeightAt(double d) {
        if (d + (double)this.stepScale.x >= (double)this.actualLength) {
            return 0.0;
        }
        int n = this.getColumn(d);
        int n2 = n + 1;
        if (n < 0 || n2 > this.xsize) {
            return 0.0;
        }
        double d2 = (d - (double)((float)n * this.stepScale.x)) / (double)this.stepScale.x;
        double d3 = (float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y;
        double d4 = (float)this.collisionHeightMap.getTrueHeightAtPoint(n2, 0) * this.stepScale.y;
        return d3 + (d4 - d3) * d2;
    }

    public int getColumn(double d) {
        return (int)(d / (double)this.stepScale.x);
    }

    public double getXPosition(int n) {
        return this.stepScale.x * (float)n;
    }

    public ImageHeightMap getOriginalHeightMap() {
        return this.originalHeightMap;
    }

    public int getOriginalHeightMapStartsAt() {
        return this.originalHeightMapStartsAt;
    }

    public ImageHeightMap getOriginalFeatureMap() {
        return this.originalFeatureMap;
    }

    public int getHeightMapNumberOfColumns() {
        return this.collisionHeightMap.getXsize();
    }

    public Vector3d findGoodResetSpot(double d, double d2, double d3, Vector3d vector3d) {
        int n = (int)(d / (double)this.stepScale.x);
        if (n < 0) {
            n = 0;
        }
        if (vector3d == null) {
            vector3d = new Vector3d();
        }
        int n2 = -1;
        int n3 = (int)(d2 / (double)this.stepScale.x) + 1;
        int n4 = 0;
        double d4 = d3 / (double)n3;
        double d5 = n < this.collisionHeightMap.getXsize() ? (double)((float)this.collisionHeightMap.getTrueHeightAtPoint(n, 0) * this.stepScale.y) : 0.0;
        double d6 = -1000000.0;
        for (int i = n + 1; i < this.collisionHeightMap.getXsize(); ++i) {
            double d7 = (float)this.collisionHeightMap.getTrueHeightAtPoint(i, 0) * this.stepScale.y;
            double d8 = Math.abs(d7 - d5);
            if (d8 > d4) {
                n4 = 0;
                d6 = -1000000.0;
            } else {
                ++n4;
                if (this.getHeightAt(i) > d6) {
                    d6 = this.getHeightAt(i);
                }
                if (n4 >= n3) {
                    n2 = i;
                    break;
                }
            }
            d5 = d7;
        }
        if (n2 == -1) {
            n2 = n;
        }
        vector3d.x = (float)n2 * this.stepScale.x;
        vector3d.y = d6;
        return vector3d;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.stepScale);
        objectOutput.writeObject(this.offset);
        objectOutput.writeInt(this.offsetAmount);
        objectOutput.writeObject(this.textureScale);
        objectOutput.writeObject(this.originalHeightMap);
        objectOutput.writeObject(this.originalFeatureMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.stepScale = (Vector3f)objectInput.readObject();
        this.offset = (Vector2f)objectInput.readObject();
        this.offsetAmount = objectInput.readInt();
        this.textureScale = (Vector2f)objectInput.readObject();
        this.reconstruct((ImageHeightMap)objectInput.readObject(), (ImageHeightMap)objectInput.readObject());
    }

    public ImageHeightMap getCollisionHeightMap() {
        return this.collisionHeightMap;
    }
}

