/*
 * Decompiled with CFR 0.152.
 */
package com.tobbes.xbike.track;

import com.jme.bounding.BoundingBox;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import com.tobbes.terrain.ImageHeightMap;
import com.turborilla.msm.physics.collision.CollisionGrid;
import com.turborilla.msm.track.Fence;
import com.turborilla.msm.track.RandomBannerFence;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.collision.IntersectionResult;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Track
extends Node {
    private static final long serialVersionUID = 2511410697885464597L;
    protected Vector3f stepScale;
    protected int xsize;
    protected int ysize;
    protected Vector2f offset;
    protected Vector2f textureScale;
    protected int offsetAmount;
    protected float forceWidth = 58.0f;
    protected float forceWidthScaler = 1.2f;
    protected float forceTextureRepeatAlongWidth = 1.0f;
    protected float batchLength = 60.0f;
    protected Fence fence;
    protected TriMesh mesh;
    protected Node otherMeshes = new Node(this.getName() + ":otherMeshes");
    protected Node boostArrowNode;
    protected float actualWidth = 0.0f;
    protected float actualLength = 0.0f;
    protected Node notShadowedNode = new Node(this.getName() + ":notShadowed");

    protected Track(String string) {
        super(string);
    }

    public Track(String string, ImageHeightMap imageHeightMap, Vector3f vector3f, Vector2f vector2f, int n, Vector2f vector2f2) {
        this(string);
        this.stepScale = vector3f;
        this.offset = vector2f;
        this.offsetAmount = n;
        this.textureScale = vector2f2;
        int n2 = (int)(2.5f / vector3f.z);
        int n3 = (int)(2.5f / vector3f.x);
        imageHeightMap.extendHeightMap(n3, n3, n2, n2, 0);
        imageHeightMap.extendHeightMap(n3 * 6, n3 * 60, 0, 0, 0);
        this.xsize = imageHeightMap.getXsize();
        this.ysize = imageHeightMap.getYsize();
        this.buildVertices(imageHeightMap);
        this.actualWidth = this.forceWidth;
        this.actualLength = (float)this.xsize * vector3f.x;
        try {
            this.fence = new RandomBannerFence(new Vector3f(), (float)this.xsize * vector3f.x, 3.0f);
            this.notShadowedNode.attachChild(this.fence);
        }
        catch (IOException iOException) {
            this.fence = null;
        }
        this.attachChild(this.mesh);
    }

    public Track(String string, ImageHeightMap imageHeightMap) {
        this(string, imageHeightMap, new Vector3f(1.3f, 0.02f, 1.0f), new Vector2f(), 0, new Vector2f(10.0f, 10.0f));
    }

    protected void buildVertices(ImageHeightMap imageHeightMap) {
        this.mesh = new TriMesh(this.getName() + ":mesh");
        this.mesh.clearBatches();
        int n = (int)(this.batchLength / this.stepScale.x);
        if (n % 2 != 0) {
            ++n;
        }
        int[] nArray = imageHeightMap.getHeightMap();
        Vector3f vector3f = new Vector3f();
        int n2 = 0;
        this.forceWidthScaler = 1.0f;
        if (this.forceWidth > 0.0f) {
            this.forceWidthScaler = this.forceWidth / ((float)this.ysize * this.stepScale.z);
        }
        for (int i = 0; i < this.xsize / n + 1; ++i) {
            int n3;
            TriangleBatch triangleBatch = new TriangleBatch();
            if (i == 0) {
                triangleBatch.setVertexCount((n + 2) * this.ysize);
            } else if (i + 1 < this.xsize / n + 1) {
                triangleBatch.setVertexCount((n + 3) * this.ysize);
            } else {
                triangleBatch.setVertexCount((this.xsize % n + 1) * this.ysize);
            }
            triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
            FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
            floatBuffer.rewind();
            int n4 = 0;
            for (n3 = i * n - 1; n3 < (i + 1) * n + 2; ++n3) {
                if (n3 < 0) continue;
                if (n3 >= this.xsize) break;
                for (int j = 0; j < this.ysize; ++j) {
                    n2 = j * this.xsize;
                    vector3f.set((float)n3 * this.stepScale.x, (float)nArray[n3 + n2] * this.stepScale.y, (float)j * this.stepScale.z * this.forceWidthScaler);
                    floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
                    ++n4;
                }
            }
            floatBuffer.flip();
            System.out.println(triangleBatch.getVertexCount());
            System.out.println(floatBuffer.limit() / 3);
            triangleBatch.setVertexCount(floatBuffer.limit() / 3);
            n3 = floatBuffer.limit() / (3 * this.ysize);
            if (i == 0) {
                n4 = 0;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n3 - 2) * 2);
            } else {
                n4 = this.ysize;
                triangleBatch.setTriangleQuantity((this.ysize - 1) * (n3 - 3) * 2);
            }
            triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getTriangleCount() * 3));
            IntBuffer intBuffer = triangleBatch.getIndexBuffer();
            while (n4 < this.ysize * (n3 - 2)) {
                if ((n4 + 1) % this.ysize != 0) {
                    intBuffer.put(n4);
                    intBuffer.put(n4 + 1 + this.ysize);
                    intBuffer.put(n4 + this.ysize);
                    intBuffer.put(n4);
                    intBuffer.put(n4 + 1);
                    intBuffer.put(n4 + 1 + this.ysize);
                }
                ++n4;
            }
            intBuffer.flip();
            System.out.println(triangleBatch.getTriangleCount());
            System.out.println(intBuffer.limit() / 3);
            this.buildTextureCoordinates(triangleBatch);
            FloatBuffer floatBuffer2 = BufferUtils.createVector3Buffer(triangleBatch.getVertexCount());
            this.buildNormals(triangleBatch.getVertexBuffer(), floatBuffer2, n3);
            System.out.println(triangleBatch.getVertexCount());
            System.out.println(floatBuffer2.limit() / 3);
            triangleBatch.setNormalBuffer(floatBuffer2);
            this.mesh.addBatch(triangleBatch);
            triangleBatch.setModelBound(new BoundingBox());
            triangleBatch.updateModelBound();
        }
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        this.updateWorldBound();
        this.setLocks(0);
    }

    protected void buildTextureCoordinates(TriangleBatch triangleBatch) {
        this.offset.x += (float)((int)((float)this.offsetAmount * this.stepScale.x));
        this.offset.y += (float)((int)((float)this.offsetAmount * this.stepScale.z));
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(triangleBatch.getTextureBuffers().get(0), triangleBatch.getVertexCount());
        triangleBatch.getTextureBuffers().set(0, floatBuffer);
        floatBuffer.clear();
        float f = this.textureScale.x;
        float f2 = this.textureScale.y;
        if (this.forceTextureRepeatAlongWidth > 0.0f) {
            f2 = (float)this.ysize / this.forceTextureRepeatAlongWidth;
        }
        triangleBatch.getVertexBuffer().rewind();
        for (int i = 0; i < triangleBatch.getVertexCount(); ++i) {
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.x) / (this.stepScale.x * f));
            triangleBatch.getVertexBuffer().get();
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + this.offset.y) / (this.stepScale.z * this.forceWidthScaler * f2));
        }
    }

    protected void computeNormals(TriangleBatch triangleBatch) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        IntBuffer intBuffer = triangleBatch.getIndexBuffer();
        int n = triangleBatch.getTriangleCount();
        int n2 = triangleBatch.getVertexCount();
        Vector3f[] vector3fArray = new Vector3f[n];
        Vector3f[] vector3fArray2 = new Vector3f[n2];
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(vector3f, floatBuffer, intBuffer.get(i * 3));
            BufferUtils.populateFromBuffer(vector3f2, floatBuffer, intBuffer.get(i * 3 + 1));
            BufferUtils.populateFromBuffer(vector3f3, floatBuffer, intBuffer.get(i * 3 + 2));
            vector3f.subtractLocal(vector3f3);
            vector3fArray[i] = vector3f.cross(vector3f3.subtract(vector3f2)).normalizeLocal();
        }
        Vector3f vector3f4 = new Vector3f();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (intBuffer.get(j * 3) != i && intBuffer.get(j * 3 + 1) != i && intBuffer.get(j * 3 + 2) != i) continue;
                vector3f4.addLocal(vector3fArray[j]);
                ++n3;
            }
            vector3fArray2[i] = vector3f4.divide(-n3).normalizeLocal();
            vector3f4.zero();
            n3 = 0;
        }
        triangleBatch.setNormalBuffer(BufferUtils.createFloatBuffer(vector3fArray2));
    }

    protected void buildNormals(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n) {
        floatBuffer.rewind();
        floatBuffer2.rewind();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.ysize; ++j) {
                if (j == this.ysize - 1) {
                    if (i == n - 1) {
                        n2 = n4 - this.ysize;
                        n3 = n4 - 1;
                    } else {
                        n2 = n4 - 1;
                        n3 = n4 + this.ysize;
                    }
                } else if (i == n - 1) {
                    n3 = n4 - 1;
                    n2 = n4 - this.ysize;
                } else {
                    n2 = n4 + this.ysize;
                    n3 = n4 + 1;
                }
                BufferUtils.populateFromBuffer(vector3f3, floatBuffer, n4);
                BufferUtils.populateFromBuffer(vector3f2, floatBuffer, n2);
                BufferUtils.populateFromBuffer(vector3f, floatBuffer, n3);
                vector3f4.set(vector3f2).subtractLocal(vector3f3).crossLocal(vector3f.subtractLocal(vector3f3)).multLocal(-1.0f).normalizeLocal();
                BufferUtils.setInBuffer(vector3f4, floatBuffer2, n4);
                ++n4;
            }
        }
        floatBuffer2.position(n4 * 3);
        floatBuffer2.flip();
    }

    public void selfShadow(CollisionGrid collisionGrid, Vector3f vector3f) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3f vector3f2 = new Vector3f();
        Vector3d vector3d3 = new Vector3d(vector3f.mult(-0.01f));
        Vector3d vector3d4 = new Vector3d(vector3f.mult(-100.0f));
        Vector3f vector3f3 = new Vector3f(0.0f, -1.0f, 0.0f);
        IntersectionResult intersectionResult = new IntersectionResult();
        int n = 0;
        for (int i = 0; i < this.mesh.getBatchCount(); ++i) {
            TriangleBatch triangleBatch = this.mesh.getBatch(i);
            if (triangleBatch == null) continue;
            int n2 = triangleBatch.getVertexCount();
            FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
            FloatBuffer floatBuffer2 = triangleBatch.getNormalBuffer();
            for (int j = 0; j < n2; ++j) {
                BufferUtils.populateFromBuffer(vector3f2, floatBuffer, j);
                vector3d.set(vector3f2);
                vector3d.addLocal(vector3d3);
                vector3d2.set(vector3d).addLocal(vector3d4);
                if (!collisionGrid.intersectSegmentLongRay(vector3d2, vector3d, intersectionResult)) continue;
                BufferUtils.setInBuffer(vector3f3, floatBuffer2, j);
                ++n;
            }
            triangleBatch.setNormalBuffer(floatBuffer2);
        }
        System.out.println("shadowed: " + n);
    }

    public CollisionStructure constructCollisionStructure() {
        return new CollisionGrid(this.getMesh(), this.getYsize() / 2, this.getXsize() / 2);
    }

    public TriMesh getMesh() {
        return this.mesh;
    }

    public Node getNotShadowedNode() {
        return this.notShadowedNode;
    }

    public void setNotShadowedNode(Node node) {
        this.notShadowedNode = node;
    }

    public int getXsize() {
        return this.xsize;
    }

    public int getYsize() {
        return this.ysize;
    }

    public float getActualLength() {
        return this.actualLength;
    }

    public float getActualWidth() {
        return this.actualWidth;
    }

    public float getBatchLength() {
        return this.batchLength;
    }

    public Node getOtherMeshes() {
        return this.otherMeshes;
    }

    public Node getBoostArrowNode() {
        return this.boostArrowNode;
    }

    public Vector3f getStepScale() {
        return this.stepScale;
    }
}

