/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaCalendarBase;
import com.jmex.xml.types.SchemaDate;
import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaString;
import com.jmex.xml.types.SchemaTime;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeCalendar;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.util.Calendar;

public class SchemaDateTime
extends SchemaCalendarBase {
    public SchemaDateTime() {
        this.setEmpty();
    }

    public SchemaDateTime(SchemaDateTime schemaDateTime) {
        this.year = schemaDateTime.year;
        this.month = schemaDateTime.month;
        this.day = schemaDateTime.day;
        this.hour = schemaDateTime.hour;
        this.minute = schemaDateTime.minute;
        this.second = schemaDateTime.second;
        this.partsecond = schemaDateTime.partsecond;
        this.hasTZ = schemaDateTime.hasTZ;
        this.offsetTZ = schemaDateTime.offsetTZ;
        this.isempty = schemaDateTime.isempty;
    }

    public SchemaDateTime(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7) {
        this.setInternalValues(n, n2, n3, n4, n5, n6, d, 2, n7);
        this.isempty = false;
    }

    public SchemaDateTime(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.setInternalValues(n, n2, n3, n4, n5, n6, d, 0, 0);
        this.isempty = false;
    }

    public SchemaDateTime(Calendar calendar) {
        this.setValue(calendar);
    }

    public SchemaDateTime(String string) {
        this.parse(string);
    }

    public SchemaDateTime(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDateTime(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public double getPartSecond() {
        return this.partsecond;
    }

    public int getMillisecond() {
        return (int)Math.round(this.partsecond * 1000.0);
    }

    public int hasTimezone() {
        return this.hasTZ;
    }

    public int getTimezoneOffset() {
        if (this.hasTZ != 2) {
            return 0;
        }
        return this.offsetTZ;
    }

    public Calendar getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        calendar.set(14, this.getMillisecond());
        this.hasTZ = 2;
        calendar.set(15, this.offsetTZ * 60000);
        return calendar;
    }

    public void setYear(int n) {
        this.year = n;
        this.isempty = false;
    }

    public void setMonth(int n) {
        this.month = n;
        this.isempty = false;
    }

    public void setDay(int n) {
        this.day = n;
        this.isempty = false;
    }

    public void setHour(int n) {
        this.hour = n;
        this.isempty = false;
    }

    public void setMinute(int n) {
        this.minute = n;
        this.isempty = false;
    }

    public void setSecond(int n) {
        this.second = n;
        this.isempty = false;
    }

    public void setPartSecond(double d) {
        this.partsecond = d;
        this.isempty = false;
    }

    public void setMillisecond(int n) {
        this.partsecond = (double)n / 1000.0;
        this.isempty = false;
    }

    public void setTimezone(int n, int n2) {
        this.hasTZ = n;
        this.offsetTZ = n2;
        this.isempty = false;
    }

    public void setValue(Calendar calendar) {
        if (calendar == null) {
            this.setEmpty();
            return;
        }
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.setMillisecond(calendar.get(14));
        this.hasTZ = 0;
        this.isempty = false;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null || string2.length() == 0) {
            this.setEmpty();
        } else if (!this.parseDateTime(string2, 15)) {
            throw new StringParseException(string2 + " cannot be converted to a dateTime value", 0);
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull() || schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaDateTime) {
            this.setInternalValues(((SchemaDateTime)schemaType).year, ((SchemaDateTime)schemaType).month, ((SchemaDateTime)schemaType).day, ((SchemaDateTime)schemaType).hour, ((SchemaDateTime)schemaType).minute, ((SchemaDateTime)schemaType).second, ((SchemaDateTime)schemaType).partsecond, ((SchemaDateTime)schemaType).hasTZ, ((SchemaDateTime)schemaType).offsetTZ);
            this.isempty = false;
        } else if (schemaType instanceof SchemaDate) {
            this.setInternalValues(((SchemaDate)schemaType).year, ((SchemaDate)schemaType).month, ((SchemaDate)schemaType).day, 0, 0, 0, 0.0, 0, 0);
            this.isempty = false;
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public Object clone() {
        return new SchemaDateTime(this);
    }

    public String toString() {
        if (this.isempty) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toDateString());
        stringBuffer.append("T");
        stringBuffer.append(this.toTimeString());
        return stringBuffer.toString();
    }

    public static SchemaDateTime now() {
        return new SchemaDateTime(Calendar.getInstance());
    }

    public int calendarType() {
        return 1;
    }

    public SchemaDateTime dateTimeValue() {
        return new SchemaDateTime(this);
    }

    public SchemaDate dateValue() {
        return new SchemaDate(this);
    }

    public SchemaTime timeValue() {
        return new SchemaTime(this);
    }
}

