/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.math.FastMath;
import com.jme.system.JmeException;
import com.jme.util.LittleEndien;
import com.jmex.terrain.util.AbstractHeightMap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;

public class RawHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(RawHeightMap.class.getName());
    public static final int FORMAT_8BIT = 0;
    public static final int FORMAT_16BITLE = 1;
    public static final int FORMAT_16BITBE = 2;
    private int format;
    private boolean swapxy;
    private InputStream stream;

    public RawHeightMap(String string, int n) {
        this(string, n, 0, false);
    }

    public RawHeightMap(int[] nArray) {
        this.heightData = nArray;
        this.size = (int)FastMath.sqrt(nArray.length);
        this.format = 0;
    }

    public RawHeightMap(String string, int n, int n2, boolean bl) {
        if (null == string || n <= 0) {
            throw new JmeException("Must supply valid filename and size (> 0)");
        }
        try {
            this.setup(new FileInputStream(string), n, n2, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JmeException("height file not found: " + string);
        }
    }

    public RawHeightMap(InputStream inputStream, int n, int n2, boolean bl) {
        this.setup(inputStream, n, n2, bl);
    }

    public RawHeightMap(URL uRL, int n, int n2, boolean bl) {
        if (null == uRL || n <= 0) {
            throw new JmeException("Must supply valid resource and size (> 0)");
        }
        try {
            this.setup(uRL.openStream(), n, n2, bl);
        }
        catch (IOException iOException) {
            throw new JmeException("Unable to open height url: " + uRL);
        }
    }

    private void setup(InputStream inputStream, int n, int n2, boolean bl) {
        if (null == inputStream || n <= 0) {
            throw new JmeException("Must supply valid stream and size (> 0)");
        }
        this.stream = inputStream;
        this.size = n;
        this.format = n2;
        this.swapxy = bl;
        this.load();
    }

    public boolean load() {
        if (null == this.stream || this.size <= 0) {
            throw new JmeException("Must supply valid stream and size (> 0)");
        }
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.stream);
            if (this.format == 1) {
                LittleEndien littleEndien = new LittleEndien(bufferedInputStream);
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int n = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[n] = littleEndien.readUnsignedShort();
                    }
                }
                littleEndien.close();
            } else {
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        int n = this.swapxy ? i + j * this.size : i * this.size + j;
                        this.heightData[n] = this.format == 2 ? dataInputStream.readUnsignedShort() : dataInputStream.readUnsignedByte();
                    }
                }
                dataInputStream.close();
            }
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            logger.warning("Error reading height data from stream.");
            return false;
        }
        return true;
    }

    public void setFilename(String string) {
        if (null == string) {
            throw new JmeException("Must supply valid filename.");
        }
        try {
            this.stream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JmeException("height file not found: " + string);
        }
    }

    public void setHeightStream(InputStream inputStream) {
        if (null == inputStream) {
            throw new JmeException("Must supply valid stream.");
        }
        this.stream = inputStream;
    }
}

