/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.subdivision;

import java.nio.FloatBuffer;

public class Vector {
    public float[] elem;
    public int size;

    public Vector(int n) {
        this.elem = new float[n];
        this.size = n;
        for (int i = 0; i < n; ++i) {
            this.elem[i] = 0.0f;
        }
    }

    public Vector addLocal(Vector vector) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.elem[n] = this.elem[n] + vector.elem[i];
        }
        return this;
    }

    public Vector multLocal(float f) {
        int n = 0;
        while (n < this.size) {
            int n2 = n++;
            this.elem[n2] = this.elem[n2] * f;
        }
        return this;
    }

    public Vector interpolate(Vector vector, Vector vector2, float f) {
        for (int i = 0; i < this.size; ++i) {
            this.elem[i] = vector.elem[i] * (1.0f - f) + vector2.elem[i] * f;
        }
        return this;
    }

    public Vector interpolate(Vector vector, Vector vector2) {
        for (int i = 0; i < this.size; ++i) {
            this.elem[i] = (vector.elem[i] + vector2.elem[i]) * 0.5f;
        }
        return this;
    }

    public Vector populateFromBuffer(FloatBuffer floatBuffer, int n) {
        for (int i = 0; i < this.size; ++i) {
            this.elem[i] = floatBuffer.get(n * this.size + i);
        }
        return this;
    }

    public FloatBuffer putInBuffer(FloatBuffer floatBuffer, int n) {
        for (int i = 0; i < this.size; ++i) {
            floatBuffer.put(n * this.size + i, this.elem[i]);
        }
        return floatBuffer;
    }
}

