/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.subdivision;

import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class Subdivision {
    private static final Logger logger = Logger.getLogger(Subdivision.class.getName());
    protected FloatBuffer vertexBuffer = null;
    protected FloatBuffer newVertexBuffer = null;
    protected IntBuffer indexBuffer = null;
    protected IntBuffer newIndexBuffer = null;
    protected ArrayList<SubdivisionBuffer> buffers = new ArrayList();
    protected ArrayList<SubdivisionBuffer> newBuffers = new ArrayList();
    private TriangleBatch batch = null;
    private boolean prepared = false;

    public Subdivision() {
    }

    public Subdivision(FloatBuffer floatBuffer, IntBuffer intBuffer) {
        this();
        this.vertexBuffer = floatBuffer;
        this.indexBuffer = intBuffer;
    }

    public Subdivision(TriangleBatch triangleBatch) {
        this();
        this.setBatch(triangleBatch);
    }

    public abstract boolean prepare();

    protected abstract boolean doSubdivide();

    public void setBatch(TriangleBatch triangleBatch) {
        this.batch = triangleBatch;
        this.clearBufferList();
        this.setVertexBuffer(triangleBatch.getVertexBuffer());
        this.setIndexBuffer(triangleBatch.getIndexBuffer());
        if (triangleBatch.getColorBuffer() != null) {
            this.addToBufferList(triangleBatch.getColorBuffer(), BufferType.COLORBUFFER);
        }
        ArrayList<FloatBuffer> arrayList = triangleBatch.getTextureBuffers();
        for (FloatBuffer floatBuffer : arrayList) {
            if (floatBuffer == null) continue;
            this.addToBufferList(floatBuffer, BufferType.TEXTUREBUFFER);
        }
    }

    public boolean subdivide() {
        if (this.getVertexBuffer() == null) {
            logger.warning("No vertex buffer is set, aborting.");
            return false;
        }
        if (this.getIndexBuffer() == null) {
            logger.warning("No index buffer is set, aborting.");
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        if (!this.prepared && !(this.prepared = this.prepare())) {
            logger.warning("Could not prepare for subdivision, aborting.");
            return false;
        }
        if (this.doSubdivide()) {
            if (this.newVertexBuffer != null || this.newIndexBuffer != null) {
                this.setVertexBuffer(this.newVertexBuffer);
                this.newVertexBuffer = null;
                this.setIndexBuffer(this.newIndexBuffer);
                this.newIndexBuffer = null;
                this.buffers = this.newBuffers;
                this.newBuffers = null;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean apply() {
        return this.apply(this.batch);
    }

    public boolean apply(TriangleBatch triangleBatch) {
        if (triangleBatch == null) {
            logger.warning("No batch is set to apply the buffers to, aborting.");
            return false;
        }
        if (this.vertexBuffer == null || this.indexBuffer == null) {
            logger.warning("No vertex or index buffer is set, aborting.");
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        int n = 0;
        SubdivisionBuffer subdivisionBuffer2 = null;
        triangleBatch.setVertexBuffer(this.vertexBuffer);
        triangleBatch.setIndexBuffer(this.indexBuffer);
        block5: for (SubdivisionBuffer subdivisionBuffer2 : this.buffers) {
            if (subdivisionBuffer2 == null) continue;
            switch (subdivisionBuffer2.type) {
                case COLORBUFFER: {
                    triangleBatch.setColorBuffer(subdivisionBuffer2.buf);
                    continue block5;
                }
                case TEXTUREBUFFER: {
                    triangleBatch.setTextureBuffer(subdivisionBuffer2.buf, n);
                    ++n;
                    continue block5;
                }
                case NORMALBUFFER: {
                    triangleBatch.setNormalBuffer(subdivisionBuffer2.buf);
                    continue block5;
                }
            }
            logger.warning("Unknown buffer type, not applying it.");
        }
        return true;
    }

    public void computeNormals() {
        this.computeNormals(this.batch);
    }

    public void computeNormals(TriangleBatch triangleBatch) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        IntBuffer intBuffer = triangleBatch.getIndexBuffer();
        int n = triangleBatch.getTriangleCount();
        int n2 = triangleBatch.getVertexCount();
        Vector3f[] vector3fArray = new Vector3f[n];
        Vector3f[] vector3fArray2 = new Vector3f[n2];
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(vector3f, floatBuffer, intBuffer.get(i * 3));
            BufferUtils.populateFromBuffer(vector3f2, floatBuffer, intBuffer.get(i * 3 + 1));
            BufferUtils.populateFromBuffer(vector3f3, floatBuffer, intBuffer.get(i * 3 + 2));
            vector3f.subtractLocal(vector3f3);
            vector3fArray[i] = vector3f.cross(vector3f3.subtract(vector3f2)).normalizeLocal();
        }
        Vector3f vector3f4 = new Vector3f();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (intBuffer.get(j * 3) != i && intBuffer.get(j * 3 + 1) != i && intBuffer.get(j * 3 + 2) != i) continue;
                vector3f4.addLocal(vector3fArray[j]);
                ++n3;
            }
            vector3fArray2[i] = vector3f4.divide(-n3).normalizeLocal();
            vector3f4.zero();
            n3 = 0;
        }
        triangleBatch.setNormalBuffer(BufferUtils.createFloatBuffer(vector3fArray2));
    }

    public void unsetBatch() {
        this.batch = null;
    }

    public void addToBufferList(FloatBuffer floatBuffer, int n, boolean bl, BufferType bufferType) {
        this.buffers.add(new SubdivisionBuffer(floatBuffer, n, bl, bufferType));
    }

    public void addToBufferList(FloatBuffer floatBuffer, BufferType bufferType) {
        this.buffers.add(new SubdivisionBuffer(floatBuffer, bufferType));
    }

    public void removeBuffer(FloatBuffer floatBuffer) {
        SubdivisionBuffer subdivisionBuffer = null;
        boolean bl = false;
        Iterator<SubdivisionBuffer> iterator = this.buffers.iterator();
        while (iterator.hasNext() && !bl) {
            subdivisionBuffer = iterator.next();
            if (subdivisionBuffer.buf != floatBuffer) continue;
            bl = true;
        }
        this.buffers.remove(subdivisionBuffer);
    }

    public void clearBufferList() {
        this.buffers = new ArrayList();
    }

    public boolean isValid() {
        boolean bl = true;
        String string = "";
        int n = this.vertexBuffer.capacity() / 3;
        for (int i = 0; i < this.buffers.size(); ++i) {
            SubdivisionBuffer subdivisionBuffer = this.buffers.get(i);
            if (subdivisionBuffer == null || subdivisionBuffer.buf.capacity() / subdivisionBuffer.elemSize == n) continue;
            bl = false;
            string = string + "SubdivisionBuffer at index " + i + " does not have as many elements as there are vertices in the vertex buffer.\n";
        }
        if (!bl) {
            logger.warning(string);
        }
        return bl;
    }

    public TriangleBatch getBatch() {
        return this.batch;
    }

    public IntBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    public void setIndexBuffer(IntBuffer intBuffer) {
        this.indexBuffer = intBuffer;
        this.prepared = false;
    }

    public FloatBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void setVertexBuffer(FloatBuffer floatBuffer) {
        this.vertexBuffer = floatBuffer;
        this.prepared = false;
    }

    public int getVertexCount() {
        if (this.vertexBuffer == null) {
            logger.warning("No vertex buffer set, aborting.");
            return 0;
        }
        return this.vertexBuffer.capacity() / 3;
    }

    protected class SubdivisionBuffer {
        public FloatBuffer buf;
        public int elemSize;
        public boolean linear;
        public BufferType type;

        public SubdivisionBuffer(FloatBuffer floatBuffer, int n, boolean bl, BufferType bufferType) {
            this.buf = floatBuffer;
            this.elemSize = n;
            this.linear = bl;
            this.type = bufferType;
        }

        public SubdivisionBuffer(FloatBuffer floatBuffer, BufferType bufferType) {
            this.buf = floatBuffer;
            switch (bufferType) {
                case COLORBUFFER: {
                    this.elemSize = 4;
                    this.linear = false;
                    break;
                }
                case TEXTUREBUFFER: {
                    this.elemSize = 2;
                    this.linear = true;
                    break;
                }
                case NORMALBUFFER: {
                    this.elemSize = 3;
                    this.linear = false;
                    break;
                }
                default: {
                    logger.warning("Unknown buffer type, guessing its elemSize and linearity");
                    this.elemSize = 3;
                    this.linear = false;
                }
            }
            this.type = bufferType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferType {
        COLORBUFFER,
        TEXTUREBUFFER,
        NORMALBUFFER,
        OTHER;

    }
}

