/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDResolver
implements EntityResolver {
    private Map<String, byte[]> dtdBytes = new HashMap<String, byte[]>();

    public DTDResolver(Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof byte[]) {
                this.dtdBytes.put(entry.getKey(), (byte[])obj);
                continue;
            }
            if (obj instanceof InputStream) {
                try {
                    byte[] byArray = this.getBytes((InputStream)obj);
                    this.dtdBytes.put(entry.getKey(), byArray);
                }
                catch (IOException iOException) {
                    System.err.println("Unable to get DTD bytes from stream for " + entry.getKey() + "!");
                }
                continue;
            }
            System.err.println("Invalid value in DTD map for key \"" + entry.getKey() + "\"; neither byte[] nor InputStream!");
        }
    }

    private byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream2;
        if (string2 == null) {
            return null;
        }
        byte[] byArray = this.dtdBytes.get(string2);
        if (byArray != null && (byteArrayInputStream2 = new ByteArrayInputStream(byArray)) != null) {
            return new InputSource(byteArrayInputStream2);
        }
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(n + 1);
        InputSource inputSource = null;
        byArray = this.dtdBytes.get(string3);
        if (byArray != null && (byteArrayInputStream = new ByteArrayInputStream(byArray)) != null) {
            inputSource = new InputSource(byteArrayInputStream);
        }
        return inputSource;
    }
}

