/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.math;

import com.jme.math.Vector3f;
import com.jme.util.geom.BufferUtils;
import com.jmex.font3d.math.DoublyConnectedEdgeList;
import com.jmex.font3d.math.GeometricException;
import com.jmex.font3d.math.PlanarEdge;
import com.jmex.font3d.math.PlanarVertex;
import com.jmex.font3d.math.TriangulationEdge;
import com.jmex.font3d.math.TriangulationVertex;
import java.nio.IntBuffer;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangulator
extends DoublyConnectedEdgeList<TriangulationVertex, TriangulationEdge> {
    private static final Logger logger = Logger.getLogger(Triangulator.class.getName());
    private IntBuffer complete_triangulation;
    private Vector<YMonotonePolygon> monotone_polygons = new Vector();
    int polyids = 0;

    float getXAtY(TriangulationEdge triangulationEdge, float f) {
        float f2 = triangulationEdge.getDX();
        float f3 = triangulationEdge.getDY();
        if (f3 == 0.0f) {
            if (triangulationEdge.getOrigin().point.y == f) {
                return triangulationEdge.getOrigin().point.x;
            }
            logger.warning("Degenerate case, dy == 0, no idea what will happen now....");
            return triangulationEdge.getOrigin().point.x;
        }
        float f4 = (f - triangulationEdge.getOrigin().point.y) / f3;
        return triangulationEdge.getOrigin().point.x + f2 * f4;
    }

    public IntBuffer triangulate(boolean bl) {
        if (bl) {
            this.complete_triangulation = null;
        }
        return this.triangulate();
    }

    public IntBuffer triangulate() {
        if (this.complete_triangulation == null) {
            this.checkTriangulation();
            this.generateMonotonePolygons();
            int n = this.triangulateMonotonePolygons();
            this.complete_triangulation = BufferUtils.createIntBuffer(n * 3);
            this.complete_triangulation.rewind();
            for (YMonotonePolygon yMonotonePolygon : this.monotone_polygons) {
                for (YMonotonePolygon.Triangle triangle : yMonotonePolygon.poly_tris) {
                    this.complete_triangulation.put(triangle.p1);
                    this.complete_triangulation.put(triangle.p2);
                    this.complete_triangulation.put(triangle.p3);
                }
            }
        }
        return this.complete_triangulation;
    }

    private void generateMonotonePolygons() {
        Object object22;
        for (Object object22 : this.getVertices()) {
            ((TriangulationVertex)object22).initializeType();
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SweepLineStatus
        extends TreeSet<TriangulationEdge> {
            private static final long serialVersionUID = 1L;
            SweepLineComparer sweep_comparer;

            public SweepLineStatus() {
                super(new SweepLineComparer());
                this.sweep_comparer = (SweepLineComparer)this.comparator();
            }

            @Override
            public boolean add(TriangulationEdge triangulationEdge) {
                boolean bl = super.add(triangulationEdge);
                if (!bl) {
                    logger.severe("The insertion of edge " + triangulationEdge + " had already been done....");
                }
                return bl;
            }

            void printElements() {
                for (TriangulationEdge triangulationEdge : this) {
                    logger.info("EDGE: " + triangulationEdge + ":" + Triangulator.this.getXAtY(triangulationEdge, this.sweep_comparer.currentvertex.point.y));
                }
            }

            public boolean remove(TriangulationEdge triangulationEdge) {
                boolean bl = super.remove(triangulationEdge);
                if (!bl) {
                    logger.severe("The removal of edge " + triangulationEdge + " did not succeed");
                }
                return bl;
            }

            public TriangulationEdge getLeftOf(TriangulationEdge triangulationEdge) {
                SortedSet<TriangulationEdge> sortedSet = this.headSet(triangulationEdge);
                if (sortedSet.size() == 0) {
                    logger.warning("We could find no left of " + triangulationEdge + ": " + Triangulator.this.getXAtY(triangulationEdge, this.sweep_comparer.currentvertex.point.y));
                    this.printElements();
                }
                return sortedSet.last();
            }

            public void setCurrentVertex(TriangulationVertex triangulationVertex) {
                this.sweep_comparer.currentvertex = triangulationVertex;
            }
        }
        SweepLineStatus sweepLineStatus = new SweepLineStatus();
        object22 = new PriorityQueue<TriangulationVertex>(this.getVertices().size(), new SweepQueueComparator());
        ((AbstractQueue)object22).addAll(this.getVertices());
        class DiagnalEdge {
            int src;
            int dst;

            public DiagnalEdge(int n, int n2) {
                this.src = n;
                this.dst = n2;
            }

            public String toString() {
                return "(" + this.src + "->" + this.dst + ")";
            }
        }
        Vector<DiagnalEdge> vector = new Vector<DiagnalEdge>();
        while (!((AbstractCollection)object22).isEmpty()) {
            TriangulationVertex triangulationVertex = (TriangulationVertex)((PriorityQueue)object22).poll();
            sweepLineStatus.setCurrentVertex(triangulationVertex);
            switch (triangulationVertex.getType()) {
                case START: {
                    sweepLineStatus.add(triangulationVertex.getOutGoingEdge());
                    triangulationVertex.getOutGoingEdge().helper = triangulationVertex;
                    break;
                }
                case END: {
                    if (triangulationVertex.getInGoingEdge().isHelperMergeVertex()) {
                        vector.add(new DiagnalEdge(triangulationVertex.getIndex(), triangulationVertex.getInGoingEdge().helper.getIndex()));
                    }
                    sweepLineStatus.remove(triangulationVertex.getInGoingEdge());
                    break;
                }
                case SPLIT: {
                    Object object3 = sweepLineStatus.getLeftOf(triangulationVertex.getOutGoingEdge());
                    vector.add(new DiagnalEdge(triangulationVertex.getIndex(), ((TriangulationEdge)object3).helper.getIndex()));
                    ((TriangulationEdge)object3).helper = triangulationVertex;
                    sweepLineStatus.add(triangulationVertex.getOutGoingEdge());
                    triangulationVertex.getOutGoingEdge().helper = triangulationVertex;
                    break;
                }
                case MERGE: {
                    if (triangulationVertex.getInGoingEdge().isHelperMergeVertex()) {
                        vector.add(new DiagnalEdge(triangulationVertex.getIndex(), triangulationVertex.getInGoingEdge().helper.getIndex()));
                    }
                    sweepLineStatus.remove(triangulationVertex.getInGoingEdge());
                    Object object3 = sweepLineStatus.getLeftOf(triangulationVertex.getInGoingEdge());
                    if (((TriangulationEdge)object3).isHelperMergeVertex()) {
                        vector.add(new DiagnalEdge(triangulationVertex.getIndex(), ((TriangulationEdge)object3).helper.getIndex()));
                    }
                    ((TriangulationEdge)object3).helper = triangulationVertex;
                    break;
                }
                case REGULAR_RIGHT: {
                    Object object3 = sweepLineStatus.getLeftOf(triangulationVertex.getOutGoingEdge());
                    if (((TriangulationEdge)object3).isHelperMergeVertex()) {
                        vector.add(new DiagnalEdge(triangulationVertex.getIndex(), ((TriangulationEdge)object3).helper.getIndex()));
                    }
                    ((TriangulationEdge)object3).helper = triangulationVertex;
                    break;
                }
                case REGULAR_LEFT: {
                    if (triangulationVertex.getInGoingEdge().isHelperMergeVertex()) {
                        vector.add(new DiagnalEdge(triangulationVertex.getIndex(), triangulationVertex.getInGoingEdge().helper.getIndex()));
                    }
                    sweepLineStatus.remove(triangulationVertex.getInGoingEdge());
                    sweepLineStatus.add(triangulationVertex.getOutGoingEdge());
                    triangulationVertex.getOutGoingEdge().helper = triangulationVertex;
                    break;
                }
                case UNSET: {
                    logger.info("PANIX: the type of a vertex was: " + (Object)((Object)triangulationVertex.getType()));
                }
            }
        }
        for (DiagnalEdge object4 : vector) {
            this.addDiagonal(object4.src, object4.dst);
        }
        this.checkTriangulation();
        this.monotone_polygons.clear();
        for (TriangulationEdge triangulationEdge : this.getEdges()) {
            triangulationEdge.marked = false;
        }
        for (TriangulationEdge triangulationEdge : this.getEdges()) {
            if (triangulationEdge.marked || !triangulationEdge.isRealEdge()) continue;
            this.monotone_polygons.add(new YMonotonePolygon(triangulationEdge));
        }
        this.checkTriangulation();
    }

    void addDiagonal(int n, int n2) {
        TriangulationEdge triangulationEdge = (TriangulationEdge)this.addEdge(n, n2);
        triangulationEdge.realedge = true;
        triangulationEdge.getTwin().realedge = true;
    }

    private boolean checkTriangulation() {
        for (TriangulationVertex triangulationVertex : this.getVertices()) {
            if (triangulationVertex.getFirstEdge() == null) {
                throw new GeometricException("We have a vertex with no edges: " + triangulationVertex);
            }
            if (triangulationVertex.checkAllEdges()) continue;
            return false;
        }
        return true;
    }

    private int triangulateMonotonePolygons() {
        int n = 0;
        for (YMonotonePolygon yMonotonePolygon : this.monotone_polygons) {
            n += yMonotonePolygon.triangulate();
            this.checkTriangulation();
        }
        return n;
    }

    @Override
    public TriangulationEdge createEdge(TriangulationVertex triangulationVertex, boolean bl) {
        return new TriangulationEdge(triangulationVertex, bl);
    }

    @Override
    public TriangulationVertex createVertex(int n, Vector3f vector3f) {
        return new TriangulationVertex(n, vector3f);
    }

    public ArrayList<TriangulationEdge> getEdges() {
        return this.edges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SweepQueueComparator
    implements Comparator<TriangulationVertex> {
        SweepQueueComparator() {
        }

        @Override
        public int compare(TriangulationVertex triangulationVertex, TriangulationVertex triangulationVertex2) {
            if (triangulationVertex == triangulationVertex2) {
                return 0;
            }
            return triangulationVertex.yLessThan(triangulationVertex2) ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SweepLineComparer
    implements Comparator<TriangulationEdge> {
        TriangulationVertex currentvertex = null;

        SweepLineComparer() {
        }

        @Override
        public int compare(TriangulationEdge triangulationEdge, TriangulationEdge triangulationEdge2) {
            float f;
            if (triangulationEdge == triangulationEdge2) {
                return 0;
            }
            float f2 = Triangulator.this.getXAtY(triangulationEdge, this.currentvertex.point.y);
            if (f2 == (f = Triangulator.this.getXAtY(triangulationEdge2, this.currentvertex.point.y))) {
                logger.info("--------------------");
                logger.info("Edge1: " + triangulationEdge);
                logger.info("Edge2: " + triangulationEdge2);
                logger.info("Edges share: " + this.currentvertex + ", use other ends.");
                TriangulationVertex triangulationVertex = triangulationEdge.getOtherEnd(this.currentvertex);
                logger.info("Other end(1):" + triangulationVertex);
                TriangulationVertex triangulationVertex2 = triangulationEdge2.getOtherEnd(this.currentvertex);
                logger.info("Other end(2):" + triangulationVertex2);
                Vector3f vector3f = new Vector3f(triangulationVertex.getPoint()).subtractLocal(this.currentvertex.getPoint()).normalizeLocal();
                Vector3f vector3f2 = new Vector3f(triangulationVertex2.getPoint()).subtractLocal(this.currentvertex.getPoint()).normalizeLocal();
                f2 = vector3f.dot(Vector3f.UNIT_X);
                f = vector3f2.dot(Vector3f.UNIT_X);
                if (Math.abs(f2 - f) < 1.1920929E-7f) {
                    logger.info("Still the same, using Y-coordinates");
                    f2 = triangulationVertex.getPoint().y;
                    f = triangulationVertex2.getPoint().y;
                }
            }
            if (f2 == f) {
                logger.warning("Equal vertices: " + f2 + " == " + f);
            }
            return f2 < f ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class YMonotonePolygon {
        ArrayList<TriangulationEdge> poly_edges = new ArrayList();
        ArrayList<Triangle> poly_tris = new ArrayList();
        private int polyid;

        public YMonotonePolygon(TriangulationEdge triangulationEdge) {
            TriangulationEdge triangulationEdge2;
            this.polyid = Triangulator.this.polyids++;
            TriangulationEdge triangulationEdge3 = triangulationEdge2 = triangulationEdge;
            do {
                triangulationEdge3.marked = true;
                this.poly_edges.add(triangulationEdge3);
                triangulationEdge3 = (TriangulationEdge)triangulationEdge3.getNext();
                if (triangulationEdge3.isRealEdge()) continue;
                throw new GeometricException("We cannot add a non-real edge to a polygon.");
            } while (triangulationEdge2 != triangulationEdge3);
        }

        public int triangulate() {
            TriangulationVertex triangulationVertex;
            int n = this.poly_edges.size() - 2;
            int n2 = n * 3;
            if (n == 1) {
                this.poly_tris.add(new Triangle(this.poly_edges.get(0).getOrigin().getIndex(), this.poly_edges.get(1).getOrigin().getIndex(), this.poly_edges.get(2).getOrigin().getIndex(), false));
                return n2;
            }
            ArrayList<TriangulationVertex> arrayList = this.createSortedVertexList();
            Stack<TriangulationVertex> stack = new Stack<TriangulationVertex>();
            stack.push(arrayList.get(0));
            stack.push(arrayList.get(1));
            for (int i = 2; i < arrayList.size() - 1; ++i) {
                boolean bl;
                TriangulationVertex triangulationVertex2;
                triangulationVertex = arrayList.get(i);
                if (triangulationVertex.is_left_chain != ((TriangulationVertex)stack.peek()).is_left_chain) {
                    while (stack.size() > 1) {
                        triangulationVertex2 = (TriangulationVertex)stack.pop();
                        this.poly_tris.add(new Triangle(triangulationVertex.getIndex(), triangulationVertex2.getIndex(), ((TriangulationVertex)stack.peek()).getIndex(), !triangulationVertex.is_left_chain));
                    }
                    stack.pop();
                    stack.push(arrayList.get(i - 1));
                    stack.push(triangulationVertex);
                    continue;
                }
                triangulationVertex2 = (TriangulationVertex)stack.pop();
                while (!stack.isEmpty() && triangulationVertex.is_left_chain == (bl = this.isLeftOf(triangulationVertex.getPoint(), triangulationVertex2.getPoint(), ((TriangulationVertex)stack.peek()).getPoint()))) {
                    this.poly_tris.add(new Triangle(triangulationVertex.getIndex(), triangulationVertex2.getIndex(), ((TriangulationVertex)stack.peek()).getIndex(), triangulationVertex.is_left_chain));
                    triangulationVertex2 = (TriangulationVertex)stack.pop();
                }
                stack.push(triangulationVertex2);
                stack.push(triangulationVertex);
            }
            TriangulationVertex triangulationVertex3 = null;
            if (stack.size() > 1) {
                triangulationVertex3 = (TriangulationVertex)stack.pop();
            }
            triangulationVertex = arrayList.get(arrayList.size() - 1);
            while (stack.size() > 0) {
                this.poly_tris.add(new Triangle(triangulationVertex.getIndex(), triangulationVertex3.getIndex(), ((TriangulationVertex)stack.peek()).getIndex(), triangulationVertex3.is_left_chain));
                triangulationVertex3 = (TriangulationVertex)stack.pop();
            }
            if (n != this.poly_tris.size()) {
                throw new GeometricException("Subdivision of monoton polygon: " + this.polyid + " did not give as many triangles as planned:(" + n + " != " + this.poly_tris.size() + ")");
            }
            return n2;
        }

        private ArrayList<TriangulationVertex> createSortedVertexList() {
            Object object;
            TriangulationEdge triangulationEdge;
            TriangulationEdge triangulationEdge2 = triangulationEdge = this.poly_edges.get(0);
            for (TriangulationEdge triangulationEdge3 : this.poly_edges) {
                object = (TriangulationVertex)triangulationEdge3.getOrigin();
                if (((TriangulationVertex)triangulationEdge.getOrigin()).yLessThan((PlanarVertex)object)) {
                    triangulationEdge = triangulationEdge3;
                }
                if (!((TriangulationVertex)object).yLessThan(triangulationEdge2.getOrigin())) continue;
                triangulationEdge2 = triangulationEdge3;
            }
            ArrayList arrayList = new ArrayList();
            int n = this.poly_edges.size() * 2;
            arrayList.add((TriangulationVertex)triangulationEdge.getOrigin());
            object = (TriangulationEdge)triangulationEdge.getNext();
            TriangulationEdge triangulationEdge4 = (TriangulationEdge)triangulationEdge.getPrev();
            while (object != triangulationEdge2 || triangulationEdge4 != triangulationEdge2) {
                TriangulationVertex triangulationVertex = (TriangulationVertex)((PlanarEdge)object).getOrigin();
                TriangulationVertex triangulationVertex2 = (TriangulationVertex)triangulationEdge4.getOrigin();
                triangulationVertex.is_left_chain = true;
                triangulationVertex2.is_left_chain = false;
                if (triangulationVertex.yLessThan(triangulationVertex2)) {
                    arrayList.add(triangulationVertex2);
                    triangulationEdge4 = (TriangulationEdge)triangulationEdge4.getPrev();
                } else {
                    arrayList.add(triangulationVertex);
                    object = (TriangulationEdge)((PlanarEdge)object).getNext();
                }
                if (n-- >= 0) continue;
                throw new RuntimeException("We could not get from top to bottom of the poly:" + this);
            }
            arrayList.add((TriangulationVertex)triangulationEdge2.getOrigin());
            if (arrayList.size() != this.poly_edges.size()) {
                logger.warning("The number of vertices does not match the number of edges: " + arrayList.size() + " != " + this.poly_edges.size());
                throw new RuntimeException("The number of vertices does not match the number of edges: " + arrayList.size() + " != " + this.poly_edges.size());
            }
            return arrayList;
        }

        private boolean isLeftOf(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
            return 0.0f > (vector3f2.x - vector3f.x) * (vector3f3.y - vector3f.y) - (vector3f3.x - vector3f.x) * (vector3f2.y - vector3f.y);
        }

        class Triangle {
            int p1;
            int p2;
            int p3;

            Triangle(int n, int n2, int n3, boolean bl) {
                this.p1 = bl ? n : n2;
                this.p2 = bl ? n2 : n;
                this.p3 = n3;
            }
        }
    }
}

