/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.math;

import com.jme.math.FastMath;
import com.jmex.font3d.math.GeometricException;
import com.jmex.font3d.math.PlanarVertex;

public class PlanarEdge {
    private PlanarVertex orig;
    private PlanarEdge twin;
    private PlanarEdge next;
    private PlanarEdge prev;
    float angle = -1.0f;
    boolean realedge;

    PlanarEdge(PlanarVertex planarVertex, boolean bl) {
        this.orig = planarVertex;
        this.realedge = bl;
    }

    public boolean isRealEdge() {
        return this.realedge;
    }

    public PlanarVertex getOrigin() {
        return this.orig;
    }

    public float angleCounterClockWise(PlanarEdge planarEdge) {
        float f;
        if (this == planarEdge) {
            throw new RuntimeException("You are trying to find the angle after adding an edge...");
        }
        for (f = planarEdge.getAngle(); f < this.getAngle(); f += (float)Math.PI * 2) {
        }
        while (f > this.getAngle() + (float)Math.PI * 2) {
            f -= (float)Math.PI * 2;
        }
        if (f == this.getAngle() && !this.isRealEdge()) {
            f += (float)Math.PI * 2;
        }
        return f - this.getAngle();
    }

    float getDX() {
        return this.twin.orig.point.x - this.orig.point.x;
    }

    float getDY() {
        return this.twin.orig.point.y - this.orig.point.y;
    }

    float getAngle() {
        return this.angle;
    }

    public PlanarVertex getDestination() {
        return this.twin.orig;
    }

    PlanarEdge getNext() {
        return this.next;
    }

    void setNext(PlanarEdge planarEdge) {
        this.next = planarEdge;
        planarEdge.prev = this;
    }

    PlanarEdge getPrev() {
        return this.prev;
    }

    PlanarEdge getTwin() {
        return this.twin;
    }

    void setTwin(PlanarEdge planarEdge) {
        this.twin = planarEdge;
        planarEdge.twin = this;
        this.angle = FastMath.atan2(this.getDY(), this.getDX());
        planarEdge.angle = FastMath.atan2(planarEdge.getDY(), planarEdge.getDX());
        float f = 4.7683716E-7f;
        float f2 = FastMath.abs(this.angleCounterClockWise(planarEdge) - (float)Math.PI);
        if (f2 > f) {
            throw new GeometricException("Two twins do not have opposite angles: " + this.angleCounterClockWise(planarEdge) + " != " + (float)Math.PI + " : (" + f2 + " > " + f + ")");
        }
    }
}

