/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.effects;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.util.geom.BufferUtils;
import com.jmex.font3d.Font3D;
import com.jmex.font3d.Glyph3D;
import com.jmex.font3d.effects.Font3DEffect;
import com.jmex.font3d.math.PlanarEdge;
import com.jmex.font3d.math.PlanarVertex;
import com.jmex.font3d.math.TriangulationVertex;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;

public class Font3DBorder
implements Font3DEffect {
    private ColorRGBA inner_color;
    private ColorRGBA outer_color;
    private float width;
    private boolean drawSides;
    private boolean drawFront;
    private boolean drawBack;

    public Font3DBorder(float f, ColorRGBA colorRGBA, ColorRGBA colorRGBA2, boolean bl, boolean bl2, boolean bl3) {
        this.inner_color = colorRGBA;
        this.outer_color = colorRGBA2;
        this.width = f;
        this.drawSides = bl;
        this.drawFront = bl2;
        this.drawBack = bl3;
    }

    public Font3DBorder(float f, ColorRGBA colorRGBA, ColorRGBA colorRGBA2, Font3D font3D) {
        this(f, colorRGBA, colorRGBA2, font3D.drawSides(), font3D.drawFront(), font3D.drawBack());
    }

    public void applyEffect(Font3D font3D) {
        boolean bl = font3D.isMeshLocked();
        if (bl) {
            font3D.unlockMesh();
        }
        for (Glyph3D glyph3D : font3D.getGlyphs()) {
            if (glyph3D == null || glyph3D.getBatch() == null || glyph3D.getBatch().getVertexCount() <= 0) continue;
            this.applyEffect(font3D, glyph3D);
        }
        if (this.inner_color.a != 1.0f || this.outer_color.a != 1.0f) {
            font3D.enableAlphaState();
        }
        if (bl) {
            font3D.lockMesh();
        }
    }

    private void applyEffect(Font3D font3D, Glyph3D glyph3D) {
        int n;
        Iterator<PlanarEdge> iterator;
        int n2;
        int n3;
        int n4;
        Object object;
        boolean bl;
        int n5 = 0;
        int n6 = 0;
        int n7 = glyph3D.getVertices().size();
        boolean bl2 = bl = glyph3D.getBatch().getColorBuffer() != null;
        if (this.drawSides) {
            n5 += n7 * 2;
            n6 += n7 * 6;
        }
        if (this.drawFront) {
            n5 += n7 * 2;
            n6 += n7 * 6;
        }
        if (this.drawBack) {
            n5 += n7 * 2;
            n6 += n7 * 6;
        }
        Vector3f[] vector3fArray = new Vector3f[n5];
        Vector3f[] vector3fArray2 = new Vector3f[n5];
        Vector2f[] vector2fArray = new Vector2f[n5];
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n6);
        ColorRGBA[] colorRGBAArray = bl ? new ColorRGBA[n5] : null;
        int n8 = glyph3D.getBatch().getVertexCount();
        int n9 = 0;
        if (this.drawSides) {
            for (TriangulationVertex object32 : glyph3D.getVertices()) {
                Vector3f vector3f;
                vector3fArray2[n9 + object32.getIndex()] = vector3f = glyph3D.getOutlineNormals()[object32.getIndex()];
                vector3fArray[n9 + object32.getIndex()] = new Vector3f(vector3f).multLocal(this.width).addLocal(object32.getPoint());
                vector3fArray[n9 + object32.getIndex()].z += 0.5f;
                if (bl) {
                    colorRGBAArray[n9 + object32.getIndex()] = this.outer_color;
                }
                vector3fArray2[n9 + object32.getIndex() + n7] = vector3f;
                vector3fArray[n9 + object32.getIndex() + n7] = new Vector3f(vector3f).multLocal(this.width).addLocal(object32.getPoint());
                vector3fArray[n9 + object32.getIndex() + n7].z -= 0.5f;
                if (!bl) continue;
                colorRGBAArray[n9 + object32.getIndex() + n7] = this.outer_color;
            }
            n9 += n7 * 2;
            for (PlanarEdge planarEdge : glyph3D.getOutline()) {
                if (!planarEdge.isRealEdge()) continue;
                PlanarVertex planarVertex = planarEdge.getOrigin();
                object = planarEdge.getDestination();
                int n10 = n8 + planarVertex.getIndex();
                n4 = n8 + ((PlanarVertex)object).getIndex();
                n3 = n8 + ((PlanarVertex)object).getIndex() + n7;
                n2 = n8 + planarVertex.getIndex() + n7;
                intBuffer.put(new int[]{n10, n3, n4, n3, n10, n2});
            }
            n8 += n7 * 2;
        }
        if (this.drawFront) {
            iterator = new Vector3f(0.0f, 0.0f, 1.0f);
            for (TriangulationVertex triangulationVertex : glyph3D.getVertices()) {
                object = glyph3D.getOutlineNormals()[triangulationVertex.getIndex()];
                vector3fArray2[n9 + triangulationVertex.getIndex()] = iterator;
                vector3fArray[n9 + triangulationVertex.getIndex()] = new Vector3f(triangulationVertex.getPoint());
                vector3fArray[n9 + triangulationVertex.getIndex()].z += 0.5f;
                if (bl) {
                    colorRGBAArray[n9 + triangulationVertex.getIndex()] = this.inner_color;
                }
                vector3fArray2[n9 + triangulationVertex.getIndex() + n7] = iterator;
                vector3fArray[n9 + triangulationVertex.getIndex() + n7] = new Vector3f((Vector3f)object).multLocal(this.width).addLocal(triangulationVertex.getPoint());
                vector3fArray[n9 + triangulationVertex.getIndex() + n7].z += 0.5f;
                if (!bl) continue;
                colorRGBAArray[n9 + triangulationVertex.getIndex() + n7] = this.outer_color;
            }
            n9 += n7 * 2;
            for (PlanarEdge planarEdge : glyph3D.getOutline()) {
                if (!planarEdge.isRealEdge()) continue;
                object = planarEdge.getOrigin();
                PlanarVertex planarVertex = planarEdge.getDestination();
                n4 = n8 + ((PlanarVertex)object).getIndex();
                n3 = n8 + planarVertex.getIndex();
                n2 = n8 + planarVertex.getIndex() + n7;
                n = n8 + ((PlanarVertex)object).getIndex() + n7;
                intBuffer.put(new int[]{n4, n2, n3, n2, n4, n});
            }
            n8 += n7 * 2;
        }
        if (this.drawBack) {
            iterator = new Vector3f(0.0f, 0.0f, 1.0f);
            for (TriangulationVertex triangulationVertex : glyph3D.getVertices()) {
                object = glyph3D.getOutlineNormals()[triangulationVertex.getIndex()];
                vector3fArray2[n9 + triangulationVertex.getIndex()] = iterator;
                vector3fArray[n9 + triangulationVertex.getIndex()] = new Vector3f(triangulationVertex.getPoint());
                vector3fArray[n9 + triangulationVertex.getIndex()].z -= 0.5f;
                if (bl) {
                    colorRGBAArray[n9 + triangulationVertex.getIndex()] = this.inner_color;
                }
                vector3fArray2[n9 + triangulationVertex.getIndex() + n7] = iterator;
                vector3fArray[n9 + triangulationVertex.getIndex() + n7] = new Vector3f((Vector3f)object).multLocal(this.width).addLocal(triangulationVertex.getPoint());
                vector3fArray[n9 + triangulationVertex.getIndex() + n7].z -= 0.5f;
                if (!bl) continue;
                colorRGBAArray[n9 + triangulationVertex.getIndex() + n7] = this.outer_color;
            }
            n9 += n7 * 2;
            for (PlanarEdge planarEdge : glyph3D.getOutline()) {
                if (!planarEdge.isRealEdge()) continue;
                object = planarEdge.getOrigin();
                PlanarVertex planarVertex = planarEdge.getDestination();
                n4 = n8 + ((PlanarVertex)object).getIndex();
                n3 = n8 + planarVertex.getIndex();
                n2 = n8 + planarVertex.getIndex() + n7;
                n = n8 + ((PlanarVertex)object).getIndex() + n7;
                intBuffer.put(new int[]{n4, n3, n2, n4, n2, n});
            }
            n8 += n7 * 2;
        }
        for (int i = 0; i < vector3fArray.length; ++i) {
            vector2fArray[i] = new Vector2f(vector3fArray[i].x, vector3fArray[i].y);
        }
        IntBuffer intBuffer2 = BufferUtils.createIntBuffer(glyph3D.getBatch().getIndexBuffer().capacity() + n6);
        intBuffer2.rewind();
        glyph3D.getBatch().getIndexBuffer().rewind();
        intBuffer.rewind();
        intBuffer2.put(glyph3D.getBatch().getIndexBuffer());
        intBuffer2.put(intBuffer);
        glyph3D.getBatch().setIndexBuffer(intBuffer2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(glyph3D.getBatch().getVertexBuffer().capacity() + n5 * 3);
        floatBuffer.rewind();
        glyph3D.getBatch().getVertexBuffer().rewind();
        floatBuffer.put(glyph3D.getBatch().getVertexBuffer());
        Font3DBorder.putInBuffer(floatBuffer, vector3fArray);
        glyph3D.getBatch().setVertexBuffer(floatBuffer);
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(glyph3D.getBatch().getNormalBuffer().capacity() + n5 * 3);
        floatBuffer2.rewind();
        glyph3D.getBatch().getNormalBuffer().rewind();
        floatBuffer2.put(glyph3D.getBatch().getNormalBuffer());
        Font3DBorder.putInBuffer(floatBuffer2, vector3fArray2);
        glyph3D.getBatch().setNormalBuffer(floatBuffer2);
        object = BufferUtils.createFloatBuffer(glyph3D.getBatch().getTextureBuffer(0).capacity() + n5 * 2);
        ((FloatBuffer)object).rewind();
        glyph3D.getBatch().getTextureBuffer(0).rewind();
        ((FloatBuffer)object).put(glyph3D.getBatch().getTextureBuffer(0));
        Font3DBorder.putInBuffer((FloatBuffer)object, vector2fArray);
        glyph3D.getBatch().setTextureBuffer((FloatBuffer)object, 0);
        if (bl) {
            FloatBuffer floatBuffer3 = BufferUtils.createFloatBuffer(glyph3D.getBatch().getColorBuffer().capacity() + n5 * 4);
            floatBuffer3.rewind();
            glyph3D.getBatch().getColorBuffer().rewind();
            floatBuffer3.put(glyph3D.getBatch().getColorBuffer());
            Font3DBorder.putInBuffer(floatBuffer3, colorRGBAArray);
            glyph3D.getBatch().setColorBuffer(floatBuffer3);
        }
    }

    private static void putInBuffer(FloatBuffer floatBuffer, ColorRGBA[] colorRGBAArray) {
        for (ColorRGBA colorRGBA : colorRGBAArray) {
            floatBuffer.put(colorRGBA.r);
            floatBuffer.put(colorRGBA.g);
            floatBuffer.put(colorRGBA.b);
            floatBuffer.put(colorRGBA.a);
        }
    }

    private static void putInBuffer(FloatBuffer floatBuffer, Vector2f[] vector2fArray) {
        for (Vector2f vector2f : vector2fArray) {
            floatBuffer.put(vector2f.x);
            floatBuffer.put(vector2f.y);
        }
    }

    private static void putInBuffer(FloatBuffer floatBuffer, Vector3f[] vector3fArray) {
        for (Vector3f vector3f : vector3fArray) {
            floatBuffer.put(vector3f.x);
            floatBuffer.put(vector3f.y);
            floatBuffer.put(vector3f.z);
        }
    }
}

