/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d;

import com.jme.bounding.OrientedBoundingBox;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.SharedMesh;
import com.jme.scene.TriMesh;
import com.jme.scene.state.MaterialState;
import com.jme.system.DisplaySystem;
import com.jmex.font3d.Font3D;
import com.jmex.font3d.Glyph3D;
import com.jmex.font3d.Glyph3DSharedBatch;
import com.jmex.font3d.JmeText;
import com.jmex.font3d.TextFactory;
import java.util.logging.Logger;

public class Text3D
extends SharedMesh
implements JmeText {
    private static final Logger logger = Logger.getLogger(Text3D.class.getName());
    private static final long serialVersionUID = 7715674618025080804L;
    private Font3D factory;
    private float height;
    private float width;
    private float size;
    private StringBuffer text = new StringBuffer();
    private ColorRGBA fontcolor = new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f);
    private float localscale;
    OrientedBoundingBox render_mesh_bounds;
    private static Vector3f _direction1 = new Vector3f();
    private static Vector3f _direction2 = new Vector3f();
    private static Vector3f _direction3 = new Vector3f();

    public Text3D(Font3D font3D, String string, float f) {
        super("Some3DText", font3D.getRenderTriMesh());
        this.factory = font3D;
        this.render_mesh_bounds = new OrientedBoundingBox();
        this.setSize(f);
        this.setText(string);
        this.updateRenderState();
    }

    public void updateWorldBound() {
        this.worldBound = this.render_mesh_bounds.transform(this.getWorldRotation(), this.getWorldTranslation(), this.getWorldScale(), this.worldBound);
    }

    public TextFactory getFactory() {
        return this.factory;
    }

    public int getFlags() {
        return 0;
    }

    public float getSize() {
        return this.size;
    }

    public StringBuffer getText() {
        return this.text;
    }

    public void setSize(float f) {
        this.size = f;
        this.localscale = f / (float)this.factory.getFont().getSize();
        this.setLocalScale(this.localscale);
    }

    public void setText(String string) {
        this.width = 0.0f;
        this.height = 0.0f;
        this.text.setLength(0);
        this.clearBatches();
        this.appendText(string);
    }

    public void appendText(String string) {
        for (char c : string.toCharArray()) {
            Glyph3D glyph3D = this.factory.getGlyph(c);
            this.width = (float)((double)this.width + glyph3D.getBounds().getWidth() * (double)this.localscale);
            this.height = (float)Math.max((double)this.height, glyph3D.getBounds().getHeight() * (double)this.localscale);
            if (glyph3D.getBatchId() == -1) continue;
            Glyph3DSharedBatch glyph3DSharedBatch = new Glyph3DSharedBatch(this.factory.getRenderTriMesh().getBatch(glyph3D.getBatchId()));
            glyph3DSharedBatch.setParentGeom(this);
            this.batchList.add(glyph3DSharedBatch);
        }
        this.text.append(string);
        this.updateModelBound();
    }

    public void updateModelBound() {
        this.render_mesh_bounds.extent.x = this.width / 2.0f / this.localscale;
        this.render_mesh_bounds.extent.y = this.height / 2.0f / this.localscale;
        this.render_mesh_bounds.extent.z = 0.5f;
        this.render_mesh_bounds.getCenter().x = this.width / 2.0f / this.localscale;
        this.render_mesh_bounds.getCenter().y = this.height / 2.0f / this.localscale;
    }

    public void draw(Renderer renderer) {
        this.getWorldRotation().mult(Vector3f.UNIT_X, _direction1).multLocal(this.getWorldScale());
        _direction2.set(this.getWorldTranslation());
        int n = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            Glyph3D glyph3D = this.factory.getGlyph(c);
            if (glyph3D.getBatchId() != -1) {
                Glyph3DSharedBatch glyph3DSharedBatch = (Glyph3DSharedBatch)this.getBatch(n++);
                glyph3DSharedBatch.glyphTranslation.set(_direction2);
                glyph3DSharedBatch.onDraw(renderer);
            }
            float f = (float)glyph3D.getBounds().getWidth();
            _direction2.addLocal(_direction1.mult(f, _direction3));
        }
    }

    public void setTarget(TriMesh triMesh) {
        this.batchList.clear();
    }

    public ColorRGBA getFontColor() {
        return this.fontcolor;
    }

    public void setFontColor(ColorRGBA colorRGBA) {
        this.fontcolor.set(colorRGBA);
        if (!this.factory.has_diffuse_material) {
            MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
            materialState.setDiffuse(colorRGBA);
            materialState.setEnabled(true);
            this.setRenderState(materialState);
        } else {
            logger.warning("You cannot set the font-color on Text3D when the Font3D has a font color already.");
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void alignCenter() {
        this.getLocalTranslation().x = -this.width / 2.0f;
        this.updateWorldVectors();
    }
}

