/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import java.io.IOException;
import java.util.ArrayList;

public class WanderInfluence
extends ParticleInfluence {
    public static final float DEFAULT_RADIUS = 0.03f;
    public static final float DEFAULT_DISTANCE = 0.2f;
    public static final float DEFAULT_JITTER = 0.005f;
    private float wanderRadius = 0.03f;
    private float wanderDistance = 0.2f;
    private float wanderJitter = 0.005f;
    private ArrayList<Vector3f> wanderTargets = new ArrayList(1);
    private Vector3f workVect = new Vector3f();

    public void prepare(ParticleGeometry particleGeometry) {
        if (this.wanderTargets.size() != particleGeometry.getNumParticles()) {
            this.wanderTargets = new ArrayList(particleGeometry.getNumParticles());
            int n = particleGeometry.getNumParticles();
            while (--n >= 0) {
                this.wanderTargets.add(new Vector3f(particleGeometry.getEmissionDirection()).normalizeLocal());
            }
        }
    }

    public void apply(float f, Particle particle, int n) {
        if (this.wanderRadius == 0.0f && this.wanderDistance == 0.0f && this.wanderJitter == 0.0f) {
            return;
        }
        Vector3f vector3f = this.wanderTargets.get(n);
        vector3f.addLocal(this.calcNewJitter(), this.calcNewJitter(), this.calcNewJitter());
        vector3f.normalizeLocal();
        vector3f.multLocal(this.wanderRadius);
        this.workVect.set(particle.getVelocity()).normalizeLocal().multLocal(this.wanderDistance);
        this.workVect.addLocal(vector3f).normalizeLocal();
        this.workVect.multLocal(particle.getVelocity().length());
        particle.getVelocity().set(this.workVect);
    }

    private float calcNewJitter() {
        return (FastMath.nextRandomFloat() * 2.0f - 1.0f) * this.wanderJitter;
    }

    public float getWanderDistance() {
        return this.wanderDistance;
    }

    public void setWanderDistance(float f) {
        this.wanderDistance = f;
    }

    public float getWanderJitter() {
        return this.wanderJitter;
    }

    public void setWanderJitter(float f) {
        this.wanderJitter = f;
    }

    public float getWanderRadius() {
        return this.wanderRadius;
    }

    public void setWanderRadius(float f) {
        this.wanderRadius = f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.wanderRadius, "wanderRadius", 0.03f);
        outputCapsule.write(this.wanderDistance, "wanderDistance", 0.2f);
        outputCapsule.write(this.wanderJitter, "wanderJitter", 0.005f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.wanderRadius = inputCapsule.readFloat("wanderRadius", 0.03f);
        this.wanderDistance = inputCapsule.readFloat("wanderDistance", 0.2f);
        this.wanderJitter = inputCapsule.readFloat("wanderJitter", 0.005f);
    }
}

