/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.intersection.CollisionResults;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.Spatial;
import com.jme.scene.batch.LineBatch;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import java.util.ArrayList;

public class ParticleLines
extends ParticleGeometry {
    private static final long serialVersionUID = 2L;

    public ParticleLines() {
    }

    public ParticleLines(String string, int n) {
        super(string, n);
    }

    protected void initializeParticles(int n) {
        int n2;
        Vector2f[] vector2fArray = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f)};
        int n3 = ParticleLines.getVertsForParticleType(this.getParticleType());
        this.geometryCoordinates = BufferUtils.createVector3Buffer(n * n3);
        int[] nArray = new int[n * 2];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[0 + n2 * 2] = n2 * 2 + 0;
            nArray[1 + n2 * 2] = n2 * 2 + 1;
        }
        this.appearanceColors = BufferUtils.createColorBuffer(n * n3);
        this.particles = new Particle[n];
        this.setVertexBuffer(0, this.geometryCoordinates);
        this.setColorBuffer(0, this.appearanceColors);
        this.setTextureBuffer(0, BufferUtils.createVector2Buffer(n * n3));
        this.getBatch(0).setIndexBuffer(BufferUtils.createIntBuffer(nArray));
        this.setRenderQueueMode(2);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
        this.invScale = new Vector3f();
        for (n2 = 0; n2 < n; ++n2) {
            this.particles[n2] = new Particle(this);
            this.particles[n2].init();
            this.particles[n2].setStartIndex(n2 * n3);
            for (int i = n3 - 1; i >= 0; --i) {
                int n4 = n2 * n3 + i;
                BufferUtils.setInBuffer(vector2fArray[i], this.getTextureBuffer(0, 0), n4);
                BufferUtils.setInBuffer(this.particles[n2].getCurrentColor(), this.appearanceColors, n4);
            }
        }
    }

    public int getParticleType() {
        return 3;
    }

    public void draw(Renderer renderer) {
        LineBatch lineBatch;
        Camera camera = renderer.getCamera();
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.getStatus() != 1) continue;
            particle.updateVerts(camera);
        }
        if (this.getBatchCount() == 1 && (lineBatch = this.getBatch(0)) != null && lineBatch.isEnabled()) {
            lineBatch.setLastFrustumIntersection(this.frustrumIntersects);
            lineBatch.draw(renderer);
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            LineBatch lineBatch2 = this.getBatch(i);
            if (lineBatch2 == null || !lineBatch2.isEnabled()) continue;
            lineBatch2.onDraw(renderer);
        }
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        LineBatch lineBatch = new LineBatch();
        lineBatch.setParentGeom(this);
        this.batchList.add(lineBatch);
    }

    public LineBatch getBatch(int n) {
        return (LineBatch)this.batchList.get(n);
    }

    public boolean isAntialiased() {
        return this.getBatch(0).isAntialiased();
    }

    public void setAntialiased(boolean bl) {
        this.getBatch(0).setAntialiased(bl);
    }

    public int getMode() {
        return this.getBatch(0).getMode();
    }

    public void setMode(int n) {
        this.getBatch(0).setMode(n);
    }

    public float getLineWidth() {
        return this.getBatch(0).getLineWidth();
    }

    public void setLineWidth(float f) {
        this.getBatch(0).setLineWidth(f);
    }

    public short getStipplePattern() {
        return this.getBatch(0).getStipplePattern();
    }

    public void setStipplePattern(short s) {
        this.getBatch(0).setStipplePattern(s);
    }

    public int getStippleFactor() {
        return this.getBatch(0).getStippleFactor();
    }

    public void setStippleFactor(int n) {
        this.getBatch(0).setStippleFactor(n);
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }
}

