/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleControllerListener;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleController
extends Controller {
    private static final long serialVersionUID = 1L;
    private ParticleGeometry particles;
    private int particlesToCreate = 0;
    private float releaseVariance;
    private float currentTime;
    private float prevTime;
    private float releaseParticles;
    private float timePassed;
    private float precision;
    private boolean controlFlow;
    private int iterations;
    private ArrayList<ParticleInfluence> influences;
    protected ArrayList<ParticleControllerListener> listeners;

    public ParticleController() {
    }

    public ParticleController(ParticleGeometry particleGeometry) {
        this.particles = particleGeometry;
        this.setMinTime(0.0f);
        this.setMaxTime(Float.MAX_VALUE);
        this.setRepeatType(1);
        this.setSpeed(1.0f);
        this.releaseVariance = 0.0f;
        this.controlFlow = false;
        this.precision = 0.01f;
        particleGeometry.updateRotationMatrix();
    }

    @Override
    public void update(float f) {
        this.currentTime += f * this.getSpeed();
        this.timePassed = this.currentTime - this.prevTime;
        if (this.timePassed < this.precision * this.getSpeed()) {
            return;
        }
        this.prevTime = this.currentTime;
        this.particles.updateRotationMatrix();
        if (this.currentTime >= this.getMinTime() && this.currentTime <= this.getMaxTime()) {
            if (this.controlFlow) {
                this.releaseParticles += (float)this.particles.getReleaseRate() * this.timePassed * (1.0f + this.releaseVariance * (FastMath.nextRandomFloat() - 0.5f));
                this.particlesToCreate = (int)this.releaseParticles;
                if (this.particlesToCreate > 0) {
                    this.releaseParticles -= (float)this.particlesToCreate;
                } else {
                    this.particlesToCreate = 0;
                }
            }
            this.particles.updateInvScale();
            if (this.influences != null) {
                for (ParticleInfluence particleInfluence : this.influences) {
                    particleInfluence.prepare(this.particles);
                }
            }
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < this.particles.getNumParticles(); ++i) {
                int n;
                Particle particle = this.particles.getParticle(i);
                if (this.influences != null && particle.getStatus() == 1) {
                    for (n = 0; n < this.influences.size(); ++n) {
                        ParticleInfluence particleInfluence = this.influences.get(n);
                        if (!particleInfluence.isEnabled()) continue;
                        particleInfluence.apply(this.timePassed, particle, i);
                    }
                }
                if (!((n = particle.updateAndCheck(this.timePassed)) == 0 || this.controlFlow && this.particlesToCreate <= 0)) {
                    if (particle.getStatus() != 0 || this.getRepeatType() != 0) {
                        bl = false;
                        if (this.controlFlow) {
                            --this.particlesToCreate;
                        }
                        particle.recreateParticle(this.particles.getRandomLifeSpan());
                        particle.setStatus(1);
                        this.particles.initParticleLocation(i);
                        this.particles.resetParticleVelocity(i);
                        particle.updateVerts(null);
                    }
                } else if (n == 0 || this.controlFlow && this.particles.getReleaseRate() > 0) {
                    bl = false;
                }
                if (particle.getStatus() != 1) continue;
                bl2 = true;
            }
            if (bl) {
                this.setActive(false);
                if (this.listeners != null && this.listeners.size() > 0) {
                    for (ParticleControllerListener particleControllerListener : this.listeners) {
                        particleControllerListener.onDead(this.particles);
                    }
                }
            }
            if (this.particles.getBatch(0).getModelBound() != null && bl2) {
                this.particles.updateModelBound();
                this.particles.updateWorldBoundManually();
            }
        }
    }

    public float getPrecision() {
        return this.precision;
    }

    public void setPrecision(float f) {
        this.precision = f;
    }

    public float getReleaseVariance() {
        return this.releaseVariance;
    }

    public void setReleaseVariance(float f) {
        this.releaseVariance = f;
    }

    public boolean isControlFlow() {
        return this.controlFlow;
    }

    public void setControlFlow(boolean bl) {
        this.controlFlow = bl;
    }

    public Spatial getParticles() {
        return this.particles;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public void addInfluence(ParticleInfluence particleInfluence) {
        if (this.influences == null) {
            this.influences = new ArrayList(1);
        }
        this.influences.add(particleInfluence);
    }

    public boolean removeInfluence(ParticleInfluence particleInfluence) {
        if (this.influences == null) {
            return false;
        }
        return this.influences.remove(particleInfluence);
    }

    public ArrayList<ParticleInfluence> getInfluences() {
        return this.influences;
    }

    public void clearInfluences() {
        if (this.influences != null) {
            this.influences.clear();
        }
    }

    public void addListener(ParticleControllerListener particleControllerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(particleControllerListener);
    }

    public void removeListener(ParticleControllerListener particleControllerListener) {
        if (this.listeners != null) {
            this.listeners.remove(particleControllerListener);
        }
    }

    public void removeListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public boolean containsListener(ParticleControllerListener particleControllerListener) {
        if (this.listeners != null) {
            return this.listeners.contains(particleControllerListener);
        }
        return false;
    }

    public ArrayList<ParticleControllerListener> getListeners() {
        return this.listeners;
    }

    public void warmUp(int n) {
        this.particles.initAllParticlesLocation();
        int n2 = n *= 10;
        while (--n2 >= 0) {
            this.update(0.1f);
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.particles, "particleMesh", null);
        outputCapsule.write(this.releaseVariance, "releaseVariance", 0.0f);
        outputCapsule.write(this.precision, "precision", 0.0f);
        outputCapsule.write(this.controlFlow, "controlFlow", false);
        outputCapsule.write(this.iterations, "iterations", 0);
        outputCapsule.writeSavableArrayList(this.influences, "influences", null);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.particles = (ParticleGeometry)inputCapsule.readSavable("particleMesh", null);
        this.releaseVariance = inputCapsule.readFloat("releaseVariance", 0.0f);
        this.precision = inputCapsule.readFloat("precision", 0.0f);
        this.controlFlow = inputCapsule.readBoolean("controlFlow", false);
        this.iterations = inputCapsule.readInt("iterations", 0);
        this.influences = inputCapsule.readSavableArrayList("influences", null);
    }
}

