/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.particles.ParticleGeometry;
import java.io.IOException;

public class Particle
implements Savable {
    public static final int DEAD = 0;
    public static final int ALIVE = 1;
    public static final int AVAILABLE = 2;
    private int startIndex;
    private Vector3f position;
    private ColorRGBA startColor = ColorRGBA.black.clone();
    private ColorRGBA currColor = ColorRGBA.black.clone();
    private int status = 2;
    private float currentSize;
    private float lifeSpan;
    private float spinAngle;
    private float mass = 1.0f;
    private float invMass = 1.0f;
    private int currentAge;
    private ParticleGeometry parent;
    private Vector3f velocity;
    private Vector3f bbX = new Vector3f();
    private Vector3f bbY = new Vector3f();
    private float rChange;
    private float gChange;
    private float bChange;
    private float aChange;
    private int type = 0;
    private Triangle triModel;
    private static Vector3f tempVec = new Vector3f();
    private static Quaternion tempQuat = new Quaternion();

    public Particle() {
    }

    public Particle(ParticleGeometry particleGeometry) {
        this.parent = particleGeometry;
        this.type = particleGeometry.getParticleType();
    }

    public void init() {
        this.init(this.parent.getRandomVelocity(null), new Vector3f(), this.parent.getRandomLifeSpan());
    }

    public void init(Vector3f vector3f, Vector3f vector3f2, float f) {
        this.lifeSpan = f;
        this.velocity = vector3f.clone();
        this.position = vector3f2.clone();
        this.startColor = this.parent.getStartColor().clone();
        this.currColor = new ColorRGBA(this.startColor);
        this.currentAge = 0;
        this.status = 2;
        this.currentSize = this.parent.getStartSize();
    }

    public void recreateParticle(float f) {
        this.lifeSpan = f;
        int n = ParticleGeometry.getVertsForParticleType(this.type);
        this.startColor.set(this.parent.getStartColor());
        this.currColor.set(this.startColor);
        this.rChange = this.startColor.r - this.parent.getEndColor().r;
        this.gChange = this.startColor.g - this.parent.getEndColor().g;
        this.bChange = this.startColor.b - this.parent.getEndColor().b;
        this.aChange = this.startColor.a - this.parent.getEndColor().a;
        for (int i = 0; i < n; ++i) {
            BufferUtils.setInBuffer(this.currColor, this.parent.getColorBuffer(0), this.startIndex + i);
        }
        this.currentSize = this.parent.getStartSize();
        this.currentAge = 0;
        this.spinAngle = 0.0f;
        this.status = 2;
    }

    public void updateVerts(Camera camera) {
        float f = this.parent.getParticleOrientation() + this.spinAngle;
        if (this.type != 4 && this.type != 2) {
            if (camera != null && this.parent.isCameraFacing()) {
                if (this.parent.isVelocityAligned()) {
                    this.bbX.set(this.velocity).normalizeLocal().multLocal(this.currentSize);
                    camera.getDirection().cross(this.bbX, this.bbY).normalizeLocal().multLocal(this.currentSize);
                } else if (f == 0.0f) {
                    this.bbX.set(camera.getLeft()).multLocal(this.currentSize);
                    this.bbY.set(camera.getUp()).multLocal(this.currentSize);
                } else {
                    float f2 = FastMath.cos(f) * this.currentSize;
                    float f3 = FastMath.sin(f) * this.currentSize;
                    this.bbX.set(camera.getLeft()).multLocal(f2).addLocal(camera.getUp().x * f3, camera.getUp().y * f3, camera.getUp().z * f3);
                    this.bbY.set(camera.getLeft()).multLocal(-f3).addLocal(camera.getUp().x * f2, camera.getUp().y * f2, camera.getUp().z * f2);
                }
            } else {
                this.bbX.set(this.parent.getLeftVector()).multLocal(this.currentSize);
                this.bbY.set(this.parent.getUpVector()).multLocal(this.currentSize);
            }
        }
        switch (this.type) {
            case 0: {
                this.position.add(this.bbX, tempVec).subtractLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex);
                this.position.add(this.bbX, tempVec).addLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 1);
                this.position.subtract(this.bbX, tempVec).subtractLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 2);
                this.position.subtract(this.bbX, tempVec).addLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 3);
                break;
            }
            case 4: {
                Vector3f vector3f = this.triModel.getNormal();
                if (f != 0.0f) {
                    tempQuat.fromAngleNormalAxis(f, vector3f);
                }
                for (int i = 0; i < 3; ++i) {
                    if (f != 0.0f) {
                        tempQuat.mult(this.triModel.get(i), tempVec);
                    } else {
                        tempVec.set(this.triModel.get(i));
                    }
                    tempVec.multLocal(this.currentSize).addLocal(this.position);
                    BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + i);
                }
                break;
            }
            case 1: {
                this.position.add(this.bbX, tempVec).subtractLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex);
                this.position.add(this.bbX, tempVec).addLocal(3.0f * this.bbY.x, 3.0f * this.bbY.y, 3.0f * this.bbY.z);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 1);
                this.position.subtract(this.bbX.multLocal(3.0f), tempVec).subtractLocal(this.bbY);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 2);
                break;
            }
            case 3: {
                this.position.subtract(this.bbX, tempVec);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex);
                this.position.add(this.bbX, tempVec);
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + 1);
                break;
            }
            case 2: {
                BufferUtils.setInBuffer(this.position, this.parent.getVertexBuffer(0), this.startIndex);
            }
        }
    }

    public boolean updateAndCheck(float f) {
        int n = ParticleGeometry.getVertsForParticleType(this.type);
        if (this.status != 1) {
            return true;
        }
        this.currentAge = (int)((float)this.currentAge + f * 1000.0f);
        if ((float)this.currentAge > this.lifeSpan) {
            this.status = 0;
            this.currColor.a = 0.0f;
            BufferUtils.populateFromBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex);
            for (int i = 0; i < n; ++i) {
                BufferUtils.setInBuffer(tempVec, this.parent.getVertexBuffer(0), this.startIndex + i);
                BufferUtils.setInBuffer(this.currColor, this.parent.getColorBuffer(0), this.startIndex + i);
            }
            return true;
        }
        this.position.scaleAdd(f * 1000.0f, this.velocity, this.position);
        this.spinAngle += this.parent.getParticleSpinSpeed() * f;
        float f2 = (float)this.currentAge / this.lifeSpan;
        this.currentSize = this.parent.getStartSize();
        this.currentSize -= (this.currentSize - this.parent.getEndSize()) * f2;
        this.currColor.set(this.startColor);
        this.currColor.r -= this.rChange * f2;
        this.currColor.g -= this.gChange * f2;
        this.currColor.b -= this.bChange * f2;
        this.currColor.a -= this.aChange * f2;
        for (int i = 0; i < n; ++i) {
            BufferUtils.setInBuffer(this.currColor, this.parent.getColorBuffer(0), this.startIndex + i);
        }
        return false;
    }

    public void resetAge() {
        this.currentAge = 0;
    }

    public int getCurrentAge() {
        return this.currentAge;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f vector3f) {
        this.position.set(vector3f);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3f vector3f) {
        this.velocity.set(vector3f);
    }

    public ColorRGBA getCurrentColor() {
        return this.currColor;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int n) {
        this.startIndex = n;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
        this.invMass = f == 0.0f ? Float.POSITIVE_INFINITY : (f == Float.POSITIVE_INFINITY ? 0.0f : (f == Float.NEGATIVE_INFINITY ? 0.0f : 1.0f / f));
    }

    public void setMasses(float f, float f2) {
        this.mass = f;
        this.invMass = f2;
    }

    public float getInvMass() {
        return this.invMass;
    }

    public void setTriangleModel(Triangle triangle) {
        this.triModel = triangle;
    }

    public Triangle getTriangleModel() {
        return this.triModel;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.startIndex, "startIndex", 0);
        outputCapsule.write(this.position, "position", Vector3f.ZERO);
        outputCapsule.write(this.startColor, "startColor", ColorRGBA.black);
        outputCapsule.write(this.currColor, "currColor", ColorRGBA.black);
        outputCapsule.write(this.status, "status", 2);
        outputCapsule.write(this.currentSize, "currentSize", 0.0f);
        outputCapsule.write(this.lifeSpan, "lifeSpan", 0.0f);
        outputCapsule.write(this.currentAge, "currentAge", 0);
        outputCapsule.write(this.parent, "parent", null);
        outputCapsule.write(this.velocity, "velocity", Vector3f.UNIT_XYZ);
        outputCapsule.write(this.rChange, "rChange", 0.0f);
        outputCapsule.write(this.gChange, "gChange", 0.0f);
        outputCapsule.write(this.bChange, "bChange", 0.0f);
        outputCapsule.write(this.aChange, "aChange", 0.0f);
        outputCapsule.write(this.mass, "mass", 1.0f);
        outputCapsule.write(this.type, "type", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.startIndex = inputCapsule.readInt("startIndex", 0);
        this.position = (Vector3f)inputCapsule.readSavable("position", Vector3f.ZERO.clone());
        this.startColor = (ColorRGBA)inputCapsule.readSavable("startColor", ColorRGBA.black.clone());
        this.currColor = (ColorRGBA)inputCapsule.readSavable("currColor", ColorRGBA.black.clone());
        this.status = inputCapsule.readInt("status", 2);
        this.currentSize = inputCapsule.readFloat("currentSize", 0.0f);
        this.lifeSpan = inputCapsule.readFloat("lifeSpan", 0.0f);
        this.currentAge = inputCapsule.readInt("currentAge", 0);
        this.parent = (ParticleGeometry)inputCapsule.readSavable("parent", null);
        this.velocity = (Vector3f)inputCapsule.readSavable("velocity", Vector3f.UNIT_XYZ.clone());
        this.rChange = inputCapsule.readFloat("rChange", 0.0f);
        this.gChange = inputCapsule.readFloat("gChange", 0.0f);
        this.bChange = inputCapsule.readFloat("bChange", 0.0f);
        this.aChange = inputCapsule.readFloat("aChange", 0.0f);
        this.setMass(inputCapsule.readFloat("mass", 1.0f));
        this.type = inputCapsule.readInt("type", 0);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

