/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.glsl;

import com.jme.image.Texture;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;

public class SketchRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    private TextureRenderer tRendererDepth;
    private Texture textureDepth;
    private Quad fullScreenQuad;
    private GLSLShaderObjectsState sobelShader;
    private GLSLShaderObjectsState normShader;
    private float normalMult = 0.1f;
    private float depthMult = 6.0f;
    private float off = 0.002f;
    private boolean supported = true;
    protected RenderState[] preStates = new RenderState[17];
    protected static TextureState noTexture;
    protected static LightState noLights;
    protected static MaterialState noMaterials;

    public void resetParameters() {
        this.normalMult = 0.1f;
        this.depthMult = 6.0f;
        this.off = 0.002f;
    }

    public void cleanup() {
        this.tRendererDepth.cleanup();
    }

    public boolean isSupported() {
        return this.supported;
    }

    public SketchRenderPass(Camera camera, int n) {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.resetParameters();
        this.tRendererDepth = displaySystem.createTextureRenderer(displaySystem.getWidth() / n, displaySystem.getHeight() / n, 2);
        this.tRendererDepth.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.tRendererDepth.setCamera(camera);
        this.textureDepth = new Texture();
        this.textureDepth.setWrap(0);
        this.textureDepth.setFilter(1);
        this.tRendererDepth.setupTexture(this.textureDepth);
        this.normShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.normShader.isSupported()) {
            this.supported = false;
        } else {
            this.normShader.load(SketchRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/sketch_norm.vert"), SketchRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/sketch_norm.frag"));
            this.normShader.setEnabled(true);
            this.normShader.setUniform("nearClip", camera.getFrustumNear());
            this.normShader.setUniform("diffClip", camera.getFrustumFar() - camera.getFrustumNear());
        }
        this.sobelShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.sobelShader.isSupported()) {
            this.supported = false;
        } else {
            this.sobelShader.load(SketchRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/sketch_sobel.vert"), SketchRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/sketch_sobel.frag"));
            this.sobelShader.setEnabled(true);
        }
        this.fullScreenQuad = new Quad("FullScreenQuad", displaySystem.getWidth(), displaySystem.getHeight());
        this.fullScreenQuad.getLocalRotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        this.fullScreenQuad.getLocalTranslation().set(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        this.fullScreenQuad.getLocalScale().set(1.0f, 1.0f, 1.0f);
        this.fullScreenQuad.setRenderQueueMode(4);
        this.fullScreenQuad.setCullMode(3);
        this.fullScreenQuad.setTextureCombineMode(5);
        this.fullScreenQuad.setLightCombineMode(0);
        TextureState textureState = displaySystem.getRenderer().createTextureState();
        textureState.setEnabled(true);
        this.fullScreenQuad.setRenderState(textureState);
        this.fullScreenQuad.updateRenderState();
        this.fullScreenQuad.updateGeometricState(0.0f, true);
        noTexture = displaySystem.getRenderer().createTextureState();
        noTexture.setEnabled(false);
        noLights = displaySystem.getRenderer().createLightState();
        noLights.setEnabled(false);
        noMaterials = displaySystem.getRenderer().createMaterialState();
        noMaterials.setEnabled(false);
    }

    public void doRender(Renderer renderer) {
        if (this.spatials.size() != 1) {
            return;
        }
        this.saveEnforcedStates();
        this.context.enforceState(noTexture);
        this.context.enforceState(noLights);
        this.context.enforceState(noMaterials);
        this.context.enforceState(this.normShader);
        this.tRendererDepth.render((Spatial)this.spatials.get(0), this.textureDepth);
        this.replaceEnforcedStates();
        TextureState textureState = (TextureState)this.fullScreenQuad.getRenderState(6);
        this.sobelShader.clearUniforms();
        this.sobelShader.setUniform("depth", 0);
        this.sobelShader.setUniform("normalMult", this.getNormalMult());
        this.sobelShader.setUniform("depthMult", this.getDepthMult());
        this.sobelShader.setUniform("off", this.getOff());
        textureState.setTexture(this.textureDepth, 0);
        this.fullScreenQuad.setRenderState(this.sobelShader);
        this.fullScreenQuad.updateRenderState();
        renderer.draw(this.fullScreenQuad);
    }

    protected void saveEnforcedStates() {
        int n = 17;
        while (--n >= 0) {
            this.preStates[n] = this.context.enforcedStateList[n];
        }
    }

    protected void replaceEnforcedStates() {
        int n = 17;
        while (--n >= 0) {
            this.context.enforcedStateList[n] = this.preStates[n];
        }
    }

    public float getNormalMult() {
        return this.normalMult;
    }

    public void setNormalMult(float f) {
        this.normalMult = f;
    }

    public float getDepthMult() {
        return this.depthMult;
    }

    public void setDepthMult(float f) {
        this.depthMult = f;
    }

    public float getOff() {
        return this.off;
    }

    public void setOff(float f) {
        this.off = f;
    }
}

