/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.glsl;

import com.jme.image.Texture;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;

public class BloomRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    private float throttle = 0.02f;
    private float sinceLast = 1.0f;
    private TextureRenderer tRenderer;
    private Texture mainTexture;
    private Texture secondTexture;
    private Texture screenTexture;
    private Quad fullScreenQuad;
    private TriangleBatch fullScreenQuadBatch;
    private GLSLShaderObjectsState extractionShader;
    private GLSLShaderObjectsState blurShader;
    private GLSLShaderObjectsState finalShader;
    private int nrBlurPasses;
    private float blurSize;
    private float blurIntensityMultiplier;
    private float exposurePow;
    private float exposureCutoff;
    private boolean supported = true;
    private boolean useCurrentScene = false;
    public static String shaderDirectory = "com/jmex/effects/glsl/data/";
    private final SpatialsRenderNode spatialsRenderNode = new SpatialsRenderNode();

    public void resetParameters() {
        this.nrBlurPasses = 2;
        this.blurSize = 0.02f;
        this.blurIntensityMultiplier = 1.3f;
        this.exposurePow = 3.0f;
        this.exposureCutoff = 0.0f;
    }

    public void cleanup() {
        super.cleanUp();
        if (this.tRenderer != null) {
            this.tRenderer.cleanup();
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    public BloomRenderPass(Camera camera, int n) {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.resetParameters();
        this.tRenderer = displaySystem.createTextureRenderer(displaySystem.getWidth() / n, displaySystem.getHeight() / n, 2);
        if (!this.tRenderer.isSupported()) {
            this.supported = false;
            return;
        }
        this.tRenderer.setMultipleTargets(true);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.tRenderer.setCamera(camera);
        this.mainTexture = new Texture();
        this.mainTexture.setWrap(0);
        this.mainTexture.setFilter(1);
        this.tRenderer.setupTexture(this.mainTexture);
        this.secondTexture = new Texture();
        this.secondTexture.setWrap(0);
        this.secondTexture.setFilter(1);
        this.tRenderer.setupTexture(this.secondTexture);
        this.screenTexture = new Texture();
        this.screenTexture.setWrap(0);
        this.screenTexture.setFilter(1);
        this.tRenderer.setupTexture(this.screenTexture);
        this.extractionShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.extractionShader.isSupported()) {
            this.supported = false;
            return;
        }
        this.extractionShader.load(BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_extract.vert"), BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_extract.frag"));
        this.extractionShader.setEnabled(true);
        this.extractionShader.setUniform("RT", 0);
        this.blurShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.blurShader.isSupported()) {
            this.supported = false;
            return;
        }
        this.blurShader.load(BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_blur.vert"), BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_blur.frag"));
        this.blurShader.setEnabled(true);
        this.blurShader.setUniform("RT", 0);
        this.finalShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.finalShader.isSupported()) {
            this.supported = false;
            return;
        }
        this.finalShader.load(BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_final.vert"), BloomRenderPass.class.getClassLoader().getResource(shaderDirectory + "bloom_final.frag"));
        this.finalShader.setEnabled(true);
        this.fullScreenQuad = new Quad("FullScreenQuad", displaySystem.getWidth() / 4, displaySystem.getHeight() / 4);
        this.fullScreenQuadBatch = this.fullScreenQuad.getBatch(0);
        this.fullScreenQuad.getLocalRotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        this.fullScreenQuad.getLocalTranslation().set(displaySystem.getWidth() / 2, displaySystem.getHeight() / 2, 0.0f);
        this.fullScreenQuad.getLocalScale().set(1.0f, 1.0f, 1.0f);
        this.fullScreenQuad.setRenderQueueMode(4);
        this.fullScreenQuad.setCullMode(3);
        this.fullScreenQuad.setTextureCombineMode(5);
        this.fullScreenQuad.setLightCombineMode(0);
        TextureState textureState = displaySystem.getRenderer().createTextureState();
        textureState.setEnabled(true);
        this.fullScreenQuadBatch.setRenderState(textureState);
        AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(1);
        alphaState.setDstFunction(1);
        alphaState.setEnabled(true);
        this.fullScreenQuadBatch.setRenderState(alphaState);
        this.fullScreenQuad.updateRenderState();
        this.fullScreenQuad.updateGeometricState(0.0f, true);
    }

    protected void doUpdate(float f) {
        super.doUpdate(f);
        this.sinceLast += f;
    }

    public void doRender(Renderer renderer) {
        if (!this.useCurrentScene && this.spatials.size() == 0) {
            return;
        }
        AlphaState alphaState = (AlphaState)this.fullScreenQuadBatch.states[0];
        if (this.sinceLast > this.throttle) {
            this.sinceLast = 0.0f;
            alphaState.setEnabled(false);
            TextureState textureState = (TextureState)this.fullScreenQuadBatch.states[6];
            if (this.useCurrentScene) {
                this.tRenderer.copyToTexture(this.screenTexture, DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight());
                textureState.setTexture(this.screenTexture, 0);
            } else {
                this.tRenderer.render(this.spatialsRenderNode, this.mainTexture);
                textureState.setTexture(this.mainTexture, 0);
            }
            this.extractionShader.setUniform("exposurePow", this.getExposurePow());
            this.extractionShader.setUniform("exposureCutoff", this.getExposureCutoff());
            this.fullScreenQuadBatch.states[14] = this.extractionShader;
            this.tRenderer.render(this.fullScreenQuad, this.secondTexture);
            this.blurShader.setUniform("sampleDist0", this.getBlurSize());
            this.blurShader.setUniform("blurIntensityMultiplier", this.getBlurIntensityMultiplier());
            textureState.setTexture(this.secondTexture, 0);
            this.fullScreenQuadBatch.states[14] = this.blurShader;
            this.tRenderer.render(this.fullScreenQuad, this.mainTexture);
            for (int i = 1; i < this.getNrBlurPasses(); ++i) {
                if (i % 2 == 1) {
                    textureState.setTexture(this.mainTexture, 0);
                    this.tRenderer.render(this.fullScreenQuad, this.secondTexture);
                    continue;
                }
                textureState.setTexture(this.secondTexture, 0);
                this.tRenderer.render(this.fullScreenQuad, this.mainTexture);
            }
            if (this.getNrBlurPasses() % 2 == 1) {
                textureState.setTexture(this.mainTexture, 0);
            } else {
                textureState.setTexture(this.secondTexture, 0);
            }
        }
        alphaState.setEnabled(true);
        this.fullScreenQuadBatch.states[14] = this.finalShader;
        renderer.draw(this.fullScreenQuadBatch);
    }

    public float getThrottle() {
        return this.throttle;
    }

    public void setThrottle(float f) {
        this.throttle = f;
    }

    public float getBlurSize() {
        return this.blurSize;
    }

    public void setBlurSize(float f) {
        this.blurSize = f;
    }

    public float getExposurePow() {
        return this.exposurePow;
    }

    public void setExposurePow(float f) {
        this.exposurePow = f;
    }

    public float getExposureCutoff() {
        return this.exposureCutoff;
    }

    public void setExposureCutoff(float f) {
        this.exposureCutoff = f;
    }

    public float getBlurIntensityMultiplier() {
        return this.blurIntensityMultiplier;
    }

    public void setBlurIntensityMultiplier(float f) {
        this.blurIntensityMultiplier = f;
    }

    public int getNrBlurPasses() {
        return this.nrBlurPasses;
    }

    public void setNrBlurPasses(int n) {
        this.nrBlurPasses = n;
    }

    public boolean useCurrentScene() {
        return this.useCurrentScene;
    }

    public void setUseCurrentScene(boolean bl) {
        this.useCurrentScene = bl;
    }

    private class SpatialsRenderNode
    extends Node {
        private static final long serialVersionUID = 7367501683137581101L;

        private SpatialsRenderNode() {
        }

        public void draw(Renderer renderer) {
            int n = BloomRenderPass.this.spatials.size();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = (Spatial)BloomRenderPass.this.spatials.get(i);
                if (spatial == null) continue;
                spatial.onDraw(renderer);
            }
        }

        public void onDraw(Renderer renderer) {
            this.draw(renderer);
        }
    }
}

