/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.cloth;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.CollisionTree;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.CollisionData;
import com.jme.intersection.TriangleCollisionResults;
import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPoint;
import com.jme.scene.TriMesh;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.cloth.ClothPatch;
import java.io.IOException;
import java.util.ArrayList;

public class CollidingClothPatch
extends ClothPatch {
    private static final long serialVersionUID = 1L;
    protected TriangleCollisionResults results;
    protected ArrayList<TriMesh> colliders;
    protected SpringPoint[] srcTemps = new SpringPoint[3];
    protected Vector3f calcTemp = new Vector3f();
    private CollisionTree collisionTree;
    private boolean sortTree;

    public CollidingClothPatch(String string, int n, int n2, float f, float f2) {
        super(string, n, n2, f, f2);
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        this.results = new TriangleCollisionResults();
        this.colliders = new ArrayList();
    }

    public void setCollisionTree(CollisionTree collisionTree) {
        this.collisionTree = collisionTree;
    }

    protected void calcForces(float f) {
        super.calcForces(f);
        this.updateModelBound();
        CollisionTreeManager.getInstance().updateCollisionTree(this);
        this.checkForCollisions();
    }

    protected void checkForCollisions() {
        int n = this.colliders.size();
        while (--n >= 0) {
            this.results.clear();
            this.findCollisions(this.colliders.get(n), this.results);
            int n2 = this.results.getNumber();
            while (--n2 >= 0) {
                CollisionData collisionData = this.results.getCollisionData(n2);
                for (int i = 0; i < collisionData.getSourceTris().size(); ++i) {
                    int n3 = collisionData.getSourceTris().get(i);
                    int n4 = collisionData.getTargetTris().get(i);
                    this.handleCollision((TriMesh)collisionData.getTargetMesh(), n3, n4);
                }
            }
        }
    }

    protected void handleCollision(TriMesh triMesh, int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            this.srcTemps[i] = this.system.getNode(this.getBatch(0).getIndexBuffer().get(n * 3 + i));
            if (this.srcTemps[i].invMass != 0.0f) {
                BufferUtils.populateFromBuffer(this.srcTemps[i].position, triMesh.getVertexBuffer(0), triMesh.getIndexBuffer(0).get(n2 * 3 + i));
            }
            this.srcTemps[i].acceleration.multLocal(0.8f);
        }
    }

    public void addCollider(TriMesh triMesh) {
        this.colliders.add(triMesh);
    }

    public boolean removeCollider(TriMesh triMesh) {
        return this.colliders.remove(triMesh);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.colliders, "colliders", new ArrayList());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.colliders = inputCapsule.readSavableArrayList("colliders", new ArrayList());
    }

    public void setSortTree(boolean bl) {
        this.sortTree = bl;
    }
}

