/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.settings;

import com.jme.system.GameSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSettingsPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(GameSettingsPanel.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int[][] RESOLUTIONS = new int[][]{{640, 480}, {800, 600}, {1024, 768}, {1280, 1024}, {1440, 900}, {1600, 1024}, {1600, 1200}, {1920, 1200}};
    public static final int[] DEPTHS = new int[]{16, 24, 32};
    private GameSettings settings;
    private DisplayMode[] allModes;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private JComboBox renderer;
    private JComboBox resolution;
    private JComboBox depth;
    private JComboBox frequency;
    private JComboBox verticalSync;
    private JComboBox fullscreen;
    private JComboBox music;
    private JComboBox sfx;
    private JComboBox depthBits;
    private JComboBox alphaBits;
    private JComboBox stencilBits;
    private JComboBox samples;
    private HashMap<String, JComboBox> map;
    private HashMap<String, Object> defaults;
    private static boolean ok;

    public GameSettingsPanel(GameSettings gameSettings) {
        this.settings = gameSettings;
        try {
            this.allModes = Display.getAvailableDisplayModes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.map = new HashMap();
        this.defaults = new HashMap();
        this.init();
    }

    private void init() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.constraints = new GridBagConstraints();
        List<Component> list = this.getSettingsComponents();
        this.revert();
        JLabel jLabel = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component = list.get(i);
            jLabel = new JLabel(" " + component.getName() + ": ");
            jLabel.setHorizontalAlignment(4);
            this.constraints.gridwidth = 1;
            this.constraints.anchor = 13;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            this.layout.setConstraints(jLabel, this.constraints);
            this.add(jLabel);
            this.constraints.anchor = 17;
            this.constraints.gridwidth = 0;
            this.layout.setConstraints(component, this.constraints);
            this.add(component);
        }
    }

    public void addSetting(String string, Object[] objectArray, Object object) {
        object = this.settings.getObject(string, object);
        logger.info("Default Choice for " + string + " = " + object);
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setName(string);
        jComboBox.setSelectedItem(object);
        JLabel jLabel = new JLabel(" " + jComboBox.getName() + ": ");
        jLabel.setHorizontalAlignment(4);
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.layout.setConstraints(jLabel, this.constraints);
        this.add(jLabel);
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 0;
        this.layout.setConstraints(jComboBox, this.constraints);
        this.add(jComboBox);
        this.map.put(string, jComboBox);
        this.defaults.put(string, object);
    }

    protected List<Component> getSettingsComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(this.createRenderer());
        arrayList.add(this.createResolution());
        arrayList.add(this.createDepth());
        arrayList.add(this.createFrequency());
        arrayList.add(this.createVerticalSync());
        arrayList.add(this.createFullscreen());
        arrayList.add(this.createMusic());
        arrayList.add(this.createSFX());
        arrayList.add(this.createDepthBits());
        arrayList.add(this.createAlphaBits());
        arrayList.add(this.createStencilBits());
        arrayList.add(this.createSamples());
        return arrayList;
    }

    protected Component createRenderer() {
        this.renderer = new JComboBox<Object>(new Object[]{"LWJGL"});
        this.renderer.setName("Renderer");
        return this.renderer;
    }

    protected Component createResolution() {
        this.resolution = new JComboBox<Object>(GameSettingsPanel.getResolutionArray());
        this.resolution.setName("Resolution");
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String[] stringArray = ((String)GameSettingsPanel.this.resolution.getSelectedItem()).split("x");
                GameSettingsPanel.this.setMenuOptions(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
        };
        this.resolution.addItemListener(itemListener);
        return this.resolution;
    }

    protected Component createDepth() {
        this.depth = new JComboBox<Object>(GameSettingsPanel.getDepthArray());
        this.depth.setName("Depth");
        return this.depth;
    }

    public void setMenuOptions(int n, int n2) {
        Vector<DisplayMode> vector = GameSettingsPanel.getAvailableModesRes(this.allModes, n, n2);
        this.depth.removeAllItems();
        this.frequency.removeAllItems();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (DisplayMode object : vector) {
            hashSet.add(String.valueOf(object.getBitsPerPixel()));
            hashSet2.add(String.valueOf(object.getFrequency()));
        }
        for (String string : hashSet) {
            this.depth.addItem(string);
        }
        for (String string : hashSet2) {
            this.frequency.addItem(string);
        }
        this.depth.updateUI();
        this.frequency.updateUI();
    }

    public static Vector<DisplayMode> getAvailableModesRes(DisplayMode[] displayModeArray, int n, int n2) {
        Vector<DisplayMode> vector = new Vector<DisplayMode>();
        for (int[] nArray : RESOLUTIONS) {
            if (nArray[0] != n || nArray[1] != n2) continue;
            for (DisplayMode displayMode : displayModeArray) {
                if (displayMode.getHeight() != n2 || displayMode.getWidth() != n) continue;
                vector.add(displayMode);
            }
        }
        return vector;
    }

    public static Object[] getResolutionArray() {
        Object[] objectArray = new Object[RESOLUTIONS.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = RESOLUTIONS[i][0] + "x" + RESOLUTIONS[i][1];
        }
        return objectArray;
    }

    public static Object[] getDepthArray() {
        Object[] objectArray = new Object[DEPTHS.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = String.valueOf(DEPTHS[i]);
        }
        return objectArray;
    }

    protected Component createFrequency() {
        this.frequency = new JComboBox<Object>(new Object[]{"60", "70", "72", "75", "85", "100", "120", "140"});
        this.frequency.setName("Frequency");
        return this.frequency;
    }

    protected Component createVerticalSync() {
        this.verticalSync = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.verticalSync.setName("Vertical Sync");
        return this.verticalSync;
    }

    protected Component createFullscreen() {
        this.fullscreen = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.fullscreen.setName("Fullscreen");
        return this.fullscreen;
    }

    protected Component createMusic() {
        this.music = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.music.setName("Music");
        return this.music;
    }

    protected Component createSFX() {
        this.sfx = new JComboBox<Object>(new Object[]{"Yes", "No"});
        this.sfx.setName("Sound Effects");
        return this.sfx;
    }

    protected Component createDepthBits() {
        this.depthBits = new JComboBox<Object>(new Object[]{"8"});
        this.depthBits.setName("Depth Bits");
        return this.depthBits;
    }

    protected Component createAlphaBits() {
        this.alphaBits = new JComboBox<Object>(new Object[]{"0"});
        this.alphaBits.setName("Alpha Bits");
        return this.alphaBits;
    }

    protected Component createStencilBits() {
        this.stencilBits = new JComboBox<Object>(new Object[]{"0"});
        this.stencilBits.setName("Stencil Bits");
        return this.stencilBits;
    }

    protected Component createSamples() {
        this.samples = new JComboBox<Object>(new Object[]{"0"});
        this.samples.setName("Samples");
        return this.samples;
    }

    public void defaults() {
        try {
            this.settings.clear();
            this.revert();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "defaults()", "Exception", exception);
        }
    }

    public void revert() {
        this.renderer.setSelectedItem(this.settings.getRenderer());
        this.resolution.setSelectedItem(this.settings.getWidth() + "x" + this.settings.getHeight());
        this.depth.setSelectedItem(String.valueOf(this.settings.getDepth()));
        this.frequency.setSelectedItem(String.valueOf(this.settings.getFrequency()));
        this.verticalSync.setSelectedItem(this.settings.isVerticalSync() ? "Yes" : "No");
        this.fullscreen.setSelectedItem(this.settings.isFullscreen() ? "Yes" : "No");
        this.music.setSelectedItem(this.settings.isMusic() ? "Yes" : "No");
        this.sfx.setSelectedItem(this.settings.isSFX() ? "Yes" : "No");
        this.depthBits.setSelectedItem(String.valueOf(this.settings.getDepthBits()));
        this.alphaBits.setSelectedItem(String.valueOf(this.settings.getAlphaBits()));
        this.stencilBits.setSelectedItem(String.valueOf(this.settings.getStencilBits()));
        this.samples.setSelectedItem(String.valueOf(this.settings.getSamples()));
        for (String string : this.map.keySet()) {
            JComboBox jComboBox = this.map.get(string);
            jComboBox.setSelectedItem(this.settings.getObject(string, this.defaults.get(string)));
        }
    }

    public void apply() {
        this.settings.setRenderer((String)this.renderer.getSelectedItem());
        String[] stringArray = ((String)this.resolution.getSelectedItem()).split("x");
        this.settings.setWidth(Integer.parseInt(stringArray[0]));
        this.settings.setHeight(Integer.parseInt(stringArray[1]));
        this.settings.setDepth(Integer.parseInt((String)this.depth.getSelectedItem()));
        this.settings.setFrequency(Integer.parseInt((String)this.frequency.getSelectedItem()));
        this.settings.setVerticalSync(this.verticalSync.getSelectedItem().equals("Yes"));
        this.settings.setFullscreen(this.fullscreen.getSelectedItem().equals("Yes"));
        this.settings.setMusic(this.music.getSelectedItem().equals("Yes"));
        this.settings.setSFX(this.sfx.getSelectedItem().equals("Yes"));
        this.settings.setDepthBits(Integer.parseInt((String)this.depthBits.getSelectedItem()));
        this.settings.setAlphaBits(Integer.parseInt((String)this.alphaBits.getSelectedItem()));
        this.settings.setStencilBits(Integer.parseInt((String)this.stencilBits.getSelectedItem()));
        this.settings.setSamples(Integer.parseInt((String)this.samples.getSelectedItem()));
        for (String string : this.map.keySet()) {
            this.settings.setObject(string, this.map.get(string).getSelectedItem());
        }
    }

    public boolean validateDisplay() {
        if (this.depth.getSelectedItem() == null) {
            return false;
        }
        return this.frequency.getSelectedItem() != null;
    }

    public static final boolean prompt(GameSettings gameSettings) throws InterruptedException {
        return GameSettingsPanel.prompt(gameSettings, "Game Settings");
    }

    public static final boolean prompt(GameSettings gameSettings, String string) throws InterruptedException {
        final JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setAlwaysOnTop(true);
        final GameSettingsPanel gameSettingsPanel = new GameSettingsPanel(gameSettings);
        ok = false;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if ("Defaults".equals(jButton.getText())) {
                    gameSettingsPanel.defaults();
                } else if ("Revert".equals(jButton.getText())) {
                    gameSettingsPanel.revert();
                } else if ("OK".equals(jButton.getText())) {
                    if (gameSettingsPanel.validateDisplay()) {
                        ok = true;
                        gameSettingsPanel.apply();
                        jFrame.dispose();
                    } else {
                        JOptionPane.showMessageDialog(jFrame, "Invalid display configuration combination", "Invalid Settings", 0);
                    }
                } else if ("Cancel".equals(jButton.getText())) {
                    jFrame.dispose();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Defaults");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("Revert");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("OK");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jFrame.getRootPane().setDefaultButton(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", gameSettingsPanel);
        container.add("South", jPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        while (jFrame.isVisible()) {
            Thread.sleep(50L);
        }
        return ok;
    }
}

