/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jmex.editors.swing.particles.InfluenceEditPanel;
import com.jmex.editors.swing.widget.SphericalUnitVectorPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import com.jmex.effects.particles.SimpleParticleInfluenceFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindInfluencePanel
extends InfluenceEditPanel {
    private static final long serialVersionUID = 1L;
    private ValuePanel windStrengthPanel = new ValuePanel("Strength: ", "", 0.0f, 100.0f, 0.1f);
    private SphericalUnitVectorPanel windDirectionPanel = new SphericalUnitVectorPanel();
    private JCheckBox windRandomBox;

    public WindInfluencePanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.windDirectionPanel.setBorder(this.createTitledBorder(" DIRECTION "));
        this.windDirectionPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicWind)WindInfluencePanel.this.getEdittedInfluence()).setWindDirection(WindInfluencePanel.this.windDirectionPanel.getValue());
            }
        });
        this.windStrengthPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicWind)WindInfluencePanel.this.getEdittedInfluence()).setStrength(WindInfluencePanel.this.windStrengthPanel.getFloatValue());
            }
        });
        this.windRandomBox = new JCheckBox(new AbstractAction("Vary Randomly"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ((SimpleParticleInfluenceFactory.BasicWind)WindInfluencePanel.this.getEdittedInfluence()).setRandom(WindInfluencePanel.this.windRandomBox.isSelected());
            }
        });
        this.setBorder(this.createTitledBorder(" WIND PARAMETERS "));
        this.add((Component)this.windDirectionPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.windStrengthPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.windRandomBox, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 5, 10, 5), 0, 0));
    }

    public void updateWidgets() {
        SimpleParticleInfluenceFactory.BasicWind basicWind = (SimpleParticleInfluenceFactory.BasicWind)this.getEdittedInfluence();
        this.windDirectionPanel.setValue(basicWind.getWindDirection());
        this.windStrengthPanel.setValue(basicWind.getStrength());
        this.windRandomBox.setSelected(basicWind.isRandom());
    }
}

