/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jme.math.Line;
import com.jme.math.Vector3f;
import com.jmex.editors.swing.particles.DragInfluencePanel;
import com.jmex.editors.swing.particles.GravityInfluencePanel;
import com.jmex.editors.swing.particles.ParticleEditPanel;
import com.jmex.editors.swing.particles.SwarmInfluencePanel;
import com.jmex.editors.swing.particles.VortexInfluencePanel;
import com.jmex.editors.swing.particles.WanderInfluencePanel;
import com.jmex.editors.swing.particles.WindInfluencePanel;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import com.jmex.effects.particles.SimpleParticleInfluenceFactory;
import com.jmex.effects.particles.SwarmInfluence;
import com.jmex.effects.particles.WanderInfluence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParticleInfluencePanel
extends ParticleEditPanel {
    private static final long serialVersionUID = 1L;
    private InfluenceListModel influenceModel = new InfluenceListModel();
    private JList influenceList = new JList(this.influenceModel);
    private JButton deleteInfluenceButton;
    private JPanel influenceParamsPanel;

    public ParticleInfluencePanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.influenceList.setSelectionMode(0);
        this.influenceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ParticleInfluencePanel.this.influenceList.getSelectedIndex();
                ParticleInfluencePanel.this.deleteInfluenceButton.setEnabled(n != -1);
                ParticleInfluencePanel.this.updateInfluenceParams();
            }
        });
        JButton jButton = new JButton(new AbstractAction("Add Influence"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleInfluence particleInfluence = this.getNewInfluence();
                if (particleInfluence != null) {
                    ParticleInfluencePanel.this.getEdittedParticles().addInfluence(particleInfluence);
                    int n = ParticleInfluencePanel.this.getEdittedParticles().getInfluences().size() - 1;
                    ParticleInfluencePanel.this.influenceModel.fireIntervalAdded(n, n);
                    ParticleInfluencePanel.this.influenceList.setSelectedIndex(n);
                }
            }

            private ParticleInfluence getNewInfluence() {
                Object object = JOptionPane.showInputDialog(ParticleInfluencePanel.this, "Choose the influence type to add:", "Add Influence", 2, null, new String[]{"wind", "gravity", "drag", "vortex", "swarm", "wander"}, null);
                ParticleInfluence particleInfluence = null;
                if ("wind".equals(object)) {
                    particleInfluence = SimpleParticleInfluenceFactory.createBasicWind(1.0f, Vector3f.UNIT_X.clone(), true, true);
                } else if ("gravity".equals(object)) {
                    particleInfluence = SimpleParticleInfluenceFactory.createBasicGravity(Vector3f.ZERO.clone(), true);
                } else if ("drag".equals(object)) {
                    particleInfluence = SimpleParticleInfluenceFactory.createBasicDrag(1.0f);
                } else if ("vortex".equals(object)) {
                    particleInfluence = SimpleParticleInfluenceFactory.createBasicVortex(1.0f, 0.0f, new Line(new Vector3f(), Vector3f.UNIT_Y.clone()), true, true);
                } else if ("swarm".equals(object)) {
                    particleInfluence = new SwarmInfluence(new Vector3f(), 3.0f);
                } else if ("wander".equals(object)) {
                    particleInfluence = new WanderInfluence();
                }
                return particleInfluence;
            }
        });
        jButton.setMargin(new Insets(2, 2, 2, 2));
        this.deleteInfluenceButton = new JButton(new AbstractAction("Delete"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ParticleInfluencePanel.this.influenceList.getSelectedIndex();
                ParticleInfluencePanel.this.getEdittedParticles().getInfluences().remove(n);
                ParticleInfluencePanel.this.influenceModel.fireIntervalRemoved(n, n);
                ParticleInfluencePanel.this.influenceList.setSelectedIndex(n >= ParticleInfluencePanel.this.getEdittedParticles().getInfluences().size() ? n - 1 : n);
            }
        });
        this.deleteInfluenceButton.setMargin(new Insets(2, 2, 2, 2));
        this.deleteInfluenceButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder("PARTICLE INFLUENCES"));
        jPanel.add((Component)this.influenceList, new GridBagConstraints(0, 0, 1, 3, 0.5, 0.0, 10, 1, new Insets(5, 10, 10, 5), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.deleteInfluenceButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.influenceParamsPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 10, 10, 5), 0, 0));
        this.add((Component)this.influenceParamsPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 11, 2, new Insets(5, 10, 10, 5), 0, 0));
    }

    public void updateWidgets() {
        this.influenceList.clearSelection();
        int n = this.getEdittedParticles().getInfluences() == null ? 0 : this.getEdittedParticles().getInfluences().size();
        this.influenceModel.fireContentsChanged(0, n - 1);
    }

    private void updateInfluenceParams() {
        this.influenceParamsPanel.removeAll();
        int n = this.influenceList.getSelectedIndex();
        if (n == -1) {
            this.influenceParamsPanel.validate();
            return;
        }
        ParticleInfluence particleInfluence = this.getEdittedParticles().getInfluences().get(n);
        if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicWind) {
            WindInfluencePanel windInfluencePanel = new WindInfluencePanel();
            windInfluencePanel.setEdittedInfluence(particleInfluence);
            windInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(windInfluencePanel);
        } else if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicGravity) {
            GravityInfluencePanel gravityInfluencePanel = new GravityInfluencePanel();
            gravityInfluencePanel.setEdittedInfluence(particleInfluence);
            gravityInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(gravityInfluencePanel);
        } else if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicDrag) {
            DragInfluencePanel dragInfluencePanel = new DragInfluencePanel();
            dragInfluencePanel.setEdittedInfluence(particleInfluence);
            dragInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(dragInfluencePanel);
        } else if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicVortex) {
            VortexInfluencePanel vortexInfluencePanel = new VortexInfluencePanel();
            vortexInfluencePanel.setEdittedInfluence(particleInfluence);
            vortexInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(vortexInfluencePanel);
        } else if (particleInfluence instanceof SwarmInfluence) {
            SwarmInfluencePanel swarmInfluencePanel = new SwarmInfluencePanel();
            swarmInfluencePanel.setEdittedInfluence(particleInfluence);
            swarmInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(swarmInfluencePanel);
        } else if (particleInfluence instanceof WanderInfluence) {
            WanderInfluencePanel wanderInfluencePanel = new WanderInfluencePanel();
            wanderInfluencePanel.setEdittedInfluence(particleInfluence);
            wanderInfluencePanel.updateWidgets();
            this.influenceParamsPanel.add(wanderInfluencePanel);
        }
        this.influenceParamsPanel.getParent().validate();
        this.influenceParamsPanel.getParent().repaint();
    }

    class InfluenceListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;

        InfluenceListModel() {
        }

        public int getSize() {
            ParticleGeometry particleGeometry = ParticleInfluencePanel.this.getEdittedParticles();
            return particleGeometry == null || particleGeometry.getInfluences() == null ? 0 : particleGeometry.getInfluences().size();
        }

        public Object getElementAt(int n) {
            ParticleInfluence particleInfluence = ParticleInfluencePanel.this.getEdittedParticles().getInfluences().get(n);
            if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicWind) {
                return "Wind";
            }
            if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicGravity) {
                return "Gravity";
            }
            if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicDrag) {
                return "Drag";
            }
            if (particleInfluence instanceof SimpleParticleInfluenceFactory.BasicVortex) {
                return "Vortex";
            }
            if (particleInfluence instanceof SwarmInfluence) {
                return "Swarm";
            }
            if (particleInfluence instanceof WanderInfluence) {
                return "Wander";
            }
            return "???";
        }

        public void fireContentsChanged(int n, int n2) {
            super.fireContentsChanged(this, n, n2);
        }

        public void fireIntervalAdded(int n, int n2) {
            super.fireIntervalAdded(this, n, n2);
        }

        public void fireIntervalRemoved(int n, int n2) {
            super.fireIntervalRemoved(this, n, n2);
        }
    }
}

