/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jmex.editors.swing.particles.ParticleEditPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import com.jmex.editors.swing.widget.ValueSpinner;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import com.jmex.effects.particles.ParticlePoints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ParticleAppearancePanel
extends ParticleEditPanel {
    private static final Logger logger = Logger.getLogger(ParticleAppearancePanel.class.getName());
    private static final long serialVersionUID = 1L;
    private static File newTexture = null;
    private JCheckBox additiveBlendingBox;
    private JColorChooser colorChooser = new JColorChooser();
    private JDialog colorChooserDialog = new JDialog((Frame)null, "Choose a color:");
    private boolean colorstart = false;
    private JLabel countLabel;
    private ValueSpinner endAlphaSpinner = new ValueSpinner(0, 255, 1);
    private JLabel endColorHex = new JLabel();
    private JPanel endColorPanel = new JPanel();
    private ValuePanel endSizePanel = new ValuePanel("End Size: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private JComboBox geomTypeBox;
    private JCheckBox velocityAlignedBox;
    private JLabel imageLabel = new JLabel();
    private Preferences prefs;
    private ValueSpinner startAlphaSpinner = new ValueSpinner(0, 255, 1);
    private JLabel startColorHex = new JLabel();
    private JPanel startColorPanel = new JPanel();
    private ValuePanel startSizePanel = new ValuePanel("Start Size: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private JFileChooser textureChooser = new JFileChooser();
    private JPanel texturePanel;
    private JComboBox renderQueueCB;

    public ParticleAppearancePanel(Preferences preferences) {
        this.prefs = preferences;
        this.setLayout(new GridBagLayout());
        this.initPanel();
        this.setColorChooserDialogOwner(null);
        this.initTextureChooser();
    }

    private void initPanel() {
        this.countLabel = this.createBoldLabel("Particles: 300");
        JButton jButton = new JButton(new AbstractAction("Change..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.countButton_actionPerformed(actionEvent);
            }
        });
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setMargin(new Insets(2, 2, 2, 2));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder("PARTICLE COUNT"));
        jPanel.add((Component)this.countLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.geomTypeBox = new JComboBox<String>(new String[]{"Quad", "Triangle", "Point", "Line"});
        this.geomTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.changeParticleType(ParticleAppearancePanel.this.geomTypeBox.getSelectedIndex());
            }
        });
        this.velocityAlignedBox = new JCheckBox(new AbstractAction("Align with Velocity"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().setVelocityAligned(ParticleAppearancePanel.this.velocityAlignedBox.isSelected());
            }
        });
        this.velocityAlignedBox.setFont(new Font("Arial", 1, 13));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(this.createTitledBorder("PARTICLE GEOMETRY"));
        jPanel2.add((Component)this.createBoldLabel("Type:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.geomTypeBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.velocityAlignedBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel = this.createBoldLabel("Starting Color:");
        JLabel jLabel2 = this.createBoldLabel(">>");
        JLabel jLabel3 = this.createBoldLabel("End Color:");
        JLabel jLabel4 = new JLabel("A:");
        JLabel jLabel5 = new JLabel("A:");
        this.startColorHex.setFont(new Font("Arial", 0, 10));
        this.startColorHex.setText("#FFFFFF");
        this.endColorHex.setFont(new Font("Arial", 0, 10));
        this.endColorHex.setText("#FFFFFF");
        this.startColorPanel.setBackground(Color.white);
        this.startColorPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.startColorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ParticleAppearancePanel.this.startColorPanel_mouseClicked(mouseEvent);
            }
        });
        this.endColorPanel.setBackground(Color.white);
        this.endColorPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.endColorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ParticleAppearancePanel.this.endColorPanel_mouseClicked(mouseEvent);
            }
        });
        this.startAlphaSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().getStartColor().a = (float)((Number)ParticleAppearancePanel.this.startAlphaSpinner.getValue()).intValue() / 255.0f;
            }
        });
        this.endAlphaSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().getEndColor().a = (float)((Number)ParticleAppearancePanel.this.endAlphaSpinner.getValue()).intValue() / 255.0f;
            }
        });
        this.additiveBlendingBox = new JCheckBox(new AbstractAction("Additive Blending"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.updateAlphaState(ParticleAppearancePanel.this.additiveBlendingBox.isSelected());
            }
        });
        this.additiveBlendingBox.setFont(new Font("Arial", 1, 13));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(this.createTitledBorder("PARTICLE COLOR"));
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        jPanel3.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jLabel3, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        jPanel3.add((Component)this.startColorPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 25, 25));
        jPanel3.add((Component)this.endColorPanel, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 25, 25));
        jPanel3.add((Component)this.startColorHex, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel3.add((Component)this.endColorHex, new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
        jPanel3.add((Component)this.startAlphaSpinner, new GridBagConstraints(1, 3, 1, 1, 0.25, 0.0, 17, 0, new Insets(0, 0, 0, 0), 20, 0));
        jPanel3.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.25, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel5, new GridBagConstraints(3, 3, 1, 1, 0.25, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.endAlphaSpinner, new GridBagConstraints(4, 3, 1, 1, 0.25, 0.0, 17, 0, new Insets(0, 0, 0, 0), 20, 0));
        jPanel3.add((Component)this.additiveBlendingBox, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.startSizePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().setStartSize(ParticleAppearancePanel.this.startSizePanel.getFloatValue());
            }
        });
        this.endSizePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().setEndSize(ParticleAppearancePanel.this.endSizePanel.getFloatValue());
            }
        });
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(this.createTitledBorder("PARTICLE SIZE"));
        jPanel4.add((Component)this.startSizePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.endSizePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel6 = this.createBoldLabel("Texture Image:");
        JButton jButton2 = new JButton(new AbstractAction("Browse..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.changeTexture();
            }
        });
        jButton2.setFont(new Font("Arial", 1, 12));
        jButton2.setMargin(new Insets(2, 2, 2, 2));
        JButton jButton3 = new JButton(new AbstractAction("Clear"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ((TextureState)ParticleAppearancePanel.this.getEdittedParticles().getRenderState(6)).setTexture(null);
                ParticleAppearancePanel.this.imageLabel.setIcon(null);
            }
        });
        jButton3.setFont(new Font("Arial", 1, 12));
        jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.imageLabel.setBackground(Color.lightGray);
        this.imageLabel.setMaximumSize(new Dimension(128, 128));
        this.imageLabel.setMinimumSize(new Dimension(0, 0));
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setOpaque(false);
        this.texturePanel = new JPanel(new GridBagLayout());
        this.texturePanel.setBorder(this.createTitledBorder("PARTICLE TEXTURE"));
        this.texturePanel.add((Component)jLabel6, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.texturePanel.add((Component)jButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.texturePanel.add((Component)jButton3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.texturePanel.add((Component)this.imageLabel, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel7 = new JLabel();
        jLabel7.setForeground(Color.WHITE);
        jLabel7.setFont(new Font("Arial", 1, 10));
        jLabel7.setText("Render Queue:");
        this.renderQueueCB = new JComboBox<String>(new String[]{"INHERIT", "SKIP", "OPAQUE", "TRANSPARENT", "ORTHO"});
        this.renderQueueCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.getEdittedParticles().setRenderQueueMode(ParticleAppearancePanel.this.renderQueueCB.getSelectedIndex());
            }
        });
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(this.createTitledBorder("RENDER QUEUE"));
        jPanel5.add((Component)jLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel5.add((Component)this.renderQueueCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 5, 5), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 5, 10), 0, 0));
        this.add((Component)this.texturePanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 10, 5, 5), 0, 0));
    }

    private void changeParticleType(int n) {
        Savable savable;
        ParticleGeometry particleGeometry;
        Serializable serializable;
        int n2 = this.getEdittedParticles().getParticleType();
        if (n == n2) {
            return;
        }
        ParticleGeometry particleGeometry2 = this.getEdittedParticles();
        if (n == 2) {
            serializable = ParticleFactory.buildPointParticles(particleGeometry2.getName(), particleGeometry2.getNumParticles());
            particleGeometry = serializable;
            ((ParticlePoints)serializable).setPointSize(5.0f);
            ((ParticlePoints)serializable).setAntialiased(true);
        } else {
            particleGeometry = n == 3 ? ParticleFactory.buildLineParticles(particleGeometry2.getName(), particleGeometry2.getNumParticles()) : ParticleFactory.buildParticles(particleGeometry2.getName(), particleGeometry2.getNumParticles(), n);
        }
        particleGeometry.setVelocityAligned(particleGeometry2.isVelocityAligned());
        particleGeometry.setStartColor(particleGeometry2.getStartColor());
        particleGeometry.setEndColor(particleGeometry2.getEndColor());
        particleGeometry.setStartSize(particleGeometry2.getStartSize());
        particleGeometry.setEndSize(particleGeometry2.getEndSize());
        particleGeometry.setLocalTranslation(particleGeometry2.getLocalTranslation());
        particleGeometry.setLocalRotation(particleGeometry2.getLocalRotation());
        particleGeometry.setLocalScale(particleGeometry2.getLocalScale());
        particleGeometry.setOriginOffset(particleGeometry2.getOriginOffset());
        particleGeometry.setGeometry(particleGeometry2.getLine());
        particleGeometry.setGeometry(particleGeometry2.getRectangle());
        particleGeometry.setGeometry(particleGeometry2.getRing());
        particleGeometry.setEmitType(particleGeometry2.getEmitType());
        particleGeometry.setRotateWithScene(particleGeometry2.isRotateWithScene());
        particleGeometry.setEmissionDirection(particleGeometry2.getEmissionDirection());
        particleGeometry.setMinimumAngle(particleGeometry2.getMinimumAngle());
        particleGeometry.setMaximumAngle(particleGeometry2.getMaximumAngle());
        particleGeometry.setInitialVelocity(particleGeometry2.getInitialVelocity());
        particleGeometry.setParticleSpinSpeed(particleGeometry2.getParticleSpinSpeed());
        particleGeometry.setControlFlow(particleGeometry2.getParticleController().isControlFlow());
        particleGeometry.setReleaseRate(particleGeometry2.getReleaseRate());
        particleGeometry.setReleaseVariance(particleGeometry2.getReleaseVariance());
        particleGeometry.setRepeatType(particleGeometry2.getParticleController().getRepeatType());
        particleGeometry.setSpeed(particleGeometry2.getParticleController().getSpeed());
        particleGeometry.setParticleMass(particleGeometry2.getParticle(0).getMass());
        particleGeometry.setMinimumLifeTime(particleGeometry2.getMinimumLifeTime());
        particleGeometry.setMaximumLifeTime(particleGeometry2.getMaximumLifeTime());
        particleGeometry.getParticleController().setPrecision(particleGeometry2.getParticleController().getPrecision());
        serializable = particleGeometry2.getInfluences();
        if (serializable != null) {
            Iterator iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                savable = (ParticleInfluence)iterator.next();
                particleGeometry.addInfluence((ParticleInfluence)savable);
            }
        }
        for (int i = 0; i < 17; ++i) {
            savable = particleGeometry2.getRenderState(i);
            if (savable == null) continue;
            particleGeometry.setRenderState((RenderState)savable);
        }
        this.requestParticleSystemOverwrite(particleGeometry);
    }

    protected abstract void requestParticleSystemOverwrite(ParticleGeometry var1);

    private void changeTexture() {
        try {
            int n = this.textureChooser.showOpenDialog(this);
            if (n == 1) {
                return;
            }
            File file = this.textureChooser.getSelectedFile();
            this.prefs.put("texture_dir", file.getParent());
            newTexture = file;
            GameTaskQueueManager.getManager().getQueue("render").enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ParticleAppearancePanel.this.loadApplyTexture();
                    return null;
                }
            });
            ImageIcon imageIcon = new ImageIcon(this.getToolkit().createImage(file.getAbsolutePath()));
            this.imageLabel.setIcon(imageIcon);
            this.validate();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "changeTexture()", "Exception", exception);
        }
    }

    private String convColorToHex(Color color) {
        String string;
        String string2;
        if (color == null) {
            return null;
        }
        String string3 = Integer.toHexString(color.getRed());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    private void countButton_actionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(this, "Please enter a new particle count for this system:", "How many particles?", -1);
        if (string == null) {
            return;
        }
        int n = 100;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid number entered.  Using 100 instead.", "Invalid", 2);
            n = 100;
        }
        this.getEdittedParticles().recreate(n);
        this.updateCountLabels();
        this.validate();
    }

    public void setColorChooserDialogOwner(Frame frame) {
        this.colorChooserDialog = new JDialog(frame, "Choose a color:");
        this.initColorChooser();
    }

    private void initColorChooser() {
        this.colorChooser.setColor(this.endColorPanel.getBackground());
        this.colorChooserDialog.setLayout(new BorderLayout());
        this.colorChooserDialog.setDefaultCloseOperation(1);
        this.colorChooserDialog.add((Component)this.colorChooser, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JButton jButton = new JButton("Ok");
        jButton.setOpaque(true);
        jButton.setMnemonic('O');
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = ParticleAppearancePanel.this.colorChooser.getColor();
                if (color == null) {
                    return;
                }
                ColorRGBA colorRGBA = ParticleAppearancePanel.this.makeColorRGBA(color);
                if (ParticleAppearancePanel.this.colorstart) {
                    colorRGBA.a = (float)Integer.parseInt(ParticleAppearancePanel.this.startAlphaSpinner.getValue().toString()) / 255.0f;
                    ParticleAppearancePanel.this.getEdittedParticles().setStartColor(colorRGBA);
                    ParticleAppearancePanel.this.startColorPanel.setBackground(color);
                } else {
                    colorRGBA.a = (float)Integer.parseInt(ParticleAppearancePanel.this.endAlphaSpinner.getValue().toString()) / 255.0f;
                    ParticleAppearancePanel.this.getEdittedParticles().setEndColor(colorRGBA);
                    ParticleAppearancePanel.this.endColorPanel.setBackground(color);
                }
                ParticleAppearancePanel.this.updateColorLabels();
                ParticleAppearancePanel.this.colorChooserDialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setOpaque(true);
        jButton2.setMnemonic('C');
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleAppearancePanel.this.colorChooserDialog.setVisible(false);
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.colorChooserDialog.add((Component)jPanel, "South");
        this.colorChooserDialog.setSize(this.colorChooserDialog.getPreferredSize());
        this.colorChooserDialog.setLocationRelativeTo(null);
    }

    private void initTextureChooser() {
        String string = this.prefs.get("texture_dir", null);
        if (string != null) {
            this.textureChooser.setCurrentDirectory(new File(string));
        }
    }

    private void loadApplyTexture() throws MalformedURLException {
        TextureState textureState = (TextureState)this.getEdittedParticles().getRenderState(6);
        TextureManager.clearCache();
        textureState.setTexture(TextureManager.loadTexture(newTexture.toURI().toURL(), 2, 1));
        textureState.setEnabled(true);
        this.getEdittedParticles().setRenderState(textureState);
        this.getEdittedParticles().updateRenderState();
        newTexture = null;
    }

    private Color makeColor(ColorRGBA colorRGBA, boolean bl) {
        return new Color(colorRGBA.r, colorRGBA.g, colorRGBA.b, bl ? colorRGBA.a : 1.0f);
    }

    private ColorRGBA makeColorRGBA(Color color) {
        return new ColorRGBA((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    private void startColorPanel_mouseClicked(MouseEvent mouseEvent) {
        this.colorChooser.setColor(this.startColorPanel.getBackground());
        if (!this.colorChooserDialog.isVisible()) {
            this.colorstart = true;
            this.colorChooserDialog.setVisible(true);
        }
    }

    private void endColorPanel_mouseClicked(MouseEvent mouseEvent) {
        this.colorChooser.setColor(this.endColorPanel.getBackground());
        if (!this.colorChooserDialog.isVisible()) {
            this.colorstart = false;
            this.colorChooserDialog.setVisible(true);
        }
    }

    private void updateAlphaState(boolean bl) {
        AlphaState alphaState = (AlphaState)this.getEdittedParticles().getRenderState(0);
        if (alphaState == null) {
            alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setTestEnabled(true);
            alphaState.setTestFunction(4);
            this.getEdittedParticles().setRenderState(alphaState);
            this.getEdittedParticles().updateRenderState();
        }
        alphaState.setDstFunction(bl ? 1 : 5);
    }

    private void updateColorLabels() {
        this.startColorHex.setText(this.convColorToHex(this.startColorPanel.getBackground()));
        this.endColorHex.setText(this.convColorToHex(this.endColorPanel.getBackground()));
    }

    private void updateCountLabels() {
        int n = this.getEdittedParticles().getNumParticles();
        this.countLabel.setText("Particles: " + n);
    }

    public void updateWidgets() {
        ParticleGeometry particleGeometry = this.getEdittedParticles();
        this.updateCountLabels();
        this.geomTypeBox.setSelectedIndex(particleGeometry.getParticleType());
        this.velocityAlignedBox.setSelected(particleGeometry.isVelocityAligned());
        this.startColorPanel.setBackground(this.makeColor(particleGeometry.getStartColor(), false));
        this.endColorPanel.setBackground(this.makeColor(particleGeometry.getEndColor(), false));
        this.startAlphaSpinner.setValue(new Integer(this.makeColor(particleGeometry.getStartColor(), true).getAlpha()));
        this.endAlphaSpinner.setValue(new Integer(this.makeColor(particleGeometry.getEndColor(), true).getAlpha()));
        this.updateColorLabels();
        AlphaState alphaState = (AlphaState)particleGeometry.getRenderState(0);
        this.additiveBlendingBox.setSelected(alphaState == null || alphaState.getDstFunction() == 1);
        this.startSizePanel.setValue(particleGeometry.getStartSize());
        this.endSizePanel.setValue(particleGeometry.getEndSize());
        this.renderQueueCB.setSelectedIndex(particleGeometry.getRenderQueueMode());
        if (this.getTexturePanel().isVisible()) {
            Texture texture = null;
            try {
                texture = ((TextureState)particleGeometry.getRenderState(6)).getTexture();
                if (texture != null) {
                    if (texture.getTextureKey() != null && texture.getTextureKey().getLocation() != null) {
                        this.imageLabel.setIcon(new ImageIcon(texture.getTextureKey().getLocation()));
                    } else {
                        this.imageLabel.setIcon(new ImageIcon(new URL(texture.getImageLocation())));
                    }
                } else {
                    this.imageLabel.setIcon(null);
                }
            }
            catch (Exception exception) {
                logger.warning("image: " + texture + " : " + texture != null ? texture.getImageLocation() : "");
            }
        }
    }

    public JCheckBox getAdditiveBlendingBox() {
        return this.additiveBlendingBox;
    }

    public JPanel getTexturePanel() {
        return this.texturePanel;
    }
}

