/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.controls;

import com.jme.input.controls.Binding;
import com.jme.input.controls.GameControl;
import com.jme.input.controls.GameControlManager;
import com.jmex.editors.swing.controls.ControlField;
import com.jmex.editors.swing.controls.ControlFieldListener;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GameControlEditor
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static int MOUSE_THRESHOLD = 5;
    public static float JOYSTICK_THRESHOLD = 0.2f;
    private GameControlManager manager;
    private int bindings;
    protected HashMap<GameControl, ControlField[]> controls;
    private ControlFieldListener listener;

    public GameControlEditor(GameControlManager gameControlManager, int n) {
        this.manager = gameControlManager;
        this.bindings = n;
        this.controls = new HashMap();
        this.init();
    }

    private void init() {
        this.listener = new ControlFieldListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (String string : this.manager.getControlNames()) {
            GameControl gameControl = this.manager.getControl(string);
            JLabel jLabel = new JLabel(string + ":");
            jLabel.setHorizontalAlignment(4);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            ControlField[] controlFieldArray = new ControlField[this.bindings];
            for (int i = 0; i < controlFieldArray.length; ++i) {
                Binding binding = null;
                if (gameControl.getBindings().size() > i) {
                    binding = gameControl.getBindings().get(i);
                }
                controlFieldArray[i] = new ControlField(gameControl, binding);
                controlFieldArray[i].addMouseListener(this);
                if (i == controlFieldArray.length - 1) {
                    gridBagConstraints.gridwidth = 0;
                }
                gridBagLayout.setConstraints(controlFieldArray[i], gridBagConstraints);
                this.add(controlFieldArray[i]);
            }
            this.controls.put(gameControl, controlFieldArray);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getComponent() instanceof ControlField) {
            ControlField controlField = (ControlField)mouseEvent.getComponent();
            this.listener.prompt(controlField);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void apply() {
        for (GameControl gameControl : this.controls.keySet()) {
            gameControl.clearBindings();
            for (ControlField controlField : this.controls.get(gameControl)) {
                if (controlField.getBinding() == null) continue;
                gameControl.addBinding(controlField.getBinding());
            }
        }
    }

    public void reset() {
        for (GameControl gameControl : this.controls.keySet()) {
            ControlField[] controlFieldArray = this.controls.get(gameControl);
            for (int i = 0; i < controlFieldArray.length; ++i) {
                if (gameControl.getBindings().size() > i) {
                    controlFieldArray[i].setBinding(gameControl.getBindings().get(i));
                    continue;
                }
                controlFieldArray[i].setBinding(null);
            }
        }
    }

    public void clear() {
        for (GameControl gameControl : this.controls.keySet()) {
            ControlField[] controlFieldArray = this.controls.get(gameControl);
            for (int i = 0; i < controlFieldArray.length; ++i) {
                controlFieldArray[i].setBinding(null);
            }
        }
    }
}

