/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.MusicTrackQueue;
import com.jmex.audio.event.TrackStateAdapter;
import java.util.logging.Logger;

public class RangedAudioTracker {
    private static final Logger logger = Logger.getLogger(RangedAudioTracker.class.getName());
    private AudioTrack track;
    private float playRangeSQ;
    private Vector3f position = new Vector3f();
    private Spatial toTrack = null;
    private float stopRangeSQ;
    private boolean useCharacterPosition;
    private boolean trackIn3D = false;
    private float fadeTime;
    private float maxVolume = 1.0f;

    public RangedAudioTracker(AudioTrack audioTrack) {
        this(audioTrack, 80.0f, 100.0f);
    }

    public RangedAudioTracker(AudioTrack audioTrack, float f, float f2) {
        this.setAudioTrack(audioTrack);
        this.setPlayRange(f);
        this.setStopRange(f2);
        this.fadeTime = 3.5f;
        this.useCharacterPosition = true;
    }

    public RangedAudioTracker(AudioTrack audioTrack, float f, float f2, Spatial spatial) {
        this.setAudioTrack(audioTrack);
        this.setPlayRange(f);
        this.setStopRange(f2);
        this.fadeTime = 3.5f;
        this.useCharacterPosition = true;
        this.toTrack = spatial;
    }

    public void checkTrackAudible(Vector3f vector3f) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.toTrack != null) {
            this.setPosition(this.toTrack.getWorldTranslation());
        }
        float f = this.getDistanceSquared(vector3f);
        if (!this.getAudioTrack().isPlaying()) {
            if (f <= this.playRangeSQ) {
                bl2 = true;
            }
        } else if (f >= this.stopRangeSQ) {
            bl = true;
        }
        if (!bl && !bl2) {
            return;
        }
        switch (this.getAudioTrack().getType()) {
            case MUSIC: {
                MusicTrackQueue musicTrackQueue = AudioSystem.getSystem().getMusicQueue();
                musicTrackQueue.addTrack(this.getAudioTrack());
                if (bl2 && (!musicTrackQueue.isPlaying() || musicTrackQueue.getCurrentTrack() != this.getAudioTrack())) {
                    logger.info("I should start playing music: " + this.getAudioTrack().getResource());
                    musicTrackQueue.setCurrentTrack(this.getAudioTrack());
                    break;
                }
                if (!bl || this.getAudioTrack().getTargetVolume() != this.getAudioTrack().getVolume()) break;
                logger.info("I should stop playing music: " + this.getAudioTrack().getResource());
                if (musicTrackQueue.getCurrentTrack() == this.getAudioTrack()) {
                    musicTrackQueue.setCurrentTrack(-1);
                    break;
                }
                this.getAudioTrack().stop();
                break;
            }
            case ENVIRONMENT: {
                AudioSystem.getSystem().getEnvironmentalPool().addTrack(this.getAudioTrack());
                if (bl2) {
                    this.getAudioTrack().setEnabled(true);
                    logger.info("I should start playing environment: " + this.getAudioTrack().getResource());
                    break;
                }
                if (!bl || this.getAudioTrack().getTargetVolume() != this.getAudioTrack().getVolume()) break;
                this.getAudioTrack().setEnabled(false);
                logger.info("I should stop playing environment: " + this.getAudioTrack().getResource());
                break;
            }
            case HEADSPACE: 
            case POSITIONAL: {
                if (bl2) {
                    this.getAudioTrack().fadeIn(this.fadeTime, this.maxVolume);
                    this.getAudioTrack().play();
                    logger.info("I should start playing sound: " + this.getAudioTrack().getResource());
                    break;
                }
                if (!bl || this.getAudioTrack().getTargetVolume() != this.getAudioTrack().getVolume()) break;
                this.getAudioTrack().fadeOut(this.fadeTime);
                logger.info("I should stop playing sound: " + this.getAudioTrack().getResource());
                this.getAudioTrack().addTrackStateListener(new TrackStateAdapter(){

                    public void trackFinishedFade(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.stop();
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                    }

                    public void trackStopped(AudioTrack audioTrack) {
                        audioTrack.removeTrackStateListener(this);
                        audioTrack.setVolume(1.0f);
                        audioTrack.setTargetVolume(1.0f);
                    }
                });
            }
        }
    }

    private float getDistanceSquared(Vector3f vector3f) {
        if (this.trackIn3D) {
            return this.position.distanceSquared(vector3f);
        }
        double d = this.position.x - vector3f.x;
        double d2 = this.position.y - vector3f.y;
        return (float)(d * d + d2 * d2);
    }

    public float getPlayRangeSquared() {
        return this.playRangeSQ;
    }

    public void setPlayRangeSquared(float f) {
        this.playRangeSQ = f;
    }

    public float getPlayRange() {
        return FastMath.sqrt(this.playRangeSQ);
    }

    public void setPlayRange(float f) {
        this.playRangeSQ = f * f;
        this.getAudioTrack().setMaxAudibleDistance(f);
        this.getAudioTrack().setReferenceDistance(f / 10.0f);
        this.getAudioTrack().setRolloff(0.5f);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f vector3f) {
        this.position.set(vector3f);
        if (this.getAudioTrack().getType().equals((Object)AudioTrack.TrackType.POSITIONAL)) {
            this.getAudioTrack().setWorldPosition(vector3f);
        }
    }

    public float getStopRangeSquared() {
        return this.stopRangeSQ;
    }

    public void setStopRangeSquared(float f) {
        this.stopRangeSQ = f;
    }

    public float getStopRange() {
        return FastMath.sqrt(this.stopRangeSQ);
    }

    public void setStopRange(float f) {
        this.stopRangeSQ = f * f;
    }

    public AudioTrack getAudioTrack() {
        return this.track;
    }

    public void setAudioTrack(AudioTrack audioTrack) {
        this.track = audioTrack;
    }

    public boolean isUseCharacterPosition() {
        return this.useCharacterPosition;
    }

    public void setUseCharacterPosition(boolean bl) {
        this.useCharacterPosition = bl;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float f) {
        this.fadeTime = f;
    }

    public boolean isTrackIn3D() {
        return this.trackIn3D;
    }

    public void setTrackIn3D(boolean bl) {
        this.trackIn3D = bl;
    }

    public Spatial getToTrack() {
        return this.toTrack;
    }

    public void setToTrack(Spatial spatial) {
        this.toTrack = spatial;
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public void setMaxVolume(float f) {
        this.maxVolume = f;
    }
}

