/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom.nvtristrip;

import java.util.Arrays;

class VertexCache {
    int[] entries;
    int numEntries;

    public VertexCache() {
        this(16);
    }

    public VertexCache(int n) {
        this.numEntries = n;
        this.entries = new int[this.numEntries];
        this.clear();
    }

    public boolean inCache(int n) {
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.entries[i] != n) continue;
            return true;
        }
        return false;
    }

    public int addEntry(int n) {
        int n2 = this.entries[this.numEntries - 1];
        for (int i = this.numEntries - 2; i >= 0; --i) {
            this.entries[i + 1] = this.entries[i];
        }
        this.entries[0] = n;
        return n2;
    }

    public void clear() {
        Arrays.fill(this.entries, -1);
    }

    public int at(int n) {
        return this.entries[n];
    }

    public void set(int n, int n2) {
        this.entries[n] = n2;
    }

    public void copy(VertexCache vertexCache) {
        for (int i = 0; i < this.numEntries; ++i) {
            vertexCache.set(i, this.entries[i]);
        }
    }
}

