/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import java.util.Arrays;

public class NonIndexedNormalGenerator {
    private Vector3f temp1 = new Vector3f();
    private Vector3f temp2 = new Vector3f();
    private Vector3f temp3 = new Vector3f();
    private int[] indices;
    private float creaseAngle;
    private float[] faceNormals;
    private int[] normalsToSet;

    public float[] generateNormals(float[] fArray, int[] nArray, float f) {
        this.indices = nArray;
        this.creaseAngle = f;
        this.normalsToSet = new int[10];
        Arrays.fill(this.normalsToSet, -1);
        this.initFaceNormals(fArray);
        if (f < 1.0E-4f || nArray == null) {
            return this.getFacetedVertexNormals();
        }
        return this.getVertexNormals();
    }

    private void initFaceNormals(float[] fArray) {
        this.faceNormals = new float[fArray.length / 3];
        int n = 0;
        while (n * 9 < fArray.length) {
            this.temp1.set(fArray[n * 9 + 0], fArray[n * 9 + 1], fArray[n * 9 + 2]);
            this.temp2.set(fArray[n * 9 + 3], fArray[n * 9 + 4], fArray[n * 9 + 5]);
            this.temp3.set(fArray[n * 9 + 6], fArray[n * 9 + 7], fArray[n * 9 + 8]);
            this.temp2.subtractLocal(this.temp1);
            this.temp3.subtractLocal(this.temp1);
            this.temp2.cross(this.temp3, this.temp1);
            this.temp1.normalizeLocal();
            this.faceNormals[n * 3 + 0] = this.temp1.x;
            this.faceNormals[n * 3 + 1] = this.temp1.y;
            this.faceNormals[n * 3 + 2] = this.temp1.z;
            ++n;
        }
    }

    private float[] getVertexNormals() {
        float[] fArray = new float[this.faceNormals.length * 3];
        boolean[] blArray = new boolean[this.faceNormals.length];
        int n = 0;
        while (n * 3 < this.faceNormals.length) {
            for (int i = 0; i < 3; ++i) {
                if (blArray[n * 3 + i]) continue;
                this.setInterpolatedNormal(fArray, blArray, n, i);
            }
            ++n;
        }
        return fArray;
    }

    private void setInterpolatedNormal(float[] fArray, boolean[] blArray, int n, int n2) {
        int n3;
        this.temp1.set(this.faceNormals[n * 3 + 0], this.faceNormals[n * 3 + 1], this.faceNormals[n * 3 + 2]);
        this.temp2.set(this.temp1);
        int n4 = this.indices[n * 3 + n2];
        this.normalsToSet[0] = n * 3 + n2;
        int n5 = 1;
        for (n3 = n * 3 + n2 + 1; n3 < this.indices.length; ++n3) {
            if (this.indices[n3] != n4 || blArray[n * 3 + n2]) continue;
            this.temp3.set(this.faceNormals[n3 / 3 * 3 + 0], this.faceNormals[n3 / 3 * 3 + 1], this.faceNormals[n3 / 3 * 3 + 2]);
            if (!(this.temp1.angleBetween(this.temp3) < this.creaseAngle)) continue;
            this.normalsToSet = this.setValue(this.normalsToSet, n5, n3);
            ++n5;
            this.temp2.add(this.temp3);
        }
        this.temp2.normalizeLocal();
        for (n3 = 0; n3 < this.normalsToSet.length && this.normalsToSet[n3] != -1; ++n3) {
            fArray[this.normalsToSet[n3] * 3 + 0] = this.temp2.x;
            fArray[this.normalsToSet[n3] * 3 + 1] = this.temp2.y;
            fArray[this.normalsToSet[n3] * 3 + 2] = this.temp2.z;
            blArray[this.normalsToSet[n3]] = true;
            this.normalsToSet[n3] = -1;
        }
    }

    private int[] setValue(int[] nArray, int n, int n2) {
        if (n >= nArray.length) {
            int[] nArray2 = new int[nArray.length + 3];
            Arrays.fill(nArray2, -1);
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[n] = n2;
        return nArray;
    }

    private float[] getFacetedVertexNormals() {
        float[] fArray = new float[this.faceNormals.length * 3];
        int n = 0;
        while (n * 3 < this.faceNormals.length) {
            for (int i = 0; i < 3; ++i) {
                fArray[n * 9 + i + 0] = this.faceNormals[n * 3 + i];
                fArray[n * 9 + i + 3] = this.faceNormals[n * 3 + i];
                fArray[n * 9 + i + 6] = this.faceNormals[n * 3 + i];
            }
            ++n;
        }
        return fArray;
    }

    public void generateNormals(TriangleBatch triangleBatch) {
    }
}

