/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.util.export.Savable;
import com.jme.util.export.binary.Bar;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.export.binary.Foo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class TestBinaryExportImport
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestBinaryExportImport.class.getName());

    public void testSimpleSavable() {
        Savable savable;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Foo foo = new Foo();
        try {
            foo.x = 8;
            object = new Bar();
            ((Bar)object).f = 7.5f;
            ((Bar)object).g = 9.32423f;
            savable = object;
            foo.y = object;
            foo.z = savable;
            BinaryExporter.getInstance().save((Savable)foo, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, TestBinaryExportImport.class.toString(), "main(args)", "Exception", iOException);
        }
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            savable = (Foo)BinaryImporter.getInstance().load((InputStream)object);
            TestBinaryExportImport.assertEquals((String)"x", (int)8, (int)((Foo)savable).x);
            TestBinaryExportImport.assertTrue((String)"y", (boolean)(((Foo)savable).y instanceof Bar));
            TestBinaryExportImport.assertEquals((String)"y", (float)7.5f, (float)((Foo)savable).y.f, (float)1.1920929E-7f);
            TestBinaryExportImport.assertEquals((String)"y", (float)9.32423f, (float)((Foo)savable).y.g, (float)1.1920929E-7f);
            TestBinaryExportImport.assertTrue((String)"z", (boolean)(((Foo)savable).y instanceof Bar));
            TestBinaryExportImport.assertEquals((String)"z", (float)7.5f, (float)((Foo)savable).z.f, (float)1.1920929E-7f);
            TestBinaryExportImport.assertEquals((String)"z", (float)9.32423f, (float)((Foo)savable).z.g, (float)1.1920929E-7f);
            TestBinaryExportImport.assertEquals((String)"y == z", (Object)((Foo)savable).y, (Object)((Foo)savable).z);
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, TestBinaryExportImport.class.toString(), "main(args)", "Exception", iOException);
        }
    }
}

