/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl.shader;

import com.jme.util.shader.ShaderVariable;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat2;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat3;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat4;
import com.jme.util.shader.uniformtypes.ShaderVariableInt;
import com.jme.util.shader.uniformtypes.ShaderVariableInt2;
import com.jme.util.shader.uniformtypes.ShaderVariableInt3;
import com.jme.util.shader.uniformtypes.ShaderVariableInt4;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix2;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix3;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix4;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerByte;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerFloat;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerInt;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerShort;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;

public class LWJGLShaderUtil {
    private static final Logger logger = Logger.getLogger(LWJGLShaderUtil.class.getName());

    public static void updateShaderUniform(ShaderVariable shaderVariable) {
        if (shaderVariable instanceof ShaderVariableInt) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt4)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat4)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix4)shaderVariable);
        } else {
            logger.warning("updateShaderUniform: Unknown shaderVariable type!");
        }
    }

    public static void updateUniformLocation(ShaderVariable shaderVariable, int n) {
        if (shaderVariable.variableID == -1) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(shaderVariable.name.getBytes().length + 1);
            byteBuffer.clear();
            byteBuffer.put(shaderVariable.name.getBytes());
            byteBuffer.rewind();
            shaderVariable.variableID = ARBShaderObjects.glGetUniformLocationARB(n, byteBuffer);
            if (shaderVariable.variableID == -1) {
                logger.severe("Shader uniform [" + shaderVariable.name + "] could not be located in shader");
            }
        }
    }

    private static void updateShaderUniform(ShaderVariableInt shaderVariableInt) {
        ARBShaderObjects.glUniform1iARB(shaderVariableInt.variableID, shaderVariableInt.value1);
    }

    private static void updateShaderUniform(ShaderVariableInt2 shaderVariableInt2) {
        ARBShaderObjects.glUniform2iARB(shaderVariableInt2.variableID, shaderVariableInt2.value1, shaderVariableInt2.value2);
    }

    private static void updateShaderUniform(ShaderVariableInt3 shaderVariableInt3) {
        ARBShaderObjects.glUniform3iARB(shaderVariableInt3.variableID, shaderVariableInt3.value1, shaderVariableInt3.value2, shaderVariableInt3.value3);
    }

    private static void updateShaderUniform(ShaderVariableInt4 shaderVariableInt4) {
        ARBShaderObjects.glUniform4iARB(shaderVariableInt4.variableID, shaderVariableInt4.value1, shaderVariableInt4.value2, shaderVariableInt4.value3, shaderVariableInt4.value4);
    }

    private static void updateShaderUniform(ShaderVariableFloat shaderVariableFloat) {
        ARBShaderObjects.glUniform1fARB(shaderVariableFloat.variableID, shaderVariableFloat.value1);
    }

    private static void updateShaderUniform(ShaderVariableFloat2 shaderVariableFloat2) {
        ARBShaderObjects.glUniform2fARB(shaderVariableFloat2.variableID, shaderVariableFloat2.value1, shaderVariableFloat2.value2);
    }

    private static void updateShaderUniform(ShaderVariableFloat3 shaderVariableFloat3) {
        ARBShaderObjects.glUniform3fARB(shaderVariableFloat3.variableID, shaderVariableFloat3.value1, shaderVariableFloat3.value2, shaderVariableFloat3.value3);
    }

    private static void updateShaderUniform(ShaderVariableFloat4 shaderVariableFloat4) {
        ARBShaderObjects.glUniform4fARB(shaderVariableFloat4.variableID, shaderVariableFloat4.value1, shaderVariableFloat4.value2, shaderVariableFloat4.value3, shaderVariableFloat4.value4);
    }

    private static void updateShaderUniform(ShaderVariableMatrix2 shaderVariableMatrix2) {
        shaderVariableMatrix2.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix2ARB(shaderVariableMatrix2.variableID, shaderVariableMatrix2.transpose, shaderVariableMatrix2.matrixBuffer);
    }

    private static void updateShaderUniform(ShaderVariableMatrix3 shaderVariableMatrix3) {
        shaderVariableMatrix3.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix3ARB(shaderVariableMatrix3.variableID, shaderVariableMatrix3.transpose, shaderVariableMatrix3.matrixBuffer);
    }

    private static void updateShaderUniform(ShaderVariableMatrix4 shaderVariableMatrix4) {
        shaderVariableMatrix4.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix4ARB(shaderVariableMatrix4.variableID, shaderVariableMatrix4.transpose, shaderVariableMatrix4.matrixBuffer);
    }

    public static void updateAttributeLocation(ShaderVariable shaderVariable, int n) {
        if (shaderVariable.variableID == -1) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer(shaderVariable.name.getBytes().length + 1);
            byteBuffer.clear();
            byteBuffer.put(shaderVariable.name.getBytes());
            byteBuffer.rewind();
            shaderVariable.variableID = ARBVertexShader.glGetAttribLocationARB(n, byteBuffer);
            if (shaderVariable.variableID == -1) {
                logger.severe("Shader attribute [" + shaderVariable.name + "] could not be located in shader");
            }
        }
    }

    public static void updateShaderAttribute(ShaderVariable shaderVariable) {
        if (shaderVariable instanceof ShaderVariablePointerFloat) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerFloat)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerByte) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerByte)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerInt) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerInt)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerShort) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerShort)shaderVariable);
        } else {
            logger.warning("updateShaderAttribute: Unknown shaderVariable type!");
        }
    }

    private static void updateShaderAttribute(ShaderVariablePointerFloat shaderVariablePointerFloat) {
        shaderVariablePointerFloat.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB(shaderVariablePointerFloat.variableID);
        ARBVertexProgram.glVertexAttribPointerARB(shaderVariablePointerFloat.variableID, shaderVariablePointerFloat.size, shaderVariablePointerFloat.normalized, shaderVariablePointerFloat.stride, shaderVariablePointerFloat.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerByte shaderVariablePointerByte) {
        shaderVariablePointerByte.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB(shaderVariablePointerByte.variableID);
        ARBVertexProgram.glVertexAttribPointerARB(shaderVariablePointerByte.variableID, shaderVariablePointerByte.size, shaderVariablePointerByte.unsigned, shaderVariablePointerByte.normalized, shaderVariablePointerByte.stride, shaderVariablePointerByte.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerInt shaderVariablePointerInt) {
        shaderVariablePointerInt.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB(shaderVariablePointerInt.variableID);
        ARBVertexProgram.glVertexAttribPointerARB(shaderVariablePointerInt.variableID, shaderVariablePointerInt.size, shaderVariablePointerInt.unsigned, shaderVariablePointerInt.normalized, shaderVariablePointerInt.stride, shaderVariablePointerInt.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerShort shaderVariablePointerShort) {
        shaderVariablePointerShort.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB(shaderVariablePointerShort.variableID);
        ARBVertexProgram.glVertexAttribPointerARB(shaderVariablePointerShort.variableID, shaderVariablePointerShort.size, shaderVariablePointerShort.unsigned, shaderVariablePointerShort.normalized, shaderVariablePointerShort.stride, shaderVariablePointerShort.data);
    }
}

