/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.ZBufferState;
import com.jme.scene.state.lwjgl.records.ZBufferStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLZBufferState
extends ZBufferState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        ZBufferStateRecord zBufferStateRecord = (ZBufferStateRecord)renderContext.getStateRecord(8);
        renderContext.currentStates[8] = this;
        this.enableDepthTest(this.isEnabled(), zBufferStateRecord);
        if (this.isEnabled()) {
            int n = 0;
            switch (this.getFunction()) {
                case 0: {
                    n = 512;
                    break;
                }
                case 1: {
                    n = 513;
                    break;
                }
                case 2: {
                    n = 514;
                    break;
                }
                case 3: {
                    n = 515;
                    break;
                }
                case 4: {
                    n = 516;
                    break;
                }
                case 5: {
                    n = 517;
                    break;
                }
                case 6: {
                    n = 518;
                    break;
                }
                default: {
                    n = 519;
                }
            }
            this.applyFunction(n, zBufferStateRecord);
        }
        this.enableWrite(this.isWritable(), zBufferStateRecord);
        if (!zBufferStateRecord.isValid()) {
            zBufferStateRecord.validate();
        }
    }

    private void enableDepthTest(boolean bl, ZBufferStateRecord zBufferStateRecord) {
        if (!(!bl || zBufferStateRecord.depthTest && zBufferStateRecord.isValid())) {
            GL11.glEnable(2929);
            zBufferStateRecord.depthTest = true;
        } else if (!(bl || !zBufferStateRecord.depthTest && zBufferStateRecord.isValid())) {
            GL11.glDisable(2929);
            zBufferStateRecord.depthTest = false;
        }
    }

    private void applyFunction(int n, ZBufferStateRecord zBufferStateRecord) {
        if (n != zBufferStateRecord.depthFunc || !zBufferStateRecord.isValid()) {
            GL11.glDepthFunc(n);
            zBufferStateRecord.depthFunc = n;
        }
    }

    private void enableWrite(boolean bl, ZBufferStateRecord zBufferStateRecord) {
        if (bl != zBufferStateRecord.writable || !zBufferStateRecord.isValid()) {
            GL11.glDepthMask(bl);
            zBufferStateRecord.writable = bl;
        }
    }

    public ZBufferStateRecord createStateRecord() {
        return new ZBufferStateRecord();
    }
}

