/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.ShadeState;
import com.jme.scene.state.lwjgl.records.ShadeStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLShadeState
extends ShadeState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        ShadeStateRecord shadeStateRecord = (ShadeStateRecord)renderContext.getStateRecord(5);
        renderContext.currentStates[5] = this;
        int n = this.getGLShade();
        if (!shadeStateRecord.isValid() || n != shadeStateRecord.lastShade) {
            GL11.glShadeModel(n);
            shadeStateRecord.lastShade = n;
        }
        if (!shadeStateRecord.isValid()) {
            shadeStateRecord.validate();
        }
    }

    private int getGLShade() {
        if (this.isEnabled()) {
            switch (this.shade) {
                case 0: {
                    return 7424;
                }
                case 1: {
                    return 7425;
                }
            }
        }
        return 7425;
    }

    public ShadeStateRecord createStateRecord() {
        return new ShadeStateRecord();
    }
}

