/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public abstract class AlphaState
extends RenderState {
    public static final int SB_ZERO = 0;
    public static final int SB_ONE = 1;
    public static final int SB_DST_COLOR = 2;
    public static final int SB_ONE_MINUS_DST_COLOR = 3;
    public static final int SB_SRC_ALPHA = 4;
    public static final int SB_ONE_MINUS_SRC_ALPHA = 5;
    public static final int SB_DST_ALPHA = 6;
    public static final int SB_ONE_MINUS_DST_ALPHA = 7;
    public static final int SB_SRC_ALPHA_SATURATE = 8;
    public static final int DB_ZERO = 0;
    public static final int DB_ONE = 1;
    public static final int DB_SRC_COLOR = 2;
    public static final int DB_ONE_MINUS_SRC_COLOR = 3;
    public static final int DB_SRC_ALPHA = 4;
    public static final int DB_ONE_MINUS_SRC_ALPHA = 5;
    public static final int DB_DST_ALPHA = 6;
    public static final int DB_ONE_MINUS_DST_ALPHA = 7;
    public static final int TF_NEVER = 0;
    public static final int TF_LESS = 1;
    public static final int TF_EQUAL = 2;
    public static final int TF_LEQUAL = 3;
    public static final int TF_GREATER = 4;
    public static final int TF_NOTEQUAL = 5;
    public static final int TF_GEQUAL = 6;
    public static final int TF_ALWAYS = 7;
    private boolean blendEnabled = false;
    private int srcBlend = 4;
    private int dstBlend = 5;
    private boolean testEnabled = false;
    private int test = 7;
    private float reference = 0.0f;

    public int getType() {
        return 0;
    }

    public boolean isBlendEnabled() {
        return this.blendEnabled;
    }

    public void setBlendEnabled(boolean bl) {
        this.blendEnabled = bl;
        this.setNeedsRefresh(true);
    }

    public void setSrcFunction(int n) {
        if (n < 0 || n > 8) {
            n = 4;
        }
        this.srcBlend = n;
        this.setNeedsRefresh(true);
    }

    public int getSrcFunction() {
        return this.srcBlend;
    }

    public void setDstFunction(int n) {
        if (n < 0 || n > 7) {
            n = 5;
        }
        this.dstBlend = n;
        this.setNeedsRefresh(true);
    }

    public int getDstFunction() {
        return this.dstBlend;
    }

    public boolean isTestEnabled() {
        return this.testEnabled;
    }

    public void setTestEnabled(boolean bl) {
        this.testEnabled = bl;
        this.setNeedsRefresh(true);
    }

    public void setTestFunction(int n) {
        if (n < 0 || n > 7) {
            n = 7;
        }
        this.test = n;
        this.setNeedsRefresh(true);
    }

    public int getTestFunction() {
        return this.test;
    }

    public void setReference(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.reference = f;
        this.setNeedsRefresh(true);
    }

    public float getReference() {
        return this.reference;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.blendEnabled, "blendEnabled", false);
        outputCapsule.write(this.srcBlend, "srcBlend", 4);
        outputCapsule.write(this.dstBlend, "dstBlend", 5);
        outputCapsule.write(this.testEnabled, "testEnabled", false);
        outputCapsule.write(this.test, "test", 7);
        outputCapsule.write(this.reference, "reference", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.blendEnabled = inputCapsule.readBoolean("blendEnabled", false);
        this.srcBlend = inputCapsule.readInt("srcBlend", 4);
        this.dstBlend = inputCapsule.readInt("dstBlend", 5);
        this.testEnabled = inputCapsule.readBoolean("testEnabled", false);
        this.test = inputCapsule.readInt("test", 7);
        this.reference = inputCapsule.readFloat("reference", 0.0f);
    }

    public Class getClassTag() {
        return AlphaState.class;
    }
}

