/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.lwjgl.LWJGLCamera;
import com.jme.renderer.lwjgl.LWJGLRenderer;
import com.jme.scene.Spatial;
import com.jme.scene.state.lwjgl.LWJGLTextureState;
import com.jme.scene.state.lwjgl.records.TextureRecord;
import com.jme.scene.state.lwjgl.records.TextureStateRecord;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.ARBDrawBuffers;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWJGLTextureRenderer
implements TextureRenderer {
    private static final Logger logger = Logger.getLogger(LWJGLTextureRenderer.class.getName());
    private LWJGLCamera camera;
    private ColorRGBA backgroundColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private int active;
    private int fboID;
    private int depthRBID;
    private int width;
    private int height;
    private static boolean inited = false;
    private static boolean isSupported = true;
    private static boolean supportsMultiDraw = false;
    private static int maxDrawBuffers = 1;
    private static IntBuffer attachBuffer = null;
    private int currentReadBuffer = 36064;
    private int currentDrawBuffer = 36064;
    private int drawBuffers = 1;
    private boolean usingDepthRB = false;
    private LWJGLRenderer parentRenderer;
    private Camera oldCamera;
    private int oldWidth;
    private int oldHeight;

    public LWJGLTextureRenderer(int n, int n2, LWJGLRenderer lWJGLRenderer) {
        IntBuffer intBuffer;
        if (!inited) {
            isSupported = GLContext.getCapabilities().GL_EXT_framebuffer_object;
            supportsMultiDraw = GLContext.getCapabilities().GL_ARB_draw_buffers;
            if (supportsMultiDraw) {
                intBuffer = BufferUtils.createIntBuffer(16);
                GL11.glGetInteger(36063, intBuffer);
                maxDrawBuffers = intBuffer.get(0);
                if (maxDrawBuffers > 1) {
                    attachBuffer = BufferUtils.createIntBuffer(maxDrawBuffers);
                    for (int i = 0; i < maxDrawBuffers; ++i) {
                        attachBuffer.put(36064 + i);
                    }
                } else {
                    maxDrawBuffers = 1;
                }
            }
            if (!isSupported) {
                logger.warning("FBO not supported.");
                return;
            }
            logger.info("FBO support detected.");
        }
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            if (!FastMath.isPowerOfTwo(n)) {
                int n3 = 2;
                while ((n3 <<= 1) < n) {
                }
                n = n3;
            }
            if (!FastMath.isPowerOfTwo(n2)) {
                int n4 = 2;
                while ((n4 <<= 1) < n2) {
                }
                n2 = n4;
            }
        }
        intBuffer = BufferUtils.createIntBuffer(1);
        EXTFramebufferObject.glGenFramebuffersEXT(intBuffer);
        this.fboID = intBuffer.get(0);
        if (this.fboID <= 0) {
            logger.severe("Invalid FBO id returned! " + this.fboID);
            isSupported = false;
            return;
        }
        EXTFramebufferObject.glGenRenderbuffersEXT(intBuffer);
        this.depthRBID = intBuffer.get(0);
        EXTFramebufferObject.glBindRenderbufferEXT(36161, this.depthRBID);
        EXTFramebufferObject.glRenderbufferStorageEXT(36161, 6402, n, n2);
        this.width = n;
        this.height = n2;
        this.parentRenderer = lWJGLRenderer;
        this.initCamera();
    }

    @Override
    public boolean isSupported() {
        return isSupported;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = (LWJGLCamera)camera;
    }

    @Override
    public void setBackgroundColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.backgroundColor.a = 1.0f;
            this.backgroundColor.b = 1.0f;
            this.backgroundColor.g = 1.0f;
            this.backgroundColor.r = 1.0f;
        } else {
            this.backgroundColor = colorRGBA;
        }
    }

    @Override
    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setupTexture(Texture texture) {
        if (!isSupported) {
            return;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        if (texture.getTextureId() != 0) {
            intBuffer.put(texture.getTextureId());
            GL11.glDeleteTextures(intBuffer);
            intBuffer.clear();
        }
        GL11.glGenTextures(intBuffer);
        texture.setTextureId(intBuffer.get(0));
        TextureManager.registerForCleanup(texture.getTextureKey(), texture.getTextureId());
        LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
        int n = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n = 6407;
                break;
            }
            case 5: {
                n = 6406;
                break;
            }
            case 2: {
                n = 6402;
                break;
            }
            case 6: {
                n = 32841;
                break;
            }
            case 3: {
                n = 6409;
                break;
            }
            case 4: {
                n = 6410;
            }
        }
        int n2 = 32856;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n2 = 32849;
                break;
            }
            case 5: {
                n2 = 32828;
                break;
            }
            case 2: {
                n2 = 6402;
                break;
            }
            case 6: {
                n2 = 32843;
                break;
            }
            case 3: {
                n2 = 32832;
                break;
            }
            case 4: {
                n2 = 6410;
            }
        }
        GL11.glTexImage2D(3553, 0, n2, this.width, this.height, 0, n, 5121, (ByteBuffer)null);
        if (texture.getMipmap() != 0 && texture.getMipmap() != 2 && texture.getMipmap() != 1) {
            EXTFramebufferObject.glGenerateMipmapEXT(3553);
        }
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        TextureRecord textureRecord = textureStateRecord.getTextureRecord(texture.getTextureId());
        LWJGLTextureState.applyFilter(texture, textureRecord, 0, textureStateRecord);
        LWJGLTextureState.applyWrap(texture, textureRecord, 0, textureStateRecord);
        logger.info("setup fbo tex with id " + texture.getTextureId() + ": " + this.width + "," + this.height);
    }

    @Override
    public void render(Spatial spatial, Texture texture) {
        this.render(spatial, texture, true);
    }

    @Override
    public void render(Spatial spatial, Texture texture, boolean bl) {
        if (!isSupported) {
            return;
        }
        try {
            this.activate();
            this.setupForSingleTexDraw(texture, bl);
            this.doDraw(spatial);
            this.takedownForSingleTexDraw(texture);
            this.deactivate();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture, boolean)", "Exception", exception);
        }
    }

    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2) {
        this.render(arrayList, arrayList2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ArrayList<? extends Spatial> arrayList, ArrayList<Texture> arrayList2, boolean bl) {
        if (!isSupported) {
            return;
        }
        if (maxDrawBuffers == 1 || arrayList2.size() == 1) {
            try {
                this.activate();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    Texture texture = arrayList2.get(i);
                    this.setupForSingleTexDraw(texture, bl);
                    this.doDraw(arrayList);
                    this.takedownForSingleTexDraw(texture);
                }
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture, boolean)", "Exception", exception);
            }
            finally {
                this.deactivate();
            }
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            this.activate();
            LinkedList<Texture> linkedList = new LinkedList<Texture>();
            LinkedList<Texture> linkedList2 = new LinkedList<Texture>();
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                Texture texture = arrayList2.get(n3);
                if (texture.getRTTSource() == 2) {
                    linkedList.add(texture);
                    continue;
                }
                linkedList2.add(texture);
            }
            n3 = Math.max(linkedList.size(), (int)(0.999f + (float)linkedList2.size() / (float)maxDrawBuffers));
            for (n2 = 0; n2 < n3; ++n2) {
                if (!linkedList.isEmpty()) {
                    Texture texture = (Texture)linkedList.removeFirst();
                    EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36096, 3553, texture.getTextureId(), 0);
                    this.usingDepthRB = false;
                } else if (!this.usingDepthRB) {
                    EXTFramebufferObject.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthRBID);
                    this.usingDepthRB = true;
                }
                for (n = 0; n < maxDrawBuffers && !linkedList2.isEmpty(); ++n) {
                    Texture texture = (Texture)linkedList2.removeFirst();
                    EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064 + n, 3553, texture.getTextureId(), 0);
                }
                this.setDrawBuffers(n);
                this.setReadBuffer(n != 0 ? 36064 : 0);
                this.checkFBOComplete();
                this.switchCameraIn(bl);
                this.doDraw(arrayList);
                this.switchCameraOut();
            }
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                if (arrayList2.get(n2).getMipmap() == 0 || arrayList2.get(n2).getMipmap() == 2 || arrayList2.get(n2).getMipmap() == 1) continue;
                LWJGLTextureState.doTextureBind(arrayList2.get(n2).getTextureId(), 0);
                EXTFramebufferObject.glGenerateMipmapEXT(3553);
            }
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture)", "Exception", exception);
        }
        finally {
            this.deactivate();
        }
    }

    private void setupForSingleTexDraw(Texture texture, boolean bl) {
        LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
        if (texture.getRTTSource() == 2) {
            EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36096, 3553, texture.getTextureId(), 0);
            this.setDrawBuffer(0);
            this.setReadBuffer(0);
        } else {
            EXTFramebufferObject.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthRBID);
            EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 3553, texture.getTextureId(), 0);
            this.setDrawBuffer(36064);
            this.setReadBuffer(36064);
        }
        this.checkFBOComplete();
        this.switchCameraIn(bl);
    }

    private void setReadBuffer(int n) {
        if (this.currentReadBuffer != n) {
            GL11.glReadBuffer(n);
            this.currentReadBuffer = n;
        }
    }

    private void setDrawBuffer(int n) {
        if (this.currentDrawBuffer != n || this.drawBuffers != 1) {
            GL11.glDrawBuffer(n);
            this.currentDrawBuffer = n;
            this.drawBuffers = 1;
        }
    }

    private void setDrawBuffers(int n) {
        if (n <= 1) {
            this.setDrawBuffer(n != 0 ? 36064 : 0);
        } else {
            this.currentDrawBuffer = 36064;
            if (this.drawBuffers != n) {
                attachBuffer.clear();
                attachBuffer.limit(n);
                ARBDrawBuffers.glDrawBuffersARB(attachBuffer);
                this.drawBuffers = n;
            }
        }
    }

    private void takedownForSingleTexDraw(Texture texture) {
        this.switchCameraOut();
        if (texture.getMipmap() != 0 && texture.getMipmap() != 2 && texture.getMipmap() != 1) {
            LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
            EXTFramebufferObject.glGenerateMipmapEXT(3553);
        }
    }

    private void checkFBOComplete() {
        int n = EXTFramebufferObject.glCheckFramebufferStatusEXT(36160);
        switch (n) {
            case 36053: {
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            case 36061: {
                throw new RuntimeException("FrameBuffer: " + this.fboID + ", has caused a GL_FRAMEBUFFER_UNSUPPORTED_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + n);
            }
        }
    }

    @Override
    public void copyToTexture(Texture texture, int n, int n2) {
        LWJGLTextureState.doTextureBind(texture.getTextureId(), 0);
        int n3 = 6408;
        switch (texture.getRTTSource()) {
            case 1: {
                break;
            }
            case 0: {
                n3 = 6407;
                break;
            }
            case 5: {
                n3 = 6406;
                break;
            }
            case 2: {
                n3 = 6402;
                break;
            }
            case 6: {
                n3 = 32841;
                break;
            }
            case 3: {
                n3 = 6409;
                break;
            }
            case 4: {
                n3 = 6410;
            }
        }
        GL11.glCopyTexImage2D(3553, 0, n3, 0, 0, n, n2, 0);
    }

    public void switchCameraIn(boolean bl) {
        this.oldCamera = this.parentRenderer.getCamera();
        this.oldWidth = this.parentRenderer.getWidth();
        this.oldHeight = this.parentRenderer.getHeight();
        this.parentRenderer.setCamera(this.getCamera());
        this.parentRenderer.getQueue().swapBuckets();
        this.parentRenderer.reinit(this.width, this.height);
        if (bl) {
            this.parentRenderer.clearBuffers();
        }
        this.getCamera().update();
        this.getCamera().apply();
    }

    public void switchCameraOut() {
        this.parentRenderer.setCamera(this.oldCamera);
        this.parentRenderer.reinit(this.oldWidth, this.oldHeight);
        this.parentRenderer.getQueue().swapBuckets();
        this.oldCamera.update();
        this.oldCamera.apply();
    }

    private void doDraw(Spatial spatial) {
        if (spatial.getParent() != null) {
            spatial.getParent().setLastFrustumIntersection(1);
        }
        spatial.onDraw(this.parentRenderer);
        this.parentRenderer.renderQueue();
    }

    private void doDraw(ArrayList<? extends Spatial> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = arrayList.get(i);
            this.doDraw(spatial);
        }
    }

    public void activate() {
        if (!isSupported) {
            return;
        }
        if (this.active == 0) {
            GL11.glClearColor(this.backgroundColor.r, this.backgroundColor.g, this.backgroundColor.b, this.backgroundColor.a);
            EXTFramebufferObject.glBindFramebufferEXT(36160, this.fboID);
        }
        ++this.active;
    }

    public void deactivate() {
        if (!isSupported) {
            return;
        }
        if (this.active == 1) {
            GL11.glClearColor(this.parentRenderer.getBackgroundColor().r, this.parentRenderer.getBackgroundColor().g, this.parentRenderer.getBackgroundColor().b, this.parentRenderer.getBackgroundColor().a);
            EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
        }
        --this.active;
    }

    private void initCamera() {
        if (!isSupported) {
            return;
        }
        logger.info("Init RTT camera");
        this.camera = new LWJGLCamera(this.width, this.height, this, true);
        this.camera.setFrustum(1.0f, 1000.0f, -0.5f, 0.5f, 0.5f, -0.5f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.camera.setDataOnly(false);
    }

    @Override
    public void cleanup() {
        if (!isSupported) {
            return;
        }
        if (this.fboID > 0) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
            intBuffer.put(this.fboID);
            EXTFramebufferObject.glDeleteFramebuffersEXT(intBuffer);
        }
    }

    public LWJGLRenderer getParentRenderer() {
        return this.parentRenderer;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setMultipleTargets(boolean bl) {
    }
}

