/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.CollisionTreeManager;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.bounding.TreeComparator;
import com.jme.intersection.Intersection;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.SortUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OBB_TREE = 0;
    public static final int AABB_TREE = 1;
    public static final int SPHERE_TREE = 2;
    private int type = 1;
    private CollisionTree left;
    private CollisionTree right;
    private BoundingVolume bounds;
    private BoundingVolume worldBounds;
    private int[] triIndex;
    private int start;
    private int end;
    private Geometry parent;
    private TriangleBatch batch;
    private static final Vector3f tempVa = new Vector3f();
    private static final Vector3f tempVb = new Vector3f();
    private static final Vector3f tempVc = new Vector3f();
    private static final Vector3f tempVd = new Vector3f();
    private static final Vector3f tempVe = new Vector3f();
    private static final Vector3f tempVf = new Vector3f();
    private static Vector3f[] verts = new Vector3f[3];
    private static Vector3f[] target = new Vector3f[3];
    protected static TreeComparator comparator = new TreeComparator();

    public CollisionTree(int n) {
        this.type = n;
    }

    public void construct(int n, Geometry geometry, boolean bl) {
        GeomBatch geomBatch = geometry.getBatch(n);
        if (geomBatch instanceof TriangleBatch) {
            this.batch = (TriangleBatch)geomBatch;
            this.triIndex = this.batch.getTriangleIndices(this.triIndex);
            this.createTree(0, this.triIndex.length, bl);
        }
    }

    public void construct(TriangleBatch triangleBatch, TriMesh triMesh, boolean bl) {
        this.parent = triMesh;
        this.batch = triangleBatch;
        this.triIndex = triangleBatch.getTriangleIndices(this.triIndex);
        this.createTree(0, this.triIndex.length, bl);
    }

    public void createTree(int n, int n2, boolean bl) {
        this.start = n;
        this.end = n2;
        if (this.parent == null || this.triIndex == null) {
            return;
        }
        this.createBounds();
        this.bounds.computeFromTris(this.triIndex, this.batch, n, n2);
        if (n2 - n + 1 <= CollisionTreeManager.getInstance().getMaxTrisPerLeaf()) {
            return;
        }
        if (bl) {
            this.sortTris();
        }
        if (this.left == null) {
            this.left = new CollisionTree(this.type);
        }
        this.left.triIndex = this.triIndex;
        this.left.parent = this.parent;
        this.left.batch = this.batch;
        this.left.createTree(n, (n + n2) / 2, bl);
        if (this.right == null) {
            this.right = new CollisionTree(this.type);
        }
        this.right.triIndex = this.triIndex;
        this.right.parent = this.parent;
        this.right.batch = this.batch;
        this.right.createTree((n + n2) / 2, n2, bl);
    }

    public boolean intersectsBounding(BoundingVolume boundingVolume) {
        switch (boundingVolume.getType()) {
            case 1: {
                return this.worldBounds.intersectsBoundingBox((BoundingBox)boundingVolume);
            }
            case 2: {
                return this.worldBounds.intersectsOrientedBoundingBox((OrientedBoundingBox)boundingVolume);
            }
            case 0: {
                return this.worldBounds.intersectsSphere((BoundingSphere)boundingVolume);
            }
        }
        return false;
    }

    public boolean intersect(CollisionTree collisionTree) {
        if (collisionTree == null) {
            return false;
        }
        collisionTree.bounds.transform(collisionTree.parent.getWorldRotation(), collisionTree.parent.getWorldTranslation(), collisionTree.parent.getWorldScale(), collisionTree.worldBounds);
        if (!this.intersectsBounding(collisionTree.worldBounds)) {
            return false;
        }
        if (this.left != null) {
            if (collisionTree.intersect(this.left)) {
                return true;
            }
            return collisionTree.intersect(this.right);
        }
        if (collisionTree.left != null) {
            if (this.intersect(collisionTree.left)) {
                return true;
            }
            return this.intersect(collisionTree.right);
        }
        Quaternion quaternion = this.parent.getWorldRotation();
        Vector3f vector3f = this.parent.getWorldScale();
        Vector3f vector3f2 = this.parent.getWorldTranslation();
        Quaternion quaternion2 = collisionTree.parent.getWorldRotation();
        Vector3f vector3f3 = collisionTree.parent.getWorldScale();
        Vector3f vector3f4 = collisionTree.parent.getWorldTranslation();
        for (int i = this.start; i < this.end; ++i) {
            this.batch.getTriangle(this.triIndex[i], verts);
            quaternion.mult(tempVa.set(verts[0]).multLocal(vector3f), tempVa).addLocal(vector3f2);
            quaternion.mult(tempVb.set(verts[1]).multLocal(vector3f), tempVb).addLocal(vector3f2);
            quaternion.mult(tempVc.set(verts[2]).multLocal(vector3f), tempVc).addLocal(vector3f2);
            for (int j = collisionTree.start; j < collisionTree.end; ++j) {
                collisionTree.batch.getTriangle(collisionTree.triIndex[j], target);
                quaternion2.mult(tempVd.set(target[0]).multLocal(vector3f3), tempVd).addLocal(vector3f4);
                quaternion2.mult(tempVe.set(target[1]).multLocal(vector3f3), tempVe).addLocal(vector3f4);
                quaternion2.mult(tempVf.set(target[2]).multLocal(vector3f3), tempVf).addLocal(vector3f4);
                if (!Intersection.intersection(tempVa, tempVb, tempVc, tempVd, tempVe, tempVf)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersect(CollisionTree collisionTree, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        if (collisionTree == null) {
            return false;
        }
        collisionTree.bounds.transform(collisionTree.parent.getWorldRotation(), collisionTree.parent.getWorldTranslation(), collisionTree.parent.getWorldScale(), collisionTree.worldBounds);
        if (!this.intersectsBounding(collisionTree.worldBounds)) {
            return false;
        }
        if (this.left != null) {
            boolean bl = collisionTree.intersect(this.left, arrayList2, arrayList);
            bl = collisionTree.intersect(this.right, arrayList2, arrayList) || bl;
            return bl;
        }
        if (collisionTree.left != null) {
            boolean bl = this.intersect(collisionTree.left, arrayList, arrayList2);
            bl = this.intersect(collisionTree.right, arrayList, arrayList2) || bl;
            return bl;
        }
        Quaternion quaternion = this.parent.getWorldRotation();
        Vector3f vector3f = this.parent.getWorldScale();
        Vector3f vector3f2 = this.parent.getWorldTranslation();
        Quaternion quaternion2 = collisionTree.parent.getWorldRotation();
        Vector3f vector3f3 = collisionTree.parent.getWorldScale();
        Vector3f vector3f4 = collisionTree.parent.getWorldTranslation();
        boolean bl = false;
        for (int i = this.start; i < this.end; ++i) {
            this.batch.getTriangle(this.triIndex[i], verts);
            quaternion.mult(tempVa.set(verts[0]).multLocal(vector3f), tempVa).addLocal(vector3f2);
            quaternion.mult(tempVb.set(verts[1]).multLocal(vector3f), tempVb).addLocal(vector3f2);
            quaternion.mult(tempVc.set(verts[2]).multLocal(vector3f), tempVc).addLocal(vector3f2);
            for (int j = collisionTree.start; j < collisionTree.end; ++j) {
                collisionTree.batch.getTriangle(collisionTree.triIndex[j], target);
                quaternion2.mult(tempVd.set(target[0]).multLocal(vector3f3), tempVd).addLocal(vector3f4);
                quaternion2.mult(tempVe.set(target[1]).multLocal(vector3f3), tempVe).addLocal(vector3f4);
                quaternion2.mult(tempVf.set(target[2]).multLocal(vector3f3), tempVf).addLocal(vector3f4);
                if (!Intersection.intersection(tempVa, tempVb, tempVc, tempVd, tempVe, tempVf)) continue;
                bl = true;
                arrayList.add(this.triIndex[i]);
                arrayList2.add(collisionTree.triIndex[j]);
            }
        }
        return bl;
    }

    public void intersect(Ray ray, ArrayList<Integer> arrayList) {
        if (!this.worldBounds.intersects(ray)) {
            return;
        }
        if (this.left != null) {
            this.left.bounds.transform(this.parent.getWorldRotation(), this.parent.getWorldTranslation(), this.parent.getWorldScale(), this.left.worldBounds);
            this.left.intersect(ray, arrayList);
        }
        if (this.right != null) {
            this.right.bounds.transform(this.parent.getWorldRotation(), this.parent.getWorldTranslation(), this.parent.getWorldScale(), this.right.worldBounds);
            this.right.intersect(ray, arrayList);
        } else if (this.left == null) {
            for (int i = this.start; i < this.end; ++i) {
                this.batch.getTriangle(this.triIndex[i], verts);
                this.parent.localToWorld(verts[0], tempVa);
                this.parent.localToWorld(verts[1], tempVb);
                this.parent.localToWorld(verts[2], tempVc);
                if (!ray.intersect(tempVa, tempVb, tempVc)) continue;
                arrayList.add(this.triIndex[i]);
            }
        }
    }

    public BoundingVolume getBounds() {
        return this.bounds;
    }

    public BoundingVolume getWorldBounds() {
        return this.worldBounds;
    }

    public void setParent(TriMesh triMesh) {
        this.parent = triMesh;
        if (this.left != null) {
            this.left.setParent(triMesh);
        }
        if (this.right != null) {
            this.right.setParent(triMesh);
        }
    }

    private void createBounds() {
        switch (this.type) {
            case 1: {
                this.bounds = new BoundingBox();
                this.worldBounds = new BoundingBox();
                break;
            }
            case 0: {
                this.bounds = new OrientedBoundingBox();
                this.worldBounds = new OrientedBoundingBox();
                break;
            }
            case 2: {
                this.bounds = new BoundingSphere();
                this.worldBounds = new BoundingSphere();
                break;
            }
        }
    }

    public void sortTris() {
        switch (this.type) {
            case 1: {
                if (((BoundingBox)this.bounds).xExtent > ((BoundingBox)this.bounds).yExtent) {
                    if (((BoundingBox)this.bounds).xExtent > ((BoundingBox)this.bounds).zExtent) {
                        comparator.setAxis(0);
                        break;
                    }
                    comparator.setAxis(2);
                    break;
                }
                if (((BoundingBox)this.bounds).yExtent > ((BoundingBox)this.bounds).zExtent) {
                    comparator.setAxis(1);
                    break;
                }
                comparator.setAxis(2);
                break;
            }
            case 0: {
                if (((OrientedBoundingBox)this.bounds).extent.x > ((OrientedBoundingBox)this.bounds).extent.y) {
                    if (((OrientedBoundingBox)this.bounds).extent.x > ((OrientedBoundingBox)this.bounds).extent.z) {
                        comparator.setAxis(0);
                        break;
                    }
                    comparator.setAxis(2);
                    break;
                }
                if (((OrientedBoundingBox)this.bounds).extent.y > ((OrientedBoundingBox)this.bounds).extent.z) {
                    comparator.setAxis(1);
                    break;
                }
                comparator.setAxis(2);
                break;
            }
            case 2: {
                comparator.setAxis(0);
                break;
            }
        }
        comparator.setCenter(this.bounds.center);
        comparator.setBatch(this.batch);
        SortUtil.qsort(this.triIndex, this.start, this.end - 1, (Comparator)comparator);
    }

    public void rebuildLeaves(ArrayList<Integer> arrayList, int n) {
        this.rebuildLeaves(arrayList, n, 0);
    }

    private void rebuildLeaves(ArrayList<Integer> arrayList, int n, int n2) {
        int n3 = 0;
        ++n2;
        if (this.left == null && this.right == null) {
            boolean bl = false;
            while (n3 < arrayList.size()) {
                if (arrayList.get(n3) >= this.start && arrayList.get(n3) < this.end) {
                    arrayList.remove(n3);
                    if (bl) continue;
                    bl = true;
                    this.bounds.computeFromTris(this.triIndex, this.batch, this.start, this.end);
                    continue;
                }
                ++n3;
            }
        } else if (this.containsAnyLeaf(arrayList)) {
            if (this.left != null) {
                this.left.rebuildLeaves(arrayList, n, n2);
            }
            if (this.right != null) {
                this.right.rebuildLeaves(arrayList, n, n2);
            }
            if (n2 > n) {
                this.bounds.computeFromTris(this.triIndex, this.batch, this.start, this.end);
            }
        }
    }

    public boolean containsAnyLeaf(ArrayList<Integer> arrayList) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) < this.start || arrayList.get(i) >= this.end) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

