/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.PropertiesIO;
import com.jme.system.lwjgl.LWJGLPropertiesDialog;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractGame {
    private static final Logger logger = Logger.getLogger(AbstractGame.class.getName());
    protected boolean finished;
    private static final String JME_VERSION_TAG = "jME version 1.0";
    private static final String DEFAULT_IMAGE = "/jmetest/data/images/Monkey.png";
    protected static final int NEVER_SHOW_PROPS_DIALOG = 0;
    protected static final int FIRSTRUN_OR_NOCONFIGFILE_SHOW_PROPS_DIALOG = 1;
    protected static final int ALWAYS_SHOW_PROPS_DIALOG = 2;
    private int dialogBehaviour = 1;
    private URL dialogImage = null;
    protected PropertiesIO properties;
    protected DisplaySystem display;

    protected AbstractGame() {
    }

    public String getVersion() {
        return JME_VERSION_TAG;
    }

    protected void assertDisplayCreated() throws JmeException {
        if (this.display == null) {
            logger.severe("Display system is null.");
            throw new JmeException("Window must be created during initialization.");
        }
        if (!this.display.isCreated()) {
            logger.severe("Display system not initialized.");
            throw new JmeException("Window must be created during initialization.");
        }
    }

    public void setDialogBehaviour(int n) {
        URL uRL = null;
        try {
            uRL = AbstractGame.class.getResource(DEFAULT_IMAGE);
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "setDialogBehavior(int)", "Exception", exception);
        }
        if (uRL != null) {
            this.setDialogBehaviour(n, uRL);
        } else {
            this.setDialogBehaviour(n, DEFAULT_IMAGE);
        }
    }

    public void setDialogBehaviour(int n, String string) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("No such properties dialog behaviour");
        }
        this.dialogBehaviour = n;
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.dialogImage = uRL;
    }

    public void setDialogBehaviour(int n, URL uRL) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("No such properties dialog behaviour");
        }
        this.dialogBehaviour = n;
        this.dialogImage = uRL;
    }

    protected void getAttributes() {
        this.properties = new PropertiesIO("properties.cfg");
        boolean bl = this.properties.load();
        if (!bl && this.dialogBehaviour == 1 || this.dialogBehaviour == 2) {
            final AtomicReference<LWJGLPropertiesDialog> atomicReference = new AtomicReference<LWJGLPropertiesDialog>();
            final Stack<Runnable> stack = new Stack<Runnable>();
            try {
                if (EventQueue.isDispatchThread()) {
                    atomicReference.set(new LWJGLPropertiesDialog(this.properties, this.dialogImage, stack));
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            atomicReference.set(new LWJGLPropertiesDialog(AbstractGame.this.properties, AbstractGame.this.dialogImage, (Stack<Runnable>)stack));
                        }
                    });
                }
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "AbstractGame.getAttributes()", "Exception", exception);
                return;
            }
            while (atomicReference.get() == null || ((LWJGLPropertiesDialog)atomicReference.get()).isVisible()) {
                try {
                    while (!stack.isEmpty()) {
                        stack.pop().run();
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("Error waiting for dialog system, using defaults.");
                }
            }
            if (((LWJGLPropertiesDialog)atomicReference.get()).isCancelled()) {
                this.finish();
            }
        }
    }

    public abstract void start();

    public void finish() {
        this.finished = true;
    }

    protected abstract void quit();

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

